unit uPSI_ComCtrls;
{
This file has been generated by UnitParser v0.7, written by M. Knight
and updated by NP. v/d Spek and George Birbilis. 
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ROPS are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok's conv utility

}
interface
 

 
uses
   SysUtils
  ,Classes
  ,uPSComponent
  ,uPSRuntime
  ,uPSCompiler
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TPSImport_ComCtrls = class(TPSPlugin)
  public
    procedure CompileImport1(CompExec: TPSScript); override;
    procedure ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
  end;
 
 
{ compile-time registration functions }
procedure SIRegister_THeaderControl(CL: TPSPascalCompiler);
procedure SIRegister_TCustomHeaderControl(CL: TPSPascalCompiler);
procedure SIRegister_THeaderSections(CL: TPSPascalCompiler);
procedure SIRegister_THeaderSection(CL: TPSPascalCompiler);
procedure SIRegister_TTreeNodeExpandedState(CL: TPSPascalCompiler);
procedure SIRegister_TTreeView(CL: TPSPascalCompiler);
procedure SIRegister_TCustomTreeView(CL: TPSPascalCompiler);
procedure SIRegister_TTreeNodes(CL: TPSPascalCompiler);
procedure SIRegister_TTreeNodesEnumerator(CL: TPSPascalCompiler);
procedure SIRegister_TTreeNode(CL: TPSPascalCompiler);
procedure SIRegister_TTrackBar(CL: TPSPascalCompiler);
procedure SIRegister_TCustomTrackBar(CL: TPSPascalCompiler);
procedure SIRegister_TCoolBar(CL: TPSPascalCompiler);
procedure SIRegister_TCustomCoolBar(CL: TPSPascalCompiler);
procedure SIRegister_TCoolBands(CL: TPSPascalCompiler);
procedure SIRegister_TCoolBand(CL: TPSPascalCompiler);
procedure SIRegister_TToolBar(CL: TPSPascalCompiler);
procedure SIRegister_TToolBarEnumerator(CL: TPSPascalCompiler);
procedure SIRegister_TToolButton(CL: TPSPascalCompiler);
procedure SIRegister_TToolButtonActionLink(CL: TPSPascalCompiler);
procedure SIRegister_TUpDown(CL: TPSPascalCompiler);
procedure SIRegister_TCustomUpDown(CL: TPSPascalCompiler);
procedure SIRegister_TProgressBar(CL: TPSPascalCompiler);
procedure SIRegister_TCustomProgressBar(CL: TPSPascalCompiler);
procedure SIRegister_TListView(CL: TPSPascalCompiler);
procedure SIRegister_TCustomListView(CL: TPSPascalCompiler);
procedure SIRegister_TCustomListViewEditor(CL: TPSPascalCompiler);
procedure SIRegister_TListColumns(CL: TPSPascalCompiler);
procedure SIRegister_TListColumn(CL: TPSPascalCompiler);
procedure SIRegister_TOwnerDataListItems(CL: TPSPascalCompiler);
procedure SIRegister_TListItems(CL: TPSPascalCompiler);
procedure SIRegister_TListItemsEnumerator(CL: TPSPascalCompiler);
procedure SIRegister_TOwnerDataListItem(CL: TPSPascalCompiler);
procedure SIRegister_TListItem(CL: TPSPascalCompiler);
procedure SIRegister_TIconOptions(CL: TPSPascalCompiler);
procedure SIRegister_TTabControl(CL: TPSPascalCompiler);
procedure SIRegister_TTabControlNoteBookStrings(CL: TPSPascalCompiler);
procedure SIRegister_TTabControlStrings(CL: TPSPascalCompiler);
procedure SIRegister_TPageControl(CL: TPSPascalCompiler);
procedure SIRegister_TTabSheet(CL: TPSPascalCompiler);
procedure SIRegister_TCustomTabControl(CL: TPSPascalCompiler);
procedure SIRegister_TNBPages(CL: TPSPascalCompiler);
procedure SIRegister_TCustomPage(CL: TPSPascalCompiler);
procedure SIRegister_TStatusBar(CL: TPSPascalCompiler);
procedure SIRegister_TStatusPanels(CL: TPSPascalCompiler);
procedure SIRegister_TStatusPanel(CL: TPSPascalCompiler);
procedure SIRegister_ComCtrls(CL: TPSPascalCompiler);

{ run-time registration functions }
procedure RIRegister_ComCtrls_Routines(S: TPSExec);
procedure RIRegister_THeaderControl(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomHeaderControl(CL: TPSRuntimeClassImporter);
procedure RIRegister_THeaderSections(CL: TPSRuntimeClassImporter);
procedure RIRegister_THeaderSection(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTreeNodeExpandedState(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTreeView(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomTreeView(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTreeNodes(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTreeNodesEnumerator(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTreeNode(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTrackBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomTrackBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCoolBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomCoolBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCoolBands(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCoolBand(CL: TPSRuntimeClassImporter);
procedure RIRegister_TToolBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TToolBarEnumerator(CL: TPSRuntimeClassImporter);
procedure RIRegister_TToolButton(CL: TPSRuntimeClassImporter);
procedure RIRegister_TToolButtonActionLink(CL: TPSRuntimeClassImporter);
procedure RIRegister_TUpDown(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomUpDown(CL: TPSRuntimeClassImporter);
procedure RIRegister_TProgressBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomProgressBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListView(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomListView(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomListViewEditor(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListColumns(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListColumn(CL: TPSRuntimeClassImporter);
procedure RIRegister_TOwnerDataListItems(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListItems(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListItemsEnumerator(CL: TPSRuntimeClassImporter);
procedure RIRegister_TOwnerDataListItem(CL: TPSRuntimeClassImporter);
procedure RIRegister_TListItem(CL: TPSRuntimeClassImporter);
procedure RIRegister_TIconOptions(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTabControl(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTabControlNoteBookStrings(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTabControlStrings(CL: TPSRuntimeClassImporter);
procedure RIRegister_TPageControl(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTabSheet(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomTabControl(CL: TPSRuntimeClassImporter);
procedure RIRegister_TNBPages(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomPage(CL: TPSRuntimeClassImporter);
procedure RIRegister_TStatusBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TStatusPanels(CL: TPSRuntimeClassImporter);
procedure RIRegister_TStatusPanel(CL: TPSRuntimeClassImporter);
procedure RIRegister_ComCtrls(CL: TPSRuntimeClassImporter);

procedure Register;

implementation


uses
   Types
  ,Math
  ,LCLStrConsts
  ,LResources
  ,LCLIntf
  ,LCLType
  ,FileUtil
  ,LCLProc
  ,AvgLvlTree
  ,LMessages
  ,ImgList
  ,ActnList
  ,GraphType
  ,Graphics
  ,Menus
  ,Controls
  ,Forms
  ,StdCtrls
  ,ExtCtrls
  ,ToolWin
  ,Buttons
  ,Themes
  ,WSLCLClasses
  ,LCLClasses
  ,ComCtrls
  ;

type
  TTabControlStrings_Impl = TTabControlNoteBookStrings; 
 
procedure Register;
begin
  RegisterComponents('Pascal Script', [TPSImport_ComCtrls]);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_THeaderControl(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomHeaderControl', 'THeaderControl') do
  with CL.AddClassN(CL.FindClass('TCustomHeaderControl'),'THeaderControl') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomHeaderControl(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TCustomHeaderControl') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TCustomHeaderControl') do
  begin
    RegisterProperty('SectionFromOriginalIndex', 'THeaderSection Integer', iptr);
    RegisterMethod('Function GetSectionAt( P : TPoint) : Integer');
    RegisterMethod('Procedure PaintSection( Index : Integer)');
    RegisterProperty('DragReorder', 'boolean', iptrw);
    RegisterProperty('Images', 'TCustomImageList', iptrw);
    RegisterProperty('Sections', 'THeaderSections', iptrw);
    RegisterProperty('OnSectionDrag', 'TSectionDragEvent', iptrw);
    RegisterProperty('OnSectionEndDrag', 'TNotifyEvent', iptrw);
    RegisterProperty('OnSectionClick', 'TCustomSectionNotifyEvent', iptrw);
    RegisterProperty('OnSectionResize', 'TCustomSectionNotifyEvent', iptrw);
    RegisterProperty('OnSectionTrack', 'TCustomSectionTrackEvent', iptrw);
    RegisterProperty('OnSectionSeparatorDblClick', 'TCustomSectionNotifyEvent', iptrw);
    RegisterProperty('OnCreateSectionClass', 'TCustomHCCreateSectionClassEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_THeaderSections(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollection', 'THeaderSections') do
  with CL.AddClassN(CL.FindClass('TCollection'),'THeaderSections') do
  begin
    RegisterMethod('Constructor Create( HeaderControl : TCustomHeaderControl)');
    RegisterMethod('Function Add : THeaderSection');
    RegisterMethod('Function AddItem( Item : THeaderSection; Index : Integer) : THeaderSection');
    RegisterMethod('Function Insert( Index : Integer) : THeaderSection');
    RegisterMethod('Procedure Delete( Index : Integer)');
    RegisterProperty('Items', 'THeaderSection Integer', iptrw);
    SetDefaultPropery('Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_THeaderSection(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollectionItem', 'THeaderSection') do
  with CL.AddClassN(CL.FindClass('TCollectionItem'),'THeaderSection') do
  begin
    RegisterProperty('Left', 'Integer', iptr);
    RegisterProperty('Right', 'Integer', iptr);
    RegisterProperty('State', 'THeaderSectionState', iptrw);
    RegisterProperty('Alignment', 'TAlignment', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('MaxWidth', 'Integer', iptrw);
    RegisterProperty('MinWidth', 'Integer', iptrw);
    RegisterProperty('Text', 'TCaption', iptrw);
    RegisterProperty('Width', 'Integer', iptrw);
    RegisterProperty('Visible', 'Boolean', iptrw);
    RegisterProperty('OriginalIndex', 'Integer', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTreeNodeExpandedState(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TTreeNodeExpandedState') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TTreeNodeExpandedState') do
  begin
    RegisterProperty('NodeText', 'string', iptrw);
    RegisterProperty('Children', 'TAvgLvlTree', iptrw);
    RegisterMethod('Constructor Create( FirstTreeNode : TTreeNode)');
    RegisterMethod('Constructor Create( TreeView : TCustomTreeView)');
    RegisterMethod('Procedure Clear');
    RegisterMethod('Procedure CreateChildNodes( FirstTreeNode : TTreeNode)');
    RegisterMethod('Procedure Apply( FirstTreeNode : TTreeNode; CollapseToo : boolean)');
    RegisterMethod('Procedure Apply( TreeView : TCustomTreeView; CollapseToo : boolean)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTreeView(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTreeView', 'TTreeView') do
  with CL.AddClassN(CL.FindClass('TCustomTreeView'),'TTreeView') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomTreeView(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TCustomTreeView') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TCustomTreeView') do
  begin
    RegisterProperty('AccessibilityOn', 'Boolean', iptrw);
    RegisterMethod('Function AlphaSort : Boolean');
    RegisterMethod('Procedure ConsistencyCheck');
    RegisterMethod('Function CustomSort( SortProc : TTreeNodeCompare) : Boolean');
    RegisterMethod('Function DefaultTreeViewSort( Node1, Node2 : TTreeNode) : Integer');
    RegisterMethod('Function GetHitTestInfoAt( X, Y : Integer) : THitTests');
    RegisterMethod('Function GetNodeAt( X, Y : Integer) : TTreeNode');
    RegisterMethod('Procedure GetInsertMarkAt( X, Y : Integer; out AnInsertMarkNode : TTreeNode; out AnInsertMarkType : TTreeViewInsertMarkType)');
    RegisterMethod('Procedure SetInsertMark( AnInsertMarkNode : TTreeNode; AnInsertMarkType : TTreeViewInsertMarkType)');
    RegisterMethod('Procedure SetInsertMarkAt( X, Y : integer)');
    RegisterMethod('Function IsEditing : Boolean');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Procedure FullCollapse');
    RegisterMethod('Procedure FullExpand');
    RegisterMethod('Procedure LoadFromFile( const FileName : string)');
    RegisterMethod('Procedure LoadFromStream( Stream : TStream)');
    RegisterMethod('Procedure SaveToFile( const FileName : string)');
    RegisterMethod('Procedure SaveToStream( Stream : TStream)');
    RegisterMethod('Procedure WriteDebugReport( const Prefix : string; AllNodes : boolean)');
    RegisterMethod('Procedure LockSelectionChangeEvent');
    RegisterMethod('Procedure UnlockSelectionChangeEvent');
    RegisterMethod('Function GetFirstMultiSelected : TTreeNode');
    RegisterMethod('Function GetLastMultiSelected : TTreeNode');
    RegisterMethod('Function SelectionVisible : boolean');
    RegisterMethod('Procedure MakeSelectionVisible');
    RegisterMethod('Procedure ClearInvisibleSelection');
    RegisterMethod('Function StoreCurrentSelection : TStringList');
    RegisterMethod('Procedure ApplyStoredSelection( ASelection : TStringList; FreeList : boolean)');
    RegisterMethod('Procedure MoveToNextNode');
    RegisterMethod('Procedure MoveToPrevNode');
    RegisterProperty('BackgroundColor', 'TColor', iptrw);
    RegisterProperty('BottomItem', 'TTreeNode', iptrw);
    RegisterProperty('DefaultItemHeight', 'integer', iptrw);
    RegisterProperty('DropTarget', 'TTreeNode', iptrw);
    RegisterProperty('ExpandSignType', 'TTreeViewExpandSignType', iptrw);
    RegisterProperty('InsertMarkNode', 'TTreeNode', iptrw);
    RegisterProperty('InsertMarkType', 'TTreeViewInsertMarkType', iptrw);
    RegisterProperty('Items', 'TTreeNodes', iptrw);
    RegisterProperty('KeepCollapsedNodes', 'boolean', iptrw);
    RegisterProperty('MultiSelectStyle', 'TMultiSelectStyle', iptrw);
    RegisterProperty('Options', 'TTreeViewOptions', iptrw);
    RegisterProperty('ScrollBars', 'TScrollStyle', iptrw);
    RegisterProperty('Selected', 'TTreeNode', iptrw);
    RegisterProperty('SelectionColor', 'TColor', iptrw);
    RegisterProperty('SelectionCount', 'Cardinal', iptr);
    RegisterProperty('Selections', 'TTreeNode Integer', iptr);
    RegisterProperty('SeparatorColor', 'TColor', iptrw);
    RegisterProperty('TopItem', 'TTreeNode', iptrw);
    RegisterProperty('TreeLineColor', 'TColor', iptrw);
    RegisterProperty('TreeLinePenStyle', 'TPenStyle', iptrw);
    RegisterProperty('ExpandSignColor', 'TColor', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTreeNodes(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TTreeNodes') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TTreeNodes') do
  begin
    RegisterMethod('Constructor Create( AnOwner : TCustomTreeView)');
    RegisterMethod('Function Add( SiblingNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function AddChild( ParentNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function AddChildFirst( ParentNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function AddChildObject( ParentNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function AddChildObjectFirst( ParentNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function AddFirst( SiblingNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function AddNode( Node : TTreeNode; Relative : TTreeNode; const S : string; Ptr : Pointer; Method : TNodeAttachMode) : TTreeNode');
    RegisterMethod('Function AddObject( SiblingNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function AddObjectFirst( SiblingNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function FindNodeWithData( const NodeData : Pointer) : TTreeNode');
    RegisterMethod('Function FindNodeWithText( const NodeText : string) : TTreeNode');
    RegisterMethod('Function FindTopLvlNode( const NodeText : string) : TTreeNode');
    RegisterMethod('Function GetEnumerator : TTreeNodesEnumerator');
    RegisterMethod('Function GetFirstNode : TTreeNode');
    RegisterMethod('Function GetFirstVisibleNode : TTreeNode');
    RegisterMethod('Function GetLastExpandedSubNode : TTreeNode');
    RegisterMethod('Function GetLastNode : TTreeNode');
    RegisterMethod('Function GetLastSubNode : TTreeNode');
    RegisterMethod('Function GetLastVisibleNode : TTreeNode');
    RegisterMethod('Function GetSelections( const AIndex : Integer) : TTreeNode');
    RegisterMethod('Function Insert( NextNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function InsertBehind( PrevNode : TTreeNode; const S : string) : TTreeNode');
    RegisterMethod('Function InsertObject( NextNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function InsertObjectBehind( PrevNode : TTreeNode; const S : string; Data : Pointer) : TTreeNode');
    RegisterMethod('Function IsMultiSelection : boolean');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure Clear');
    RegisterMethod('Procedure ClearMultiSelection( ClearSelected : boolean)');
    RegisterMethod('Procedure ConsistencyCheck');
    RegisterMethod('Procedure Delete( Node : TTreeNode)');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Procedure FreeAllNodeData');
    RegisterMethod('Procedure SelectionsChanged( ANode : TTreeNode; const AIsSelected : Boolean)');
    RegisterMethod('Procedure SelectOnlyThis( Node : TTreeNode)');
    RegisterMethod('Procedure SortTopLevelNodes( SortProc : TTreeNodeCompare)');
    RegisterMethod('Procedure WriteDebugReport( const Prefix : string; AllNodes : boolean)');
    RegisterProperty('Count', 'Integer', iptr);
    RegisterProperty('Item', 'TTreeNode Integer', iptr);
    SetDefaultPropery('Item');
    RegisterProperty('KeepCollapsedNodes', 'boolean', iptrw);
    RegisterProperty('Owner', 'TCustomTreeView', iptr);
    RegisterProperty('SelectionCount', 'Cardinal', iptr);
    RegisterProperty('TopLvlCount', 'integer', iptr);
    RegisterProperty('TopLvlItems', 'TTreeNode integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTreeNodesEnumerator(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TTreeNodesEnumerator') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TTreeNodesEnumerator') do
  begin
    RegisterMethod('Constructor Create( ANodes : TTreeNodes)');
    RegisterMethod('Function MoveNext : Boolean');
    RegisterProperty('Current', 'TTreeNode', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTreeNode(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TTreeNode') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TTreeNode') do
  begin
    RegisterMethod('Constructor Create( AnOwner : TTreeNodes)');
    RegisterMethod('Function AlphaSort : Boolean');
    RegisterMethod('Function Bottom : integer');
    RegisterMethod('Function BottomExpanded : integer');
    RegisterMethod('Function CustomSort( SortProc : TTreeNodeCompare) : Boolean');
    RegisterMethod('Function DefaultTreeViewSort( Node1, Node2 : TTreeNode) : Integer');
    RegisterMethod('Function DisplayExpandSignLeft : integer');
    RegisterMethod('Function DisplayExpandSignRect : TRect');
    RegisterMethod('Function DisplayExpandSignRight : integer');
    RegisterMethod('Function DisplayIconLeft : integer');
    RegisterMethod('Function DisplayRect( TextOnly : Boolean) : TRect');
    RegisterMethod('Function DisplayStateIconLeft : integer');
    RegisterMethod('Function DisplayTextLeft : integer');
    RegisterMethod('Function DisplayTextRight : integer');
    RegisterMethod('Function EditText : Boolean');
    RegisterMethod('Function FindNode( const NodeText : string) : TTreeNode');
    RegisterMethod('Function GetFirstChild : TTreeNode');
    RegisterMethod('Function GetFirstVisibleChild : TTreeNode');
    RegisterMethod('Function GetHandle : THandle');
    RegisterMethod('Function GetLastChild : TTreeNode');
    RegisterMethod('Function GetLastSibling : TTreeNode');
    RegisterMethod('Function GetLastSubChild : TTreeNode');
    RegisterMethod('Function GetLastVisibleChild : TTreeNode');
    RegisterMethod('Function GetNext : TTreeNode');
    RegisterMethod('Function GetNextChild( AValue : TTreeNode) : TTreeNode');
    RegisterMethod('Function GetNextExpanded : TTreeNode');
    RegisterMethod('Function GetNextMultiSelected : TTreeNode');
    RegisterMethod('Function GetNextSibling : TTreeNode');
    RegisterMethod('Function GetNextSkipChildren : TTreeNode');
    RegisterMethod('Function GetNextVisible : TTreeNode');
    RegisterMethod('Function GetNextVisibleSibling : TTreeNode');
    RegisterMethod('Function GetParentNodeOfAbsoluteLevel( TheAbsoluteLevel : integer) : TTreeNode');
    RegisterMethod('Function GetPrev : TTreeNode');
    RegisterMethod('Function GetPrevChild( AValue : TTreeNode) : TTreeNode');
    RegisterMethod('Function GetPrevExpanded : TTreeNode');
    RegisterMethod('Function GetPrevMultiSelected : TTreeNode');
    RegisterMethod('Function GetPrevSibling : TTreeNode');
    RegisterMethod('Function GetPrevVisible : TTreeNode');
    RegisterMethod('Function GetPrevVisibleSibling : TTreeNode');
    RegisterMethod('Function GetTextPath : string');
    RegisterMethod('Function HasAsParent( AValue : TTreeNode) : Boolean');
    RegisterMethod('Function IndexOf( AValue : TTreeNode) : Integer');
    RegisterMethod('Function IndexOfText( const NodeText : string) : Integer');
    RegisterMethod('Procedure Collapse( Recurse : Boolean)');
    RegisterMethod('Procedure ConsistencyCheck');
    RegisterMethod('Procedure Delete');
    RegisterMethod('Procedure DeleteChildren');
    RegisterMethod('Procedure EndEdit( Cancel : Boolean)');
    RegisterMethod('Procedure Expand( Recurse : Boolean)');
    RegisterMethod('Procedure ExpandParents');
    RegisterMethod('Procedure FreeAllNodeData');
    RegisterMethod('Procedure MakeVisible');
    RegisterMethod('Procedure MoveTo( Destination : TTreeNode; Mode : TNodeAttachMode)');
    RegisterMethod('Procedure MultiSelectGroup');
    RegisterMethod('Procedure Update');
    RegisterMethod('Procedure WriteDebugReport( const Prefix : string; Recurse : boolean)');
    RegisterProperty('AbsoluteIndex', 'Integer', iptr);
    RegisterProperty('Count', 'Integer', iptr);
    RegisterProperty('Cut', 'Boolean', iptrw);
    RegisterProperty('Data', 'Pointer', iptrw);
    RegisterProperty('Deleting', 'Boolean', iptr);
    RegisterProperty('DropTarget', 'Boolean', iptrw);
    RegisterProperty('Expanded', 'Boolean', iptrw);
    RegisterProperty('Focused', 'Boolean', iptrw);
    RegisterProperty('Handle', 'THandle', iptr);
    RegisterProperty('HasChildren', 'Boolean', iptrw);
    RegisterProperty('Height', 'integer', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('Index', 'Integer', iptrw);
    RegisterProperty('IsFullHeightVisible', 'Boolean', iptr);
    RegisterProperty('IsVisible', 'Boolean', iptr);
    RegisterProperty('Items', 'TTreeNode Integer', iptrw);
    SetDefaultPropery('Items');
    RegisterProperty('Level', 'Integer', iptr);
    RegisterProperty('MultiSelected', 'Boolean', iptrw);
    RegisterProperty('NodeEffect', 'TGraphicsDrawEffect', iptrw);
    RegisterProperty('OverlayIndex', 'Integer', iptrw);
    RegisterProperty('Owner', 'TTreeNodes', iptr);
    RegisterProperty('Parent', 'TTreeNode', iptr);
    RegisterProperty('Selected', 'Boolean', iptrw);
    RegisterProperty('SelectedIndex', 'Integer', iptrw);
    RegisterProperty('StateIndex', 'Integer', iptrw);
    RegisterProperty('SubTreeCount', 'integer', iptr);
    RegisterProperty('Text', 'string', iptrw);
    RegisterProperty('Top', 'integer', iptr);
    RegisterProperty('TreeNodes', 'TTreeNodes', iptr);
    RegisterProperty('TreeView', 'TCustomTreeView', iptr);
    RegisterProperty('Visible', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTrackBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTrackBar', 'TTrackBar') do
  with CL.AddClassN(CL.FindClass('TCustomTrackBar'),'TTrackBar') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomTrackBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TCustomTrackBar') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TCustomTrackBar') do
  begin
    RegisterMethod('Procedure SetTick( Value : Integer)');
    RegisterProperty('Frequency', 'Integer', iptrw);
    RegisterProperty('LineSize', 'Integer', iptrw);
    RegisterProperty('Max', 'Integer', iptrw);
    RegisterProperty('Min', 'Integer', iptrw);
    RegisterProperty('OnChange', 'TNotifyEvent', iptrw);
    RegisterProperty('Orientation', 'TTrackBarOrientation', iptrw);
    RegisterProperty('PageSize', 'Integer', iptrw);
    RegisterProperty('Position', 'Integer', iptrw);
    RegisterProperty('Reversed', 'Boolean', iptrw);
    RegisterProperty('ScalePos', 'TTrackBarScalePos', iptrw);
    RegisterProperty('SelEnd', 'Integer', iptrw);
    RegisterProperty('SelStart', 'Integer', iptrw);
    RegisterProperty('ShowSelRange', 'Boolean', iptrw);
    RegisterProperty('TickMarks', 'TTickMark', iptrw);
    RegisterProperty('TickStyle', 'TTickStyle', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCoolBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomCoolBar', 'TCoolBar') do
  with CL.AddClassN(CL.FindClass('TCustomCoolBar'),'TCoolBar') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomCoolBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TToolWindow', 'TCustomCoolBar') do
  with CL.AddClassN(CL.FindClass('TToolWindow'),'TCustomCoolBar') do
  begin
    RegisterProperty('BandBorderStyle', 'TBorderStyle', iptrw);
    RegisterProperty('BandMaximize', 'TCoolBandMaximize', iptrw);
    RegisterProperty('Bands', 'TCoolBands', iptrw);
    RegisterProperty('FixedSize', 'Boolean', iptrw);
    RegisterProperty('FixedOrder', 'Boolean', iptrw);
    RegisterProperty('Images', 'TCustomImageList', iptrw);
    RegisterProperty('Bitmap', 'TBitmap', iptrw);
    RegisterProperty('ShowText', 'Boolean', iptrw);
    RegisterProperty('Vertical', 'Boolean', iptrw);
    RegisterProperty('OnChange', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCoolBands(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollection', 'TCoolBands') do
  with CL.AddClassN(CL.FindClass('TCollection'),'TCoolBands') do
  begin
    RegisterMethod('Constructor Create( aCoolBar : TCustomCoolBar)');
    RegisterMethod('Function Add : TCoolBand');
    RegisterMethod('Function FindBand( aControl : TControl) : TCoolBand');
    RegisterProperty('Items', 'TCoolBand Integer', iptrw);
    SetDefaultPropery('Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCoolBand(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollectionItem', 'TCoolBand') do
  with CL.AddClassN(CL.FindClass('TCollectionItem'),'TCoolBand') do
  begin
    RegisterProperty('Height', 'Integer', iptr);
    RegisterProperty('Bitmap', 'TBitmap', iptrw);
    RegisterProperty('BorderStyle', 'TBorderStyle', iptrw);
    RegisterProperty('Break', 'Boolean', iptrw);
    RegisterProperty('Color', 'TColor', iptrw);
    RegisterProperty('Control', 'TControl', iptrw);
    RegisterProperty('FixedBackground', 'Boolean', iptrw);
    RegisterProperty('FixedSize', 'Boolean', iptrw);
    RegisterProperty('HorizontalOnly', 'Boolean', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('MinHeight', 'Integer', iptrw);
    RegisterProperty('MinWidth', 'Integer', iptrw);
    RegisterProperty('ParentColor', 'Boolean', iptrw);
    RegisterProperty('ParentBitmap', 'Boolean', iptrw);
    RegisterProperty('Text', 'string', iptrw);
    RegisterProperty('Visible', 'Boolean', iptrw);
    RegisterProperty('Width', 'Integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TToolBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TToolWindow', 'TToolBar') do
  with CL.AddClassN(CL.FindClass('TToolWindow'),'TToolBar') do
  begin
    RegisterMethod('Function GetEnumerator : TToolBarEnumerator');
    RegisterMethod('Procedure SetButtonSize( NewButtonWidth, NewButtonHeight : integer)');
    RegisterProperty('ButtonCount', 'Integer', iptr);
    RegisterProperty('Buttons', 'TToolButton Integer', iptr);
    RegisterProperty('ButtonList', 'TList', iptr);
    RegisterProperty('RowCount', 'Integer', iptr);
    RegisterProperty('ButtonHeight', 'Integer', iptrw);
    RegisterProperty('ButtonWidth', 'Integer', iptrw);
    RegisterProperty('DisabledImages', 'TCustomImageList', iptrw);
    RegisterProperty('Flat', 'Boolean', iptrw);
    RegisterProperty('HotImages', 'TCustomImageList', iptrw);
    RegisterProperty('Images', 'TCustomImageList', iptrw);
    RegisterProperty('Indent', 'Integer', iptrw);
    RegisterProperty('List', 'Boolean', iptrw);
    RegisterProperty('ShowCaptions', 'Boolean', iptrw);
    RegisterProperty('Transparent', 'Boolean', iptrw);
    RegisterProperty('Wrapable', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TToolBarEnumerator(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TToolBarEnumerator') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TToolBarEnumerator') do
  begin
    RegisterMethod('Constructor Create( AToolBar : TToolBar)');
    RegisterMethod('Function MoveNext : Boolean');
    RegisterProperty('Current', 'TToolButton', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TToolButton(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TGraphicControl', 'TToolButton') do
  with CL.AddClassN(CL.FindClass('TGraphicControl'),'TToolButton') do
  begin
    RegisterMethod('Function CheckMenuDropdown : Boolean');
    RegisterMethod('Procedure GetCurrentIcon( var ImageList : TCustomImageList; var TheIndex : integer)');
    RegisterProperty('Index', 'Integer', iptr);
    RegisterProperty('AllowAllUp', 'Boolean', iptrw);
    RegisterProperty('Down', 'Boolean', iptrw);
    RegisterProperty('DropdownMenu', 'TPopupMenu', iptrw);
    RegisterProperty('Grouped', 'Boolean', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('Indeterminate', 'Boolean', iptrw);
    RegisterProperty('Marked', 'Boolean', iptrw);
    RegisterProperty('MenuItem', 'TMenuItem', iptrw);
    RegisterProperty('ShowCaption', 'boolean', iptrw);
    RegisterProperty('Style', 'TToolButtonStyle', iptrw);
    RegisterProperty('Wrap', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TToolButtonActionLink(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TControlActionLink', 'TToolButtonActionLink') do
  with CL.AddClassN(CL.FindClass('TControlActionLink'),'TToolButtonActionLink') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TUpDown(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomUpDown', 'TUpDown') do
  with CL.AddClassN(CL.FindClass('TCustomUpDown'),'TUpDown') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomUpDown(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TCustomUpDown') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TCustomUpDown') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TProgressBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomProgressBar', 'TProgressBar') do
  with CL.AddClassN(CL.FindClass('TCustomProgressBar'),'TProgressBar') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomProgressBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TCustomProgressBar') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TCustomProgressBar') do
  begin
    RegisterMethod('Procedure StepIt');
    RegisterMethod('Procedure StepBy( Delta : Integer)');
    RegisterProperty('Max', 'Integer', iptrw);
    RegisterProperty('Min', 'Integer', iptrw);
    RegisterProperty('Orientation', 'TProgressBarOrientation', iptrw);
    RegisterProperty('Position', 'Integer', iptrw);
    RegisterProperty('Smooth', 'boolean', iptrw);
    RegisterProperty('Step', 'Integer', iptrw);
    RegisterProperty('Style', 'TProgressBarStyle', iptrw);
    RegisterProperty('BarShowText', 'boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListView(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomListView', 'TListView') do
  with CL.AddClassN(CL.FindClass('TCustomListView'),'TListView') do
  begin
    RegisterProperty('AutoWidthLastColumn', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomListView(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TCustomListView') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TCustomListView') do
  begin
    RegisterMethod('Function AlphaSort : Boolean');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure Clear');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Function FindCaption( StartIndex : Integer; Value : string; Partial, Inclusive, Wrap : Boolean; PartStart : Boolean) : TListItem');
    RegisterMethod('Function FindData( StartIndex : Integer; Value : Pointer; Inclusive, Wrap : Boolean) : TListItem');
    RegisterMethod('Function GetHitTestInfoAt( X, Y : Integer) : THitTests');
    RegisterMethod('Function GetItemAt( x, y : integer) : TListItem');
    RegisterMethod('Function GetNearestItem( APoint : TPoint; Direction : TSearchDirection) : TListItem');
    RegisterMethod('Function GetNextItem( StartItem : TListItem; Direction : TSearchDirection; States : TListItemStates) : TListItem');
    RegisterMethod('Function IsEditing : Boolean');
    RegisterProperty('BoundingRect', 'TRect', iptr);
    RegisterProperty('Canvas', 'TCanvas', iptr);
    RegisterProperty('Checkboxes', 'Boolean', iptrw);
    RegisterProperty('Column', 'TListColumn Integer', iptr);
    RegisterProperty('ColumnCount', 'Integer', iptr);
    RegisterProperty('DropTarget', 'TListItem', iptrw);
    RegisterProperty('FlatScrollBars', 'Boolean', iptrw);
    RegisterProperty('FullDrag', 'Boolean', iptrw);
    RegisterProperty('GridLines', 'Boolean', iptrw);
    RegisterProperty('HotTrack', 'Boolean', iptrw);
    RegisterProperty('HotTrackStyles', 'TListHotTrackStyles', iptrw);
    RegisterProperty('IconOptions', 'TIconOptions', iptrw);
    RegisterProperty('ItemFocused', 'TListItem', iptrw);
    RegisterProperty('ItemIndex', 'Integer', iptrw);
    RegisterProperty('Items', 'TListItems', iptrw);
    RegisterProperty('MultiSelect', 'Boolean', iptrw);
    RegisterProperty('OwnerData', 'Boolean', iptrw);
    RegisterProperty('ReadOnly', 'Boolean', iptrw);
    RegisterProperty('RowSelect', 'Boolean', iptrw);
    RegisterProperty('SelCount', 'Integer', iptr);
    RegisterProperty('Selected', 'TListItem', iptrw);
    RegisterProperty('TopItem', 'TListItem', iptr);
    RegisterProperty('ViewOrigin', 'TPoint', iptrw);
    RegisterProperty('VisibleRowCount', 'Integer', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomListViewEditor(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomEdit', 'TCustomListViewEditor') do
  with CL.AddClassN(CL.FindClass('TCustomEdit'),'TCustomListViewEditor') do
  begin
    RegisterProperty('Item', 'TListItem', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListColumns(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollection', 'TListColumns') do
  with CL.AddClassN(CL.FindClass('TCollection'),'TListColumns') do
  begin
    RegisterMethod('Constructor Create( AOwner : TCustomListView)');
    RegisterMethod('Function Add : TListColumn');
    RegisterProperty('Owner', 'TCustomListView', iptr);
    RegisterProperty('Items', 'TListColumn Integer', iptrw);
    SetDefaultPropery('Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListColumn(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollectionItem', 'TListColumn') do
  with CL.AddClassN(CL.FindClass('TCollectionItem'),'TListColumn') do
  begin
    RegisterProperty('WidthType', 'TWidth', iptr);
    RegisterProperty('Alignment', 'TAlignment', iptrw);
    RegisterProperty('AutoSize', 'Boolean', iptrw);
    RegisterProperty('Caption', 'TTranslateString', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('MaxWidth', 'TWidth', iptrw);
    RegisterProperty('MinWidth', 'TWidth', iptrw);
    RegisterProperty('Tag', 'Integer', iptrw);
    RegisterProperty('Visible', 'Boolean', iptrw);
    RegisterProperty('Width', 'TWidth', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TOwnerDataListItems(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TListItems', 'TOwnerDataListItems') do
  with CL.AddClassN(CL.FindClass('TListItems'),'TOwnerDataListItems') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListItems(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TListItems') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TListItems') do
  begin
    RegisterMethod('Function Add : TListItem');
    RegisterMethod('Procedure AddItem( AItem : TListItem)');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure Clear');
    RegisterMethod('Constructor Create( AOwner : TCustomListView)');
    RegisterMethod('Procedure Delete( const AIndex : Integer)');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Procedure Exchange( const AIndex1, AIndex2 : Integer)');
    RegisterMethod('Procedure Move( const AFromIndex, AToIndex : Integer)');
    RegisterMethod('Function FindCaption( StartIndex : Integer; Value : string; Partial, Inclusive, Wrap : Boolean; PartStart : Boolean) : TListItem');
    RegisterMethod('Function FindData0( const AData : Pointer) : TListItem;');
    RegisterMethod('Function FindData1( StartIndex : Integer; Value : Pointer; Inclusive, Wrap : Boolean) : TListItem;');
    RegisterMethod('Function GetEnumerator : TListItemsEnumerator');
    RegisterMethod('Function IndexOf( const AItem : TListItem) : Integer');
    RegisterMethod('Function Insert( const AIndex : Integer) : TListItem');
    RegisterMethod('Procedure InsertItem( AItem : TListItem; const AIndex : Integer)');
    RegisterProperty('Flags', 'TListItemsFlags', iptr);
    RegisterProperty('Count', 'Integer', iptrw);
    RegisterProperty('Item', 'TListItem Integer', iptrw);
    SetDefaultPropery('Item');
    RegisterProperty('Owner', 'TCustomListView', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListItemsEnumerator(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TListItemsEnumerator') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TListItemsEnumerator') do
  begin
    RegisterMethod('Constructor Create( AItems : TListItems)');
    RegisterMethod('Function MoveNext : Boolean');
    RegisterProperty('Current', 'TListItem', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TOwnerDataListItem(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TListItem', 'TOwnerDataListItem') do
  with CL.AddClassN(CL.FindClass('TListItem'),'TOwnerDataListItem') do
  begin
    RegisterMethod('Procedure SetDataIndex( ADataIndex : Integer)');
    RegisterMethod('Procedure SetOwner( AOwner : TListItems)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TListItem(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TListItem') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TListItem') do
  begin
    RegisterMethod('Constructor Create( AOwner : TListItems)');
    RegisterMethod('Procedure Delete');
    RegisterMethod('Procedure MakeVisible( PartialOK : Boolean)');
    RegisterMethod('Function DisplayRect( Code : TDisplayCode) : TRect');
    RegisterMethod('Function DisplayRectSubItem( subItem : integer; Code : TDisplayCode) : TRect');
    RegisterMethod('Function EditCaption : Boolean');
    RegisterProperty('Caption', 'String', iptrw);
    RegisterProperty('Checked', 'Boolean', iptrw);
    RegisterProperty('Cut', 'Boolean', iptrw);
    RegisterProperty('Data', 'Pointer', iptrw);
    RegisterProperty('DropTarget', 'Boolean', iptrw);
    RegisterProperty('Focused', 'Boolean', iptrw);
    RegisterProperty('Index', 'Integer', iptr);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('Left', 'Integer', iptrw);
    RegisterProperty('ListView', 'TCustomListView', iptr);
    RegisterProperty('Owner', 'TListItems', iptr);
    RegisterProperty('Position', 'TPoint', iptrw);
    RegisterProperty('Selected', 'Boolean', iptrw);
    RegisterProperty('StateIndex', 'TImageIndex', iptrw);
    RegisterProperty('SubItems', 'TStrings', iptrw);
    RegisterProperty('SubItemImages', 'Integer Integer', iptrw);
    RegisterProperty('Top', 'Integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIconOptions(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TIconOptions') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TIconOptions') do
  begin
    RegisterMethod('Constructor Create( AOwner : TCustomListView)');
    RegisterProperty('Arrangement', 'TIconArrangement', iptrw);
    RegisterProperty('AutoArrange', 'Boolean', iptrw);
    RegisterProperty('WrapText', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTabControl(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTabControl', 'TTabControl') do
  with CL.AddClassN(CL.FindClass('TCustomTabControl'),'TTabControl') do
  begin
    RegisterMethod('Function IndexOfTabAt( X, Y : Integer) : Integer');
    RegisterMethod('Function GetHitTestInfoAt( X, Y : Integer) : THitTests');
    RegisterMethod('Function IndexOfTabWithCaption( const TabCaption : string) : Integer');
    RegisterMethod('Function TabRect( Index : Integer) : TRect');
    RegisterMethod('Function RowCount : Integer');
    RegisterMethod('Procedure ScrollTabs( Delta : Integer)');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Function IsUpdating : boolean');
    RegisterProperty('DisplayRect', 'TRect', iptr);
    RegisterProperty('HotTrack', 'Boolean', iptrw);
    RegisterProperty('MultiLine', 'Boolean', iptrw);
    RegisterProperty('MultiSelect', 'Boolean', iptrw);
    RegisterProperty('OnChange', 'TNotifyEvent', iptrw);
    RegisterProperty('OwnerDraw', 'Boolean', iptrw);
    RegisterProperty('RaggedRight', 'Boolean', iptrw);
    RegisterProperty('ScrollOpposite', 'Boolean', iptrw);
    RegisterProperty('TabHeight', 'Smallint', iptrw);
    RegisterProperty('TabWidth', 'Smallint', iptrw);
    RegisterProperty('TabIndex', 'Integer', iptrw);
    RegisterProperty('Tabs', 'TStrings', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTabControlNoteBookStrings(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TTabControlStrings', 'TTabControlNoteBookStrings') do
  with CL.AddClassN(CL.FindClass('TTabControlStrings'),'TTabControlNoteBookStrings') do
  begin
    RegisterProperty('NoteBook', 'TCustomTabControl', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTabControlStrings(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TStrings', 'TTabControlStrings') do
  with CL.AddClassN(CL.FindClass('TStrings'),'TTabControlStrings') do
  begin
    RegisterMethod('Constructor Create( TheTabControl : TTabControl)');
    RegisterMethod('Function GetHitTestInfoAt( X, Y : Integer) : THitTests');
    RegisterMethod('Function GetSize : integer');
    RegisterMethod('Function IndexOfTabAt( X, Y : Integer) : Integer');
    RegisterMethod('Function RowCount : Integer');
    RegisterMethod('Function TabRect( Index : Integer) : TRect');
    RegisterMethod('Procedure ImageListChange( Sender : TObject)');
    RegisterMethod('Procedure ScrollTabs( Delta : Integer)');
    RegisterMethod('Procedure TabControlBoundsChange');
    RegisterMethod('Procedure UpdateTabImages');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Function IsUpdating : boolean');
    RegisterProperty('TabControl', 'TTabControl', iptr);
    RegisterProperty('TabIndex', 'integer', iptrw);
    RegisterProperty('HotTrack', 'Boolean', iptrw);
    RegisterProperty('Images', 'TCustomImageList', iptrw);
    RegisterProperty('MultiLine', 'Boolean', iptrw);
    RegisterProperty('MultiSelect', 'Boolean', iptrw);
    RegisterProperty('OwnerDraw', 'Boolean', iptrw);
    RegisterProperty('RaggedRight', 'Boolean', iptrw);
    RegisterProperty('ScrollOpposite', 'Boolean', iptrw);
    RegisterProperty('TabHeight', 'Smallint', iptrw);
    RegisterProperty('TabWidth', 'Smallint', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TPageControl(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTabControl', 'TPageControl') do
  with CL.AddClassN(CL.FindClass('TCustomTabControl'),'TPageControl') do
  begin
    RegisterMethod('Function FindNextPage( CurPage : TTabSheet; GoForward, CheckTabVisible : Boolean) : TTabSheet');
    RegisterMethod('Procedure SelectNextPage( GoForward : Boolean)');
    RegisterMethod('Procedure SelectNextPage( GoForward : Boolean; CheckTabVisible : Boolean)');
    RegisterMethod('Function AddTabSheet : TTabSheet');
    RegisterProperty('ActivePageIndex', 'Integer', iptrw);
    RegisterProperty('Pages', 'TTabSheet Integer', iptr);
    RegisterProperty('ActivePage', 'TTabSheet', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTabSheet(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomPage', 'TTabSheet') do
  with CL.AddClassN(CL.FindClass('TCustomPage'),'TTabSheet') do
  begin
    RegisterProperty('PageControl', 'TPageControl', iptrw);
    RegisterProperty('TabIndex', 'Integer', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomTabControl(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TCustomTabControl') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TCustomTabControl') do
  begin
    RegisterMethod('Function TabIndexAtClientPos( ClientPos : TPoint) : integer');
    RegisterMethod('Function TabRect( AIndex : Integer) : TRect');
    RegisterMethod('Function GetImageIndex( ThePageIndex : Integer) : Integer');
    RegisterMethod('Function IndexOf( APage : TPersistent) : integer');
    RegisterMethod('Function CustomPage( Index : integer) : TCustomPage');
    RegisterMethod('Function CanChangePageIndex : boolean');
    RegisterMethod('Function GetMinimumTabWidth : integer');
    RegisterMethod('Function GetMinimumTabHeight : integer');
    RegisterMethod('Function GetCapabilities : TNoteBookCapabilities');
    RegisterMethod('Function TabToPageIndex( AIndex : integer) : integer');
    RegisterMethod('Function PageToTabIndex( AIndex : integer) : integer');
    RegisterMethod('Function IndexOfTabAt( X, Y : Integer) : Integer');
    RegisterMethod('Procedure DoCloseTabClicked( APage : TCustomPage)');
    RegisterProperty('Images', 'TCustomImageList', iptrw);
    RegisterProperty('MultiLine', 'Boolean', iptrw);
    RegisterProperty('OnChanging', 'TTabChangingEvent', iptrw);
    RegisterProperty('OnCloseTabClicked', 'TNotifyEvent', iptrw);
    RegisterProperty('OnGetImageIndex', 'TTabGetImageEvent', iptrw);
    RegisterProperty('Options', 'TCTabControlOptions', iptrw);
    RegisterProperty('Page', 'TCustomPage Integer', iptr);
    RegisterProperty('PageCount', 'integer', iptr);
    RegisterProperty('PageIndex', 'Integer', iptrw);
    RegisterProperty('Pages', 'TStrings', iptrw);
    RegisterProperty('ShowTabs', 'Boolean', iptrw);
    RegisterProperty('TabPosition', 'TTabPosition', iptrw);
    RegisterProperty('IsUnpaged', 'boolean', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TNBPages(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TStrings', 'TNBPages') do
  with CL.AddClassN(CL.FindClass('TStrings'),'TNBPages') do
  begin
    RegisterMethod('Constructor Create( thePageList : TListWithEvent; theNotebook : TCustomTabControl)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomPage(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TCustomPage') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TCustomPage') do
  begin
    RegisterMethod('Function VisibleIndex : integer');
    RegisterProperty('PageIndex', 'Integer', iptrw);
    RegisterProperty('TabVisible', 'Boolean', iptrw);
    RegisterProperty('ImageIndex', 'TImageIndex', iptrw);
    RegisterProperty('OnHide', 'TNotifyEvent', iptrw);
    RegisterProperty('OnShow', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TStatusBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TWinControl', 'TStatusBar') do
  with CL.AddClassN(CL.FindClass('TWinControl'),'TStatusBar') do
  begin
    RegisterMethod('Procedure InvalidatePanel( PanelIndex : integer; PanelParts : TPanelParts)');
    RegisterMethod('Procedure BeginUpdate');
    RegisterMethod('Procedure EndUpdate');
    RegisterMethod('Function GetPanelIndexAt( X, Y : Integer) : Integer');
    RegisterMethod('Function SizeGripEnabled : Boolean');
    RegisterMethod('Function UpdatingStatusBar : boolean');
    RegisterProperty('Canvas', 'TCanvas', iptr);
    RegisterProperty('AutoHint', 'Boolean', iptrw);
    RegisterProperty('Panels', 'TStatusPanels', iptrw);
    RegisterProperty('SimpleText', 'TCaption', iptrw);
    RegisterProperty('SimplePanel', 'Boolean', iptrw);
    RegisterProperty('SizeGrip', 'Boolean', iptrw);
    RegisterProperty('OnCreatePanelClass', 'TSBCreatePanelClassEvent', iptrw);
    RegisterProperty('OnDrawPanel', 'TDrawPanelEvent', iptrw);
    RegisterProperty('OnHint', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TStatusPanels(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollection', 'TStatusPanels') do
  with CL.AddClassN(CL.FindClass('TCollection'),'TStatusPanels') do
  begin
    RegisterMethod('Constructor Create( AStatusBar : TStatusBar)');
    RegisterMethod('Function Add : TStatusPanel');
    RegisterProperty('Items', 'TStatusPanel Integer', iptrw);
    SetDefaultPropery('Items');
    RegisterProperty('StatusBar', 'TStatusBar', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TStatusPanel(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCollectionItem', 'TStatusPanel') do
  with CL.AddClassN(CL.FindClass('TCollectionItem'),'TStatusPanel') do
  begin
    RegisterMethod('Function StatusBar : TStatusBar');
    RegisterProperty('Alignment', 'TAlignment', iptrw);
    RegisterProperty('Bevel', 'TStatusPanelBevel', iptrw);
    RegisterProperty('Style', 'TStatusPanelStyle', iptrw);
    RegisterProperty('Text', 'TCaption', iptrw);
    RegisterProperty('Width', 'Integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_ComCtrls(CL: TPSPascalCompiler);
begin
  CL.AddTypeS('THitTest', '( htAbove, htBelow, htNowhere, htOnItem, htOnButton,'
   +' htOnIcon, htOnIndent, htOnLabel, htOnRight, htOnStateIcon, htToLeft, htTo'
   +'Right )');
  CL.AddTypeS('THitTests', 'set of THitTest');
  CL.AddTypeS('TStatusPanelStyle', '( psText, psOwnerDraw )');
  CL.AddTypeS('TStatusPanelBevel', '( pbNone, pbLowered, pbRaised )');
  CL.AddTypeS('TPanelPart', '( ppText, ppBorder, ppWidth )');
  CL.AddTypeS('TPanelParts', 'set of TPanelPart');
  //CL.AddTypeS('TStatusPanelClass', 'class of TStatusPanel');
  SIRegister_TStatusPanel(CL);
  SIRegister_TStatusPanels(CL);
  CL.AddTypeS('TSBCreatePanelClassEvent', 'Procedure ( Sender : TStatusBar; var'
   +' PanelClass : TStatusPanelClass)');
  CL.AddTypeS('TDrawPanelEvent', 'Procedure ( StatusBar : TStatusBar; Panel : T'
   +'StatusPanel; const Rect : TRect)');
  SIRegister_TStatusBar(CL);
  CL.AddTypeS('TPageFlag', '( pfAdded, pfAdding, pfRemoving, pfInserting )');
  CL.AddTypeS('TPageFlags', 'set of TPageFlag');
  SIRegister_TCustomPage(CL);
  //CL.AddTypeS('TCustomPageClass', 'class of TCustomPage');
  SIRegister_TNBPages(CL);
  CL.AddTypeS('TTabChangingEvent', 'Procedure ( Sender : TObject; var AllowChan'
   +'ge : Boolean)');
  CL.AddTypeS('TTabPosition', '( tpTop, tpBottom, tpLeft, tpRight )');
  CL.AddTypeS('TTabStyle', '( tsTabs, tsButtons, tsFlatButtons )');
  CL.AddTypeS('TTabGetImageEvent', 'Procedure ( Sender : TObject; TabIndex : In'
   +'teger; var ImageIndex : Integer)');
  CL.AddTypeS('TCTabControlOption', '( nboShowCloseButtons, nboMultiLine, nboHi'
   +'dePageListPopup, nboKeyboardTabSwitch, nboShowAddTabButton )');
  CL.AddTypeS('TCTabControlOptions', 'set of TCTabControlOption');
  CL.AddTypeS('TCTabControlCapability', '( nbcShowCloseButtons, nbcMultiLine, n'
   +'bcPageListPopup, nbcShowAddTabButton )');
  CL.AddTypeS('TCTabControlCapabilities', 'set of TCTabControlCapability');
  CL.AddTypeS('TNoteBookOption', 'TCTabControlOption');
  CL.AddTypeS('TNoteBookOptions', 'TCTabControlOptions');
  CL.AddTypeS('TNoteBookCapability', 'TCTabControlCapability');
  CL.AddTypeS('TNoteBookCapabilities', 'TCTabControlCapabilities');
  CL.AddTypeS('TDrawTabEvent', 'Procedure ( Control : TCustomTabControl; TabInd'
   +'ex : Integer; const Rect : TRect; Active : Boolean)');
  SIRegister_TCustomTabControl(CL);
  SIRegister_TTabSheet(CL);
  SIRegister_TPageControl(CL);
  SIRegister_TTabControlStrings(CL);
  SIRegister_TTabControlNoteBookStrings(CL);
  SIRegister_TTabControl(CL);
  CL.AddTypeS('TCustomDrawTarget', '( dtControl, dtItem, dtSubItem )');
  CL.AddTypeS('TCustomDrawStage', '( cdPrePaint, cdPostPaint, cdPreErase, cdPos'
   +'tErase )');
  CL.AddTypeS('TCustomDrawStateFlag', '( cdsSelected, cdsGrayed, cdsDisabled, c'
   +'dsChecked, cdsFocused, cdsDefault, cdsHot, cdsMarked, cdsIndeterminate )');
  CL.AddTypeS('TCustomDrawState', 'set of TCustomDrawStateFlag');
  CL.AddTypeS('TCustomDrawResultFlag', '( cdrSkipDefault, cdrNotifyPostpaint, c'
   +'drNotifyItemdraw, cdrNotifySubitemdraw, cdrNotifyPosterase, cdrNotifyIteme'
   +'rase )');
  CL.AddTypeS('TCustomDrawResult', 'set of TCustomDrawResultFlag');
  CL.AddTypeS('TSortType', '( stNone, stData, stText, stBoth )');
  CL.AddTypeS('TListItemState', '( lisCut, lisDropTarget, lisFocused, lisSelect'
   +'ed )');
  CL.AddTypeS('TListItemStates', 'set of TListItemState');
  CL.AddTypeS('TListItemFlag', '( lifDestroying, lifCreated )');
  CL.AddTypeS('TListItemFlags', 'set of TListItemFlag');
  CL.AddTypeS('TDisplayCode', '( drBounds, drIcon, drLabel, drSelectBounds )');
  CL.AddTypeS('TIconArrangement', '( iaTop, iaLeft )');
  SIRegister_TIconOptions(CL);
  SIRegister_TListItem(CL);
  //CL.AddTypeS('TListItemClass', 'class of TListItem');
  SIRegister_TOwnerDataListItem(CL);
  SIRegister_TListItemsEnumerator(CL);
  CL.AddTypeS('TListItemsFlag', '( lisfWSItemsCreated )');
  CL.AddTypeS('TListItemsFlags', 'set of TListItemsFlag');
  SIRegister_TListItems(CL);
  SIRegister_TOwnerDataListItems(CL);
  CL.AddTypeS('TWidth', 'Integer');
  SIRegister_TListColumn(CL);
  SIRegister_TListColumns(CL);
  CL.AddTypeS('TItemChange', '( ctText, ctImage, ctState )');
  CL.AddTypeS('TViewStyle', '( vsIcon, vsSmallIcon, vsList, vsReport )');
  CL.AddTypeS('TItemFind', '( ifData, ifPartialString, ifExactString, ifNearest'
   +' )');
  CL.AddTypeS('TSearchDirection', '( sdLeft, sdRight, sdAbove, sdBelow, sdAll )');
  CL.AddTypeS('TLVChangeEvent', 'Procedure ( Sender : TObject; Item : TListItem'
   +'; Change : TItemChange)');
  CL.AddTypeS('TLVDataFindEvent', 'Procedure ( Sender : TObject; AFind : TItemF'
   +'ind; const AFindString : string; const AFindPosition : TPoint; AFindData :'
   +' Pointer; AStartIndex : Integer; ADirection : TSearchDirection; AWrap : Bo'
   +'olean; var AIndex : Integer)');
  CL.AddTypeS('TLVDataHintEvent', 'Procedure ( Sender : TObject; StartIndex, En'
   +'dIndex : Integer)');
  CL.AddTypeS('TLVDataStateChangeEvent', 'Procedure ( Sender : TObject; StartIn'
   +'dex, EndIndex : Integer; OldState, NewState : TListItemStates)');
  CL.AddTypeS('TLVColumnClickEvent', 'Procedure ( Sender : TObject; Column : TL'
   +'istColumn)');
  CL.AddTypeS('TLVColumnRClickEvent', 'Procedure ( Sender : TObject; Column : T'
   +'ListColumn; Point : TPoint)');
  CL.AddTypeS('TLVCompareEvent', 'Procedure ( Sender : TObject; Item1, Item2 : '
   +'TListItem; Data : Integer; var Compare : Integer)');
  CL.AddTypeS('TLVDeletedEvent', 'Procedure ( Sender : TObject; Item : TListIte'
   +'m)');
  CL.AddTypeS('TLVEditingEvent', 'Procedure ( Sender : TObject; Item : TListIte'
   +'m; var AllowEdit : Boolean)');
  CL.AddTypeS('TLVEditedEvent', 'Procedure ( Sender : TObject; Item : TListItem'
   +'; var AValue : string)');
  CL.AddTypeS('TLVInsertEvent', 'TLVDeletedEvent');
  CL.AddTypeS('TLVDataEvent', 'TLVDeletedEvent');
  CL.AddTypeS('TLVCheckedItemEvent', 'Procedure ( Sender : TObject; Item : TLis'
   +'tItem)');
  CL.AddTypeS('TLVSelectItemEvent', 'Procedure ( Sender : TObject; Item : TList'
   +'Item; Selected : Boolean)');
  CL.AddTypeS('TLVCustomDrawEvent', 'Procedure ( Sender : TCustomListView; cons'
   +'t ARect : TRect; var DefaultDraw : Boolean)');
  CL.AddTypeS('TLVCustomDrawItemEvent', 'Procedure ( Sender : TCustomListView; '
   +'Item : TListItem; State : TCustomDrawState; var DefaultDraw : Boolean)');
  CL.AddTypeS('TLVCustomDrawSubItemEvent', 'Procedure ( Sender : TCustomListVie'
   +'w; Item : TListItem; SubItem : Integer; State : TCustomDrawState; var Defa'
   +'ultDraw : Boolean)');
  CL.AddTypeS('TLVAdvancedCustomDrawEvent', 'Procedure ( Sender : TCustomListVi'
   +'ew; const ARect : TRect; Stage : TCustomDrawStage; var DefaultDraw : Boole'
   +'an)');
  CL.AddTypeS('TLVAdvancedCustomDrawItemEvent', 'Procedure ( Sender : TCustomLi'
   +'stView; Item : TListItem; State : TCustomDrawState; Stage : TCustomDrawSta'
   +'ge; var DefaultDraw : Boolean)');
  CL.AddTypeS('TLVAdvancedCustomDrawSubItemEvent', 'Procedure ( Sender : TCusto'
   +'mListView; Item : TListItem; SubItem : Integer; State : TCustomDrawState; '
   +'Stage : TCustomDrawStage; var DefaultDraw : Boolean)');
  CL.AddTypeS('TLVCreateItemClassEvent', 'Procedure ( Sender : TCustomListView;'
   +' var ItemClass : TListItemClass)');
  CL.AddTypeS('TListViewProperty', '( lvpAutoArrange, lvpCheckboxes, lvpColumnC'
   +'lick, lvpFlatScrollBars, lvpFullDrag, lvpGridLines, lvpHideSelection, lvpH'
   +'otTrack, lvpMultiSelect, lvpOwnerDraw, lvpReadOnly, lvpRowSelect, lvpShowC'
   +'olumnHeaders, lvpShowWorkAreas, lvpWrapText, lvpToolTips )');
  CL.AddTypeS('TListViewProperties', 'set of TListViewProperty');
  CL.AddTypeS('TListViewImageList', '( lvilSmall, lvilLarge, lvilState )');
  CL.AddTypeS('TListHotTrackStyle', '( htHandPoint, htUnderlineCold, htUnderlin'
   +'eHot )');
  CL.AddTypeS('TListHotTrackStyles', 'set of TListHotTrackStyle');
  CL.AddTypeS('TListViewFlag', '( lffSelectedValid, lffItemsMoving, lffItemsSor'
   +'ting, lffPreparingSorting )');
  CL.AddTypeS('TListViewFlags', 'set of TListViewFlag');
  CL.AddTypeS('TSortDirection', '( sdAscending, sdDescending )');
  SIRegister_TCustomListViewEditor(CL);
  SIRegister_TCustomListView(CL);
  SIRegister_TListView(CL);
  CL.AddTypeS('TProgressBarOrientation', '( pbHorizontal, pbVertical, pbRightTo'
   +'Left, pbTopDown )');
  CL.AddTypeS('TProgressBarStyle', '( pbstNormal, pbstMarquee )');
  SIRegister_TCustomProgressBar(CL);
  SIRegister_TProgressBar(CL);
  CL.AddTypeS('TUDAlignButton', '( udLeft, udRight, udTop, udBottom )');
  CL.AddTypeS('TUDOrientation', '( udHorizontal, udVertical )');
  CL.AddTypeS('TUpDownDirection', '( updNone, updUp, updDown )');
  CL.AddTypeS('TUDBtnType', '( btNext, btPrev )');
  CL.AddTypeS('TUDClickEvent', 'Procedure ( Sender : TObject; Button : TUDBtnTy'
   +'pe)');
  CL.AddTypeS('TUDChangingEvent', 'Procedure ( Sender : TObject; var AllowChang'
   +'e : Boolean)');
  CL.AddTypeS('TUDChangingEventEx', 'Procedure ( Sender : TObject; var AllowCha'
   +'nge : Boolean; NewValue : SmallInt; Direction : TUpDownDirection)');
  SIRegister_TCustomUpDown(CL);
  SIRegister_TUpDown(CL);
 CL.AddConstantN('CN_DROPDOWNCLOSED','LongWord').SetUInt( LM_USER + $1000);
  CL.AddTypeS('TToolButtonStyle', '( tbsButton, tbsCheck, tbsDropDown, tbsSepar'
   +'ator, tbsDivider )');
  CL.AddTypeS('TToolButtonFlag', '( tbfPressed, tbfArrowPressed )');
  CL.AddTypeS('TToolButtonFlags', 'set of TToolButtonFlag');
  SIRegister_TToolButtonActionLink(CL);
  //CL.AddTypeS('TToolButtonActionLinkClass', 'class of TToolButtonActionLink');
  SIRegister_TToolButton(CL);
  SIRegister_TToolBarEnumerator(CL);
  CL.AddTypeS('TToolBarFlag', '( tbfUpdateVisibleBarNeeded, tbfPlacingControls '
   +')');
  CL.AddTypeS('TToolBarFlags', 'set of TToolBarFlag');
  SIRegister_TToolBar(CL);
  SIRegister_TCoolBand(CL);
  SIRegister_TCoolBands(CL);
  CL.AddTypeS('TCoolBandMaximize', '( bmNone, bmClick, bmDblClick )');
  SIRegister_TCustomCoolBar(CL);
  SIRegister_TCoolBar(CL);
  CL.AddTypeS('TTrackBarOrientation', '( trHorizontal, trVertical )');
  CL.AddTypeS('TTickMark', '( tmBottomRight, tmTopLeft, tmBoth )');
  CL.AddTypeS('TTickStyle', '( tsNone, tsAuto, tsManual )');
  CL.AddTypeS('TTrackBarScalePos', '( trLeft, trRight, trTop, trBottom )');
  SIRegister_TCustomTrackBar(CL);
  SIRegister_TTrackBar(CL);
  //CL.AddTypeS('TTreeNodeClass', 'class of TTreeNode');
  CL.AddTypeS('TNodeState', '( nsCut, nsDropHilited, nsFocused, nsSelected, nsM'
   +'ultiSelected, nsExpanded, nsHasChildren, nsInTree, nsDeleting, nsBound )');
  CL.AddTypeS('TNodeStates', 'set of TNodeState');
  CL.AddTypeS('TNodeAttachMode', '( naAdd, naAddFirst, naAddChild, naAddChildFi'
   +'rst, naInsert, naInsertBehind )');
  CL.AddTypeS('TAddMode', '( taAddFirst, taAdd, taInsert )');
  CL.AddTypeS('TMultiSelectStyles', '( msControlSelect, msShiftSelect, msVisibl'
   +'eOnly, msSiblingOnly )');
  CL.AddTypeS('TMultiSelectStyle', 'set of TMultiSelectStyles');
  CL.AddTypeS('TTreeNodeArray', '^TTreeNode // will not work');
  CL.AddClassN(CL.FindClass('TOBJECT'),'ETreeNodeError');
  CL.AddClassN(CL.FindClass('TOBJECT'),'ETreeViewError');
 CL.AddConstantN('LCLStreamID','LongInt').SetInt( - 7);
  CL.AddTypeS('TTVChangingEvent', 'Procedure ( Sender : TObject; Node : TTreeNo'
   +'de; var AllowChange : Boolean)');
  CL.AddTypeS('TTVChangedEvent', 'Procedure ( Sender : TObject; Node : TTreeNod'
   +'e)');
  CL.AddTypeS('TTVEditingEvent', 'Procedure ( Sender : TObject; Node : TTreeNod'
   +'e; var AllowEdit : Boolean)');
  CL.AddTypeS('TTVEditingEndEvent', 'Procedure ( Sender : TObject; Node : TTree'
   +'Node; Cancel : Boolean)');
  CL.AddTypeS('TTVEditedEvent', 'Procedure ( Sender : TObject; Node : TTreeNode'
   +'; var S : string)');
  CL.AddTypeS('TTVExpandingEvent', 'Procedure ( Sender : TObject; Node : TTreeN'
   +'ode; var AllowExpansion : Boolean)');
  CL.AddTypeS('TTVCollapsingEvent', 'Procedure ( Sender : TObject; Node : TTree'
   +'Node; var AllowCollapse : Boolean)');
  CL.AddTypeS('TTVExpandedEvent', 'Procedure ( Sender : TObject; Node : TTreeNo'
   +'de)');
  CL.AddTypeS('TTVCompareEvent', 'Procedure ( Sender : TObject; Node1, Node2 : '
   +'TTreeNode; var Compare : Integer)');
  CL.AddTypeS('TTVCustomDrawEvent', 'Procedure ( Sender : TCustomTreeView; cons'
   +'t ARect : TRect; var DefaultDraw : Boolean)');
  CL.AddTypeS('TTVCustomDrawItemEvent', 'Procedure ( Sender : TCustomTreeView; '
   +'Node : TTreeNode; State : TCustomDrawState; var DefaultDraw : Boolean)');
  CL.AddTypeS('TTVAdvancedCustomDrawEvent', 'Procedure ( Sender : TCustomTreeVi'
   +'ew; const ARect : TRect; Stage : TCustomDrawStage; var DefaultDraw : Boole'
   +'an)');
  CL.AddTypeS('TTVAdvancedCustomDrawItemEvent', 'Procedure ( Sender : TCustomTr'
   +'eeView; Node : TTreeNode; State : TCustomDrawState; Stage : TCustomDrawSta'
   +'ge; var PaintImages, DefaultDraw : Boolean)');
  CL.AddTypeS('TTVCustomCreateNodeEvent', 'Procedure ( Sender : TCustomTreeView'
   +'; var ATreeNode : TTreenode)');
  CL.AddTypeS('TTVCreateNodeClassEvent', 'Procedure ( Sender : TCustomTreeView;'
   +' var NodeClass : TTreeNodeClass)');
  CL.AddTypeS('TTreeNodeCompare', 'Function ( Node1, Node2 : TTreeNode) : integ'
   +'er');
  CL.AddTypeS('TOldTreeNodeInfo', 'record ImageIndex : Integer; SelectedIndex :'
   +' Integer; StateIndex : Integer; OverlayIndex : Integer; Data : Pointer; Co'
   +'unt : Integer; Height : integer; Expanded : boolean; TextLen : integer; en'
   +'d');
  CL.AddTypeS('TTreeNodeInfo', 'record ImageIndex : Integer; SelectedIndex : In'
   +'teger; StateIndex : Integer; OverlayIndex : Integer; Count : Integer; Heig'
   +'ht : integer; Expanded : boolean; TextLen : integer; end');
  CL.AddTypeS('PDelphiNodeInfo', '^TDelphiNodeInfo // will not work');
  CL.AddTypeS('TDelphiNodeInfo', 'record ImageIndex : Integer; SelectedIndex : '
   +'Integer; StateIndex : Integer; OverlayIndex : Integer; Data : Pointer; Cou'
   +'nt : Integer; Text : string; end');
  SIRegister_TTreeNode(CL);
  SIRegister_TTreeNodesEnumerator(CL);
  CL.AddTypeS('PNodeCache', '^TNodeCache // will not work');
  CL.AddTypeS('TNodeCache', 'record CacheNode : TTreeNode; CacheIndex : Integer'
   +'; end');
  SIRegister_TTreeNodes(CL);
  CL.AddTypeS('TTreeViewState', '( tvsScrollbarChanged, tvsMaxRightNeedsUpdate,'
   +' tvsTopsNeedsUpdate, tvsMaxLvlNeedsUpdate, tvsTopItemNeedsUpdate, tvsBotto'
   +'mItemNeedsUpdate, tvsCanvasChanged, tvsDragged, tvsIsEditing, tvsStateChan'
   +'ging, tvsManualNotify, tvsUpdating, tvsPainting, tvoFocusedPainting, tvsDb'
   +'lClicked, tvsTripleClicked, tvsQuadClicked, tvsSelectionChanged, tvsEditOn'
   +'MouseUp )');
  CL.AddTypeS('TTreeViewStates', 'set of TTreeViewState');
  CL.AddTypeS('TTreeViewOption', '( tvoAllowMultiselect, tvoAutoExpand, tvoAuto'
   +'InsertMark, tvoAutoItemHeight, tvoHideSelection, tvoHotTrack, tvoKeepColla'
   +'psedNodes, tvoReadOnly, tvoRightClickSelect, tvoRowSelect, tvoShowButtons,'
   +' tvoShowLines, tvoShowRoot, tvoShowSeparators, tvoToolTips, tvoNoDoubleCli'
   +'ckExpand, tvoThemedDraw )');
  CL.AddTypeS('TTreeViewOptions', 'set of TTreeViewOption');
 CL.AddConstantN('DefaultTreeViewOptions','LongInt').Value.ts32 := ord(tvoShowRoot) or ord(tvoShowLines) or ord(tvoShowButtons) or ord(tvoHideSelection) or ord(tvoToolTips) or ord(tvoKeepCollapsedNodes) or ord(tvoAutoItemHeight) or ord(tvoThemedDraw);
 CL.AddConstantN('DefaultMultiSelectStyle','LongInt').Value.ts32 := ord(msControlSelect);
  CL.AddTypeS('TTreeViewExpandSignType', '( tvestTheme, tvestPlusMinus, tvestAr'
   +'row )');
  CL.AddTypeS('TTreeViewInsertMarkType', '( tvimNone, tvimAsFirstChild, tvimAsN'
   +'extSibling, tvimAsPrevSibling )');
  SIRegister_TCustomTreeView(CL);
  SIRegister_TTreeView(CL);
  SIRegister_TTreeNodeExpandedState(CL);
  CL.AddTypeS('THeaderSectionState', '( hsNormal, hsHot, hsPressed )');
  SIRegister_THeaderSection(CL);
  //CL.AddTypeS('THeaderSectionClass', 'class of THeaderSection');
  SIRegister_THeaderSections(CL);
  CL.AddTypeS('TSectionTrackState', '( tsTrackBegin, tsTrackMove, tsTrackEnd )');
  CL.AddTypeS('TCustomSectionTrackEvent', 'Procedure ( HeaderControl : TCustomH'
   +'eaderControl; Section : THeaderSection; Width : Integer; State : TSectionT'
   +'rackState)');
  CL.AddTypeS('TSectionDragEvent', 'Procedure ( Sender : TObject; FromSection, '
   +'ToSection : THeaderSection; var AllowDrag : Boolean)');
  CL.AddTypeS('TCustomSectionNotifyEvent', 'Procedure ( HeaderControl : TCustom'
   +'HeaderControl; Section : THeaderSection)');
  CL.AddTypeS('TCustomHCCreateSectionClassEvent', 'Procedure ( Sender : TCustom'
   +'HeaderControl; var SectionClass : THeaderSectionClass)');
  SIRegister_TCustomHeaderControl(CL);
  SIRegister_THeaderControl(CL);
 CL.AddConstantN('TCN_First','LongInt').SetInt( 0 - 550);
 CL.AddConstantN('TCN_SELCHANGE','LongInt').SetInt( TCN_FIRST - 1);
 CL.AddConstantN('TCN_SELCHANGING','LongInt').SetInt( TCN_FIRST - 2);
 CL.AddDelphiFunction('Function CompareExpandedNodes( Data1, Data2 : Pointer) : integer');
 CL.AddDelphiFunction('Function CompareTextWithExpandedNode( Key, Data : Pointer) : integer');
 CL.AddDelphiFunction('Procedure Register');
 CL.AddDelphiFunction('Procedure RegisterCustomPage');
 CL.AddDelphiFunction('Procedure RegisterCustomTabControl');
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnCreateSectionClass_W(Self: TCustomHeaderControl; const T: TCustomHCCreateSectionClassEvent);
begin Self.OnCreateSectionClass := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnCreateSectionClass_R(Self: TCustomHeaderControl; var T: TCustomHCCreateSectionClassEvent);
begin T := Self.OnCreateSectionClass; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionSeparatorDblClick_W(Self: TCustomHeaderControl; const T: TCustomSectionNotifyEvent);
begin Self.OnSectionSeparatorDblClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionSeparatorDblClick_R(Self: TCustomHeaderControl; var T: TCustomSectionNotifyEvent);
begin T := Self.OnSectionSeparatorDblClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionTrack_W(Self: TCustomHeaderControl; const T: TCustomSectionTrackEvent);
begin Self.OnSectionTrack := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionTrack_R(Self: TCustomHeaderControl; var T: TCustomSectionTrackEvent);
begin T := Self.OnSectionTrack; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionResize_W(Self: TCustomHeaderControl; const T: TCustomSectionNotifyEvent);
begin Self.OnSectionResize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionResize_R(Self: TCustomHeaderControl; var T: TCustomSectionNotifyEvent);
begin T := Self.OnSectionResize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionClick_W(Self: TCustomHeaderControl; const T: TCustomSectionNotifyEvent);
begin Self.OnSectionClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionClick_R(Self: TCustomHeaderControl; var T: TCustomSectionNotifyEvent);
begin T := Self.OnSectionClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionEndDrag_W(Self: TCustomHeaderControl; const T: TNotifyEvent);
begin Self.OnSectionEndDrag := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionEndDrag_R(Self: TCustomHeaderControl; var T: TNotifyEvent);
begin T := Self.OnSectionEndDrag; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionDrag_W(Self: TCustomHeaderControl; const T: TSectionDragEvent);
begin Self.OnSectionDrag := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlOnSectionDrag_R(Self: TCustomHeaderControl; var T: TSectionDragEvent);
begin T := Self.OnSectionDrag; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlSections_W(Self: TCustomHeaderControl; const T: THeaderSections);
begin Self.Sections := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlSections_R(Self: TCustomHeaderControl; var T: THeaderSections);
begin T := Self.Sections; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlImages_W(Self: TCustomHeaderControl; const T: TCustomImageList);
begin Self.Images := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlImages_R(Self: TCustomHeaderControl; var T: TCustomImageList);
begin T := Self.Images; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlDragReorder_W(Self: TCustomHeaderControl; const T: boolean);
begin Self.DragReorder := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlDragReorder_R(Self: TCustomHeaderControl; var T: boolean);
begin T := Self.DragReorder; end;

(*----------------------------------------------------------------------------*)
procedure TCustomHeaderControlSectionFromOriginalIndex_R(Self: TCustomHeaderControl; var T: THeaderSection; const t1: Integer);
begin T := Self.SectionFromOriginalIndex[t1]; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionsItems_W(Self: THeaderSections; const T: THeaderSection; const t1: Integer);
begin Self.Items[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionsItems_R(Self: THeaderSections; var T: THeaderSection; const t1: Integer);
begin T := Self.Items[t1]; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionOriginalIndex_R(Self: THeaderSection; var T: Integer);
begin T := Self.OriginalIndex; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionVisible_W(Self: THeaderSection; const T: Boolean);
begin Self.Visible := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionVisible_R(Self: THeaderSection; var T: Boolean);
begin T := Self.Visible; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionWidth_W(Self: THeaderSection; const T: Integer);
begin Self.Width := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionWidth_R(Self: THeaderSection; var T: Integer);
begin T := Self.Width; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionText_W(Self: THeaderSection; const T: TCaption);
begin Self.Text := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionText_R(Self: THeaderSection; var T: TCaption);
begin T := Self.Text; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionMinWidth_W(Self: THeaderSection; const T: Integer);
begin Self.MinWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionMinWidth_R(Self: THeaderSection; var T: Integer);
begin T := Self.MinWidth; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionMaxWidth_W(Self: THeaderSection; const T: Integer);
begin Self.MaxWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionMaxWidth_R(Self: THeaderSection; var T: Integer);
begin T := Self.MaxWidth; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionImageIndex_W(Self: THeaderSection; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionImageIndex_R(Self: THeaderSection; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionAlignment_W(Self: THeaderSection; const T: TAlignment);
begin Self.Alignment := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionAlignment_R(Self: THeaderSection; var T: TAlignment);
begin T := Self.Alignment; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionState_W(Self: THeaderSection; const T: THeaderSectionState);
begin Self.State := T; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionState_R(Self: THeaderSection; var T: THeaderSectionState);
begin T := Self.State; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionRight_R(Self: THeaderSection; var T: Integer);
begin T := Self.Right; end;

(*----------------------------------------------------------------------------*)
procedure THeaderSectionLeft_R(Self: THeaderSection; var T: Integer);
begin T := Self.Left; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpandedStateChildren_W(Self: TTreeNodeExpandedState; const T: TAvgLvlTree);
Begin Self.Children := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpandedStateChildren_R(Self: TTreeNodeExpandedState; var T: TAvgLvlTree);
Begin T := Self.Children; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpandedStateNodeText_W(Self: TTreeNodeExpandedState; const T: string);
Begin Self.NodeText := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpandedStateNodeText_R(Self: TTreeNodeExpandedState; var T: string);
Begin T := Self.NodeText; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewExpandSignColor_W(Self: TCustomTreeView; const T: TColor);
begin Self.ExpandSignColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewExpandSignColor_R(Self: TCustomTreeView; var T: TColor);
begin T := Self.ExpandSignColor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTreeLinePenStyle_W(Self: TCustomTreeView; const T: TPenStyle);
begin Self.TreeLinePenStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTreeLinePenStyle_R(Self: TCustomTreeView; var T: TPenStyle);
begin T := Self.TreeLinePenStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTreeLineColor_W(Self: TCustomTreeView; const T: TColor);
begin Self.TreeLineColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTreeLineColor_R(Self: TCustomTreeView; var T: TColor);
begin T := Self.TreeLineColor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTopItem_W(Self: TCustomTreeView; const T: TTreeNode);
begin Self.TopItem := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewTopItem_R(Self: TCustomTreeView; var T: TTreeNode);
begin T := Self.TopItem; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSeparatorColor_W(Self: TCustomTreeView; const T: TColor);
begin Self.SeparatorColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSeparatorColor_R(Self: TCustomTreeView; var T: TColor);
begin T := Self.SeparatorColor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelections_R(Self: TCustomTreeView; var T: TTreeNode; const t1: Integer);
begin T := Self.Selections[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelectionCount_R(Self: TCustomTreeView; var T: Cardinal);
begin T := Self.SelectionCount; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelectionColor_W(Self: TCustomTreeView; const T: TColor);
begin Self.SelectionColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelectionColor_R(Self: TCustomTreeView; var T: TColor);
begin T := Self.SelectionColor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelected_W(Self: TCustomTreeView; const T: TTreeNode);
begin Self.Selected := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewSelected_R(Self: TCustomTreeView; var T: TTreeNode);
begin T := Self.Selected; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewScrollBars_W(Self: TCustomTreeView; const T: TScrollStyle);
begin Self.ScrollBars := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewScrollBars_R(Self: TCustomTreeView; var T: TScrollStyle);
begin T := Self.ScrollBars; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewOptions_W(Self: TCustomTreeView; const T: TTreeViewOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewOptions_R(Self: TCustomTreeView; var T: TTreeViewOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewMultiSelectStyle_W(Self: TCustomTreeView; const T: TMultiSelectStyle);
begin Self.MultiSelectStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewMultiSelectStyle_R(Self: TCustomTreeView; var T: TMultiSelectStyle);
begin T := Self.MultiSelectStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewKeepCollapsedNodes_W(Self: TCustomTreeView; const T: boolean);
begin Self.KeepCollapsedNodes := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewKeepCollapsedNodes_R(Self: TCustomTreeView; var T: boolean);
begin T := Self.KeepCollapsedNodes; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewItems_W(Self: TCustomTreeView; const T: TTreeNodes);
begin Self.Items := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewItems_R(Self: TCustomTreeView; var T: TTreeNodes);
begin T := Self.Items; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewInsertMarkType_W(Self: TCustomTreeView; const T: TTreeViewInsertMarkType);
begin Self.InsertMarkType := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewInsertMarkType_R(Self: TCustomTreeView; var T: TTreeViewInsertMarkType);
begin T := Self.InsertMarkType; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewInsertMarkNode_W(Self: TCustomTreeView; const T: TTreeNode);
begin Self.InsertMarkNode := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewInsertMarkNode_R(Self: TCustomTreeView; var T: TTreeNode);
begin T := Self.InsertMarkNode; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewExpandSignType_W(Self: TCustomTreeView; const T: TTreeViewExpandSignType);
begin Self.ExpandSignType := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewExpandSignType_R(Self: TCustomTreeView; var T: TTreeViewExpandSignType);
begin T := Self.ExpandSignType; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewDropTarget_W(Self: TCustomTreeView; const T: TTreeNode);
begin Self.DropTarget := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewDropTarget_R(Self: TCustomTreeView; var T: TTreeNode);
begin T := Self.DropTarget; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewDefaultItemHeight_W(Self: TCustomTreeView; const T: integer);
begin Self.DefaultItemHeight := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewDefaultItemHeight_R(Self: TCustomTreeView; var T: integer);
begin T := Self.DefaultItemHeight; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewBottomItem_W(Self: TCustomTreeView; const T: TTreeNode);
begin Self.BottomItem := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewBottomItem_R(Self: TCustomTreeView; var T: TTreeNode);
begin T := Self.BottomItem; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewBackgroundColor_W(Self: TCustomTreeView; const T: TColor);
begin Self.BackgroundColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewBackgroundColor_R(Self: TCustomTreeView; var T: TColor);
begin T := Self.BackgroundColor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewAccessibilityOn_W(Self: TCustomTreeView; const T: Boolean);
begin Self.AccessibilityOn := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTreeViewAccessibilityOn_R(Self: TCustomTreeView; var T: Boolean);
begin T := Self.AccessibilityOn; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesTopLvlItems_W(Self: TTreeNodes; const T: TTreeNode; const t1: integer);
begin Self.TopLvlItems[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesTopLvlItems_R(Self: TTreeNodes; var T: TTreeNode; const t1: integer);
begin T := Self.TopLvlItems[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesTopLvlCount_R(Self: TTreeNodes; var T: integer);
begin T := Self.TopLvlCount; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesSelectionCount_R(Self: TTreeNodes; var T: Cardinal);
begin T := Self.SelectionCount; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesOwner_R(Self: TTreeNodes; var T: TCustomTreeView);
begin T := Self.Owner; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesKeepCollapsedNodes_W(Self: TTreeNodes; const T: boolean);
begin Self.KeepCollapsedNodes := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesKeepCollapsedNodes_R(Self: TTreeNodes; var T: boolean);
begin T := Self.KeepCollapsedNodes; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesItem_R(Self: TTreeNodes; var T: TTreeNode; const t1: Integer);
begin T := Self.Item[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesCount_R(Self: TTreeNodes; var T: Integer);
begin T := Self.Count; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodesEnumeratorCurrent_R(Self: TTreeNodesEnumerator; var T: TTreeNode);
begin T := Self.Current; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeVisible_W(Self: TTreeNode; const T: Boolean);
begin Self.Visible := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeVisible_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Visible; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeTreeView_R(Self: TTreeNode; var T: TCustomTreeView);
begin T := Self.TreeView; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeTreeNodes_R(Self: TTreeNode; var T: TTreeNodes);
begin T := Self.TreeNodes; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeTop_R(Self: TTreeNode; var T: integer);
begin T := Self.Top; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeText_W(Self: TTreeNode; const T: string);
begin Self.Text := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeText_R(Self: TTreeNode; var T: string);
begin T := Self.Text; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeSubTreeCount_R(Self: TTreeNode; var T: integer);
begin T := Self.SubTreeCount; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeStateIndex_W(Self: TTreeNode; const T: Integer);
begin Self.StateIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeStateIndex_R(Self: TTreeNode; var T: Integer);
begin T := Self.StateIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeSelectedIndex_W(Self: TTreeNode; const T: Integer);
begin Self.SelectedIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeSelectedIndex_R(Self: TTreeNode; var T: Integer);
begin T := Self.SelectedIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeSelected_W(Self: TTreeNode; const T: Boolean);
begin Self.Selected := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeSelected_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Selected; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeParent_R(Self: TTreeNode; var T: TTreeNode);
begin T := Self.Parent; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeOwner_R(Self: TTreeNode; var T: TTreeNodes);
begin T := Self.Owner; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeOverlayIndex_W(Self: TTreeNode; const T: Integer);
begin Self.OverlayIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeOverlayIndex_R(Self: TTreeNode; var T: Integer);
begin T := Self.OverlayIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeNodeEffect_W(Self: TTreeNode; const T: TGraphicsDrawEffect);
begin Self.NodeEffect := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeNodeEffect_R(Self: TTreeNode; var T: TGraphicsDrawEffect);
begin T := Self.NodeEffect; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeMultiSelected_W(Self: TTreeNode; const T: Boolean);
begin Self.MultiSelected := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeMultiSelected_R(Self: TTreeNode; var T: Boolean);
begin T := Self.MultiSelected; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeLevel_R(Self: TTreeNode; var T: Integer);
begin T := Self.Level; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeItems_W(Self: TTreeNode; const T: TTreeNode; const t1: Integer);
begin Self.Items[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeItems_R(Self: TTreeNode; var T: TTreeNode; const t1: Integer);
begin T := Self.Items[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeIsVisible_R(Self: TTreeNode; var T: Boolean);
begin T := Self.IsVisible; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeIsFullHeightVisible_R(Self: TTreeNode; var T: Boolean);
begin T := Self.IsFullHeightVisible; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeIndex_W(Self: TTreeNode; const T: Integer);
begin Self.Index := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeIndex_R(Self: TTreeNode; var T: Integer);
begin T := Self.Index; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeImageIndex_W(Self: TTreeNode; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeImageIndex_R(Self: TTreeNode; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeHeight_W(Self: TTreeNode; const T: integer);
begin Self.Height := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeHeight_R(Self: TTreeNode; var T: integer);
begin T := Self.Height; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeHasChildren_W(Self: TTreeNode; const T: Boolean);
begin Self.HasChildren := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeHasChildren_R(Self: TTreeNode; var T: Boolean);
begin T := Self.HasChildren; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeHandle_R(Self: TTreeNode; var T: THandle);
begin T := Self.Handle; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeFocused_W(Self: TTreeNode; const T: Boolean);
begin Self.Focused := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeFocused_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Focused; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpanded_W(Self: TTreeNode; const T: Boolean);
begin Self.Expanded := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeExpanded_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Expanded; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeDropTarget_W(Self: TTreeNode; const T: Boolean);
begin Self.DropTarget := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeDropTarget_R(Self: TTreeNode; var T: Boolean);
begin T := Self.DropTarget; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeDeleting_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Deleting; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeData_W(Self: TTreeNode; const T: Pointer);
begin Self.Data := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeData_R(Self: TTreeNode; var T: Pointer);
begin T := Self.Data; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeCut_W(Self: TTreeNode; const T: Boolean);
begin Self.Cut := T; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeCut_R(Self: TTreeNode; var T: Boolean);
begin T := Self.Cut; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeCount_R(Self: TTreeNode; var T: Integer);
begin T := Self.Count; end;

(*----------------------------------------------------------------------------*)
procedure TTreeNodeAbsoluteIndex_R(Self: TTreeNode; var T: Integer);
begin T := Self.AbsoluteIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarTickStyle_W(Self: TCustomTrackBar; const T: TTickStyle);
begin Self.TickStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarTickStyle_R(Self: TCustomTrackBar; var T: TTickStyle);
begin T := Self.TickStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarTickMarks_W(Self: TCustomTrackBar; const T: TTickMark);
begin Self.TickMarks := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarTickMarks_R(Self: TCustomTrackBar; var T: TTickMark);
begin T := Self.TickMarks; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarShowSelRange_W(Self: TCustomTrackBar; const T: Boolean);
begin Self.ShowSelRange := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarShowSelRange_R(Self: TCustomTrackBar; var T: Boolean);
begin T := Self.ShowSelRange; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarSelStart_W(Self: TCustomTrackBar; const T: Integer);
begin Self.SelStart := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarSelStart_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.SelStart; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarSelEnd_W(Self: TCustomTrackBar; const T: Integer);
begin Self.SelEnd := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarSelEnd_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.SelEnd; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarScalePos_W(Self: TCustomTrackBar; const T: TTrackBarScalePos);
begin Self.ScalePos := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarScalePos_R(Self: TCustomTrackBar; var T: TTrackBarScalePos);
begin T := Self.ScalePos; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarReversed_W(Self: TCustomTrackBar; const T: Boolean);
begin Self.Reversed := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarReversed_R(Self: TCustomTrackBar; var T: Boolean);
begin T := Self.Reversed; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarPosition_W(Self: TCustomTrackBar; const T: Integer);
begin Self.Position := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarPosition_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.Position; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarPageSize_W(Self: TCustomTrackBar; const T: Integer);
begin Self.PageSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarPageSize_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.PageSize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarOrientation_W(Self: TCustomTrackBar; const T: TTrackBarOrientation);
begin Self.Orientation := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarOrientation_R(Self: TCustomTrackBar; var T: TTrackBarOrientation);
begin T := Self.Orientation; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarOnChange_W(Self: TCustomTrackBar; const T: TNotifyEvent);
begin Self.OnChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarOnChange_R(Self: TCustomTrackBar; var T: TNotifyEvent);
begin T := Self.OnChange; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarMin_W(Self: TCustomTrackBar; const T: Integer);
begin Self.Min := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarMin_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.Min; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarMax_W(Self: TCustomTrackBar; const T: Integer);
begin Self.Max := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarMax_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.Max; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarLineSize_W(Self: TCustomTrackBar; const T: Integer);
begin Self.LineSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarLineSize_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.LineSize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarFrequency_W(Self: TCustomTrackBar; const T: Integer);
begin Self.Frequency := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrackBarFrequency_R(Self: TCustomTrackBar; var T: Integer);
begin T := Self.Frequency; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarOnChange_W(Self: TCustomCoolBar; const T: TNotifyEvent);
begin Self.OnChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarOnChange_R(Self: TCustomCoolBar; var T: TNotifyEvent);
begin T := Self.OnChange; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarVertical_W(Self: TCustomCoolBar; const T: Boolean);
begin Self.Vertical := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarVertical_R(Self: TCustomCoolBar; var T: Boolean);
begin T := Self.Vertical; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarShowText_W(Self: TCustomCoolBar; const T: Boolean);
begin Self.ShowText := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarShowText_R(Self: TCustomCoolBar; var T: Boolean);
begin T := Self.ShowText; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBitmap_W(Self: TCustomCoolBar; const T: TBitmap);
begin Self.Bitmap := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBitmap_R(Self: TCustomCoolBar; var T: TBitmap);
begin T := Self.Bitmap; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarImages_W(Self: TCustomCoolBar; const T: TCustomImageList);
begin Self.Images := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarImages_R(Self: TCustomCoolBar; var T: TCustomImageList);
begin T := Self.Images; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarFixedOrder_W(Self: TCustomCoolBar; const T: Boolean);
begin Self.FixedOrder := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarFixedOrder_R(Self: TCustomCoolBar; var T: Boolean);
begin T := Self.FixedOrder; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarFixedSize_W(Self: TCustomCoolBar; const T: Boolean);
begin Self.FixedSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarFixedSize_R(Self: TCustomCoolBar; var T: Boolean);
begin T := Self.FixedSize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBands_W(Self: TCustomCoolBar; const T: TCoolBands);
begin Self.Bands := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBands_R(Self: TCustomCoolBar; var T: TCoolBands);
begin T := Self.Bands; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBandMaximize_W(Self: TCustomCoolBar; const T: TCoolBandMaximize);
begin Self.BandMaximize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBandMaximize_R(Self: TCustomCoolBar; var T: TCoolBandMaximize);
begin T := Self.BandMaximize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBandBorderStyle_W(Self: TCustomCoolBar; const T: TBorderStyle);
begin Self.BandBorderStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCoolBarBandBorderStyle_R(Self: TCustomCoolBar; var T: TBorderStyle);
begin T := Self.BandBorderStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandsItems_W(Self: TCoolBands; const T: TCoolBand; const t1: Integer);
begin Self.Items[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandsItems_R(Self: TCoolBands; var T: TCoolBand; const t1: Integer);
begin T := Self.Items[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandWidth_W(Self: TCoolBand; const T: Integer);
begin Self.Width := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandWidth_R(Self: TCoolBand; var T: Integer);
begin T := Self.Width; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandVisible_W(Self: TCoolBand; const T: Boolean);
begin Self.Visible := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandVisible_R(Self: TCoolBand; var T: Boolean);
begin T := Self.Visible; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandText_W(Self: TCoolBand; const T: string);
begin Self.Text := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandText_R(Self: TCoolBand; var T: string);
begin T := Self.Text; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandParentBitmap_W(Self: TCoolBand; const T: Boolean);
begin Self.ParentBitmap := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandParentBitmap_R(Self: TCoolBand; var T: Boolean);
begin T := Self.ParentBitmap; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandParentColor_W(Self: TCoolBand; const T: Boolean);
begin Self.ParentColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandParentColor_R(Self: TCoolBand; var T: Boolean);
begin T := Self.ParentColor; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandMinWidth_W(Self: TCoolBand; const T: Integer);
begin Self.MinWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandMinWidth_R(Self: TCoolBand; var T: Integer);
begin T := Self.MinWidth; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandMinHeight_W(Self: TCoolBand; const T: Integer);
begin Self.MinHeight := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandMinHeight_R(Self: TCoolBand; var T: Integer);
begin T := Self.MinHeight; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandImageIndex_W(Self: TCoolBand; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandImageIndex_R(Self: TCoolBand; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandHorizontalOnly_W(Self: TCoolBand; const T: Boolean);
begin Self.HorizontalOnly := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandHorizontalOnly_R(Self: TCoolBand; var T: Boolean);
begin T := Self.HorizontalOnly; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandFixedSize_W(Self: TCoolBand; const T: Boolean);
begin Self.FixedSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandFixedSize_R(Self: TCoolBand; var T: Boolean);
begin T := Self.FixedSize; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandFixedBackground_W(Self: TCoolBand; const T: Boolean);
begin Self.FixedBackground := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandFixedBackground_R(Self: TCoolBand; var T: Boolean);
begin T := Self.FixedBackground; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandControl_W(Self: TCoolBand; const T: TControl);
begin Self.Control := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandControl_R(Self: TCoolBand; var T: TControl);
begin T := Self.Control; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandColor_W(Self: TCoolBand; const T: TColor);
begin Self.Color := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandColor_R(Self: TCoolBand; var T: TColor);
begin T := Self.Color; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBreak_W(Self: TCoolBand; const T: Boolean);
begin Self.Break := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBreak_R(Self: TCoolBand; var T: Boolean);
begin T := Self.Break; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBorderStyle_W(Self: TCoolBand; const T: TBorderStyle);
begin Self.BorderStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBorderStyle_R(Self: TCoolBand; var T: TBorderStyle);
begin T := Self.BorderStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBitmap_W(Self: TCoolBand; const T: TBitmap);
begin Self.Bitmap := T; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandBitmap_R(Self: TCoolBand; var T: TBitmap);
begin T := Self.Bitmap; end;

(*----------------------------------------------------------------------------*)
procedure TCoolBandHeight_R(Self: TCoolBand; var T: Integer);
begin T := Self.Height; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarWrapable_W(Self: TToolBar; const T: Boolean);
begin Self.Wrapable := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarWrapable_R(Self: TToolBar; var T: Boolean);
begin T := Self.Wrapable; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarTransparent_W(Self: TToolBar; const T: Boolean);
begin Self.Transparent := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarTransparent_R(Self: TToolBar; var T: Boolean);
begin T := Self.Transparent; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarShowCaptions_W(Self: TToolBar; const T: Boolean);
begin Self.ShowCaptions := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarShowCaptions_R(Self: TToolBar; var T: Boolean);
begin T := Self.ShowCaptions; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarList_W(Self: TToolBar; const T: Boolean);
begin Self.List := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarList_R(Self: TToolBar; var T: Boolean);
begin T := Self.List; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarIndent_W(Self: TToolBar; const T: Integer);
begin Self.Indent := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarIndent_R(Self: TToolBar; var T: Integer);
begin T := Self.Indent; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarImages_W(Self: TToolBar; const T: TCustomImageList);
begin Self.Images := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarImages_R(Self: TToolBar; var T: TCustomImageList);
begin T := Self.Images; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarHotImages_W(Self: TToolBar; const T: TCustomImageList);
begin Self.HotImages := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarHotImages_R(Self: TToolBar; var T: TCustomImageList);
begin T := Self.HotImages; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarFlat_W(Self: TToolBar; const T: Boolean);
begin Self.Flat := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarFlat_R(Self: TToolBar; var T: Boolean);
begin T := Self.Flat; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarDisabledImages_W(Self: TToolBar; const T: TCustomImageList);
begin Self.DisabledImages := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarDisabledImages_R(Self: TToolBar; var T: TCustomImageList);
begin T := Self.DisabledImages; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonWidth_W(Self: TToolBar; const T: Integer);
begin Self.ButtonWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonWidth_R(Self: TToolBar; var T: Integer);
begin T := Self.ButtonWidth; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonHeight_W(Self: TToolBar; const T: Integer);
begin Self.ButtonHeight := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonHeight_R(Self: TToolBar; var T: Integer);
begin T := Self.ButtonHeight; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarRowCount_R(Self: TToolBar; var T: Integer);
begin T := Self.RowCount; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonList_R(Self: TToolBar; var T: TList);
begin T := Self.ButtonList; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtons_R(Self: TToolBar; var T: TToolButton; const t1: Integer);
begin T := Self.Buttons[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarButtonCount_R(Self: TToolBar; var T: Integer);
begin T := Self.ButtonCount; end;

(*----------------------------------------------------------------------------*)
procedure TToolBarEnumeratorCurrent_R(Self: TToolBarEnumerator; var T: TToolButton);
begin T := Self.Current; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonWrap_W(Self: TToolButton; const T: Boolean);
begin Self.Wrap := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonWrap_R(Self: TToolButton; var T: Boolean);
begin T := Self.Wrap; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonStyle_W(Self: TToolButton; const T: TToolButtonStyle);
begin Self.Style := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonStyle_R(Self: TToolButton; var T: TToolButtonStyle);
begin T := Self.Style; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonShowCaption_W(Self: TToolButton; const T: boolean);
begin Self.ShowCaption := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonShowCaption_R(Self: TToolButton; var T: boolean);
begin T := Self.ShowCaption; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonMenuItem_W(Self: TToolButton; const T: TMenuItem);
begin Self.MenuItem := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonMenuItem_R(Self: TToolButton; var T: TMenuItem);
begin T := Self.MenuItem; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonMarked_W(Self: TToolButton; const T: Boolean);
begin Self.Marked := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonMarked_R(Self: TToolButton; var T: Boolean);
begin T := Self.Marked; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonIndeterminate_W(Self: TToolButton; const T: Boolean);
begin Self.Indeterminate := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonIndeterminate_R(Self: TToolButton; var T: Boolean);
begin T := Self.Indeterminate; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonImageIndex_W(Self: TToolButton; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonImageIndex_R(Self: TToolButton; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonGrouped_W(Self: TToolButton; const T: Boolean);
begin Self.Grouped := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonGrouped_R(Self: TToolButton; var T: Boolean);
begin T := Self.Grouped; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonDropdownMenu_W(Self: TToolButton; const T: TPopupMenu);
begin Self.DropdownMenu := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonDropdownMenu_R(Self: TToolButton; var T: TPopupMenu);
begin T := Self.DropdownMenu; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonDown_W(Self: TToolButton; const T: Boolean);
begin Self.Down := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonDown_R(Self: TToolButton; var T: Boolean);
begin T := Self.Down; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonAllowAllUp_W(Self: TToolButton; const T: Boolean);
begin Self.AllowAllUp := T; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonAllowAllUp_R(Self: TToolButton; var T: Boolean);
begin T := Self.AllowAllUp; end;

(*----------------------------------------------------------------------------*)
procedure TToolButtonIndex_R(Self: TToolButton; var T: Integer);
begin T := Self.Index; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarBarShowText_W(Self: TCustomProgressBar; const T: boolean);
begin Self.BarShowText := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarBarShowText_R(Self: TCustomProgressBar; var T: boolean);
begin T := Self.BarShowText; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarStyle_W(Self: TCustomProgressBar; const T: TProgressBarStyle);
begin Self.Style := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarStyle_R(Self: TCustomProgressBar; var T: TProgressBarStyle);
begin T := Self.Style; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarStep_W(Self: TCustomProgressBar; const T: Integer);
begin Self.Step := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarStep_R(Self: TCustomProgressBar; var T: Integer);
begin T := Self.Step; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarSmooth_W(Self: TCustomProgressBar; const T: boolean);
begin Self.Smooth := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarSmooth_R(Self: TCustomProgressBar; var T: boolean);
begin T := Self.Smooth; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarPosition_W(Self: TCustomProgressBar; const T: Integer);
begin Self.Position := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarPosition_R(Self: TCustomProgressBar; var T: Integer);
begin T := Self.Position; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarOrientation_W(Self: TCustomProgressBar; const T: TProgressBarOrientation);
begin Self.Orientation := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarOrientation_R(Self: TCustomProgressBar; var T: TProgressBarOrientation);
begin T := Self.Orientation; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarMin_W(Self: TCustomProgressBar; const T: Integer);
begin Self.Min := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarMin_R(Self: TCustomProgressBar; var T: Integer);
begin T := Self.Min; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarMax_W(Self: TCustomProgressBar; const T: Integer);
begin Self.Max := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomProgressBarMax_R(Self: TCustomProgressBar; var T: Integer);
begin T := Self.Max; end;

(*----------------------------------------------------------------------------*)
procedure TListViewAutoWidthLastColumn_W(Self: TListView; const T: Boolean);
begin Self.AutoWidthLastColumn := T; end;

(*----------------------------------------------------------------------------*)
procedure TListViewAutoWidthLastColumn_R(Self: TListView; var T: Boolean);
begin T := Self.AutoWidthLastColumn; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewVisibleRowCount_R(Self: TCustomListView; var T: Integer);
begin T := Self.VisibleRowCount; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewViewOrigin_W(Self: TCustomListView; const T: TPoint);
begin Self.ViewOrigin := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewViewOrigin_R(Self: TCustomListView; var T: TPoint);
begin T := Self.ViewOrigin; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewTopItem_R(Self: TCustomListView; var T: TListItem);
begin T := Self.TopItem; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewSelected_W(Self: TCustomListView; const T: TListItem);
begin Self.Selected := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewSelected_R(Self: TCustomListView; var T: TListItem);
begin T := Self.Selected; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewSelCount_R(Self: TCustomListView; var T: Integer);
begin T := Self.SelCount; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewRowSelect_W(Self: TCustomListView; const T: Boolean);
begin Self.RowSelect := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewRowSelect_R(Self: TCustomListView; var T: Boolean);
begin T := Self.RowSelect; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewReadOnly_W(Self: TCustomListView; const T: Boolean);
begin Self.ReadOnly := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewReadOnly_R(Self: TCustomListView; var T: Boolean);
begin T := Self.ReadOnly; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewOwnerData_W(Self: TCustomListView; const T: Boolean);
begin Self.OwnerData := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewOwnerData_R(Self: TCustomListView; var T: Boolean);
begin T := Self.OwnerData; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewMultiSelect_W(Self: TCustomListView; const T: Boolean);
begin Self.MultiSelect := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewMultiSelect_R(Self: TCustomListView; var T: Boolean);
begin T := Self.MultiSelect; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItems_W(Self: TCustomListView; const T: TListItems);
begin Self.Items := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItems_R(Self: TCustomListView; var T: TListItems);
begin T := Self.Items; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItemIndex_W(Self: TCustomListView; const T: Integer);
begin Self.ItemIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItemIndex_R(Self: TCustomListView; var T: Integer);
begin T := Self.ItemIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItemFocused_W(Self: TCustomListView; const T: TListItem);
begin Self.ItemFocused := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewItemFocused_R(Self: TCustomListView; var T: TListItem);
begin T := Self.ItemFocused; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewIconOptions_W(Self: TCustomListView; const T: TIconOptions);
begin Self.IconOptions := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewIconOptions_R(Self: TCustomListView; var T: TIconOptions);
begin T := Self.IconOptions; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewHotTrackStyles_W(Self: TCustomListView; const T: TListHotTrackStyles);
begin Self.HotTrackStyles := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewHotTrackStyles_R(Self: TCustomListView; var T: TListHotTrackStyles);
begin T := Self.HotTrackStyles; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewHotTrack_W(Self: TCustomListView; const T: Boolean);
begin Self.HotTrack := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewHotTrack_R(Self: TCustomListView; var T: Boolean);
begin T := Self.HotTrack; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewGridLines_W(Self: TCustomListView; const T: Boolean);
begin Self.GridLines := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewGridLines_R(Self: TCustomListView; var T: Boolean);
begin T := Self.GridLines; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewFullDrag_W(Self: TCustomListView; const T: Boolean);
begin Self.FullDrag := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewFullDrag_R(Self: TCustomListView; var T: Boolean);
begin T := Self.FullDrag; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewFlatScrollBars_W(Self: TCustomListView; const T: Boolean);
begin Self.FlatScrollBars := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewFlatScrollBars_R(Self: TCustomListView; var T: Boolean);
begin T := Self.FlatScrollBars; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewDropTarget_W(Self: TCustomListView; const T: TListItem);
begin Self.DropTarget := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewDropTarget_R(Self: TCustomListView; var T: TListItem);
begin T := Self.DropTarget; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewColumnCount_R(Self: TCustomListView; var T: Integer);
begin T := Self.ColumnCount; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewColumn_R(Self: TCustomListView; var T: TListColumn; const t1: Integer);
begin T := Self.Column[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewCheckboxes_W(Self: TCustomListView; const T: Boolean);
begin Self.Checkboxes := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewCheckboxes_R(Self: TCustomListView; var T: Boolean);
begin T := Self.Checkboxes; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewCanvas_R(Self: TCustomListView; var T: TCanvas);
begin T := Self.Canvas; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewBoundingRect_R(Self: TCustomListView; var T: TRect);
begin T := Self.BoundingRect; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewEditorItem_W(Self: TCustomListViewEditor; const T: TListItem);
begin Self.Item := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomListViewEditorItem_R(Self: TCustomListViewEditor; var T: TListItem);
begin T := Self.Item; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnsItems_W(Self: TListColumns; const T: TListColumn; const t1: Integer);
begin Self.Items[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnsItems_R(Self: TListColumns; var T: TListColumn; const t1: Integer);
begin T := Self.Items[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnsOwner_R(Self: TListColumns; var T: TCustomListView);
begin T := Self.Owner; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnWidth_W(Self: TListColumn; const T: TWidth);
begin Self.Width := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnWidth_R(Self: TListColumn; var T: TWidth);
begin T := Self.Width; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnVisible_W(Self: TListColumn; const T: Boolean);
begin Self.Visible := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnVisible_R(Self: TListColumn; var T: Boolean);
begin T := Self.Visible; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnTag_W(Self: TListColumn; const T: Integer);
begin Self.Tag := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnTag_R(Self: TListColumn; var T: Integer);
begin T := Self.Tag; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnMinWidth_W(Self: TListColumn; const T: TWidth);
begin Self.MinWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnMinWidth_R(Self: TListColumn; var T: TWidth);
begin T := Self.MinWidth; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnMaxWidth_W(Self: TListColumn; const T: TWidth);
begin Self.MaxWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnMaxWidth_R(Self: TListColumn; var T: TWidth);
begin T := Self.MaxWidth; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnImageIndex_W(Self: TListColumn; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnImageIndex_R(Self: TListColumn; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnCaption_W(Self: TListColumn; const T: TTranslateString);
begin Self.Caption := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnCaption_R(Self: TListColumn; var T: TTranslateString);
begin T := Self.Caption; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnAutoSize_W(Self: TListColumn; const T: Boolean);
begin Self.AutoSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnAutoSize_R(Self: TListColumn; var T: Boolean);
begin T := Self.AutoSize; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnAlignment_W(Self: TListColumn; const T: TAlignment);
begin Self.Alignment := T; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnAlignment_R(Self: TListColumn; var T: TAlignment);
begin T := Self.Alignment; end;

(*----------------------------------------------------------------------------*)
procedure TListColumnWidthType_R(Self: TListColumn; var T: TWidth);
begin T := Self.WidthType; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsOwner_R(Self: TListItems; var T: TCustomListView);
begin T := Self.Owner; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsItem_W(Self: TListItems; const T: TListItem; const t1: Integer);
begin Self.Item[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsItem_R(Self: TListItems; var T: TListItem; const t1: Integer);
begin T := Self.Item[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsCount_W(Self: TListItems; const T: Integer);
begin Self.Count := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsCount_R(Self: TListItems; var T: Integer);
begin T := Self.Count; end;

(*----------------------------------------------------------------------------*)
procedure TListItemsFlags_R(Self: TListItems; var T: TListItemsFlags);
begin T := Self.Flags; end;

(*----------------------------------------------------------------------------*)
Function TListItemsFindData1(Self: TListItems;  StartIndex : Integer; Value : Pointer; Inclusive, Wrap : Boolean) : TListItem;
Begin Result := Self.FindData(StartIndex, Value, Inclusive, Wrap); END;

(*----------------------------------------------------------------------------*)
Function TListItemsFindData0(Self: TListItems;  const AData : Pointer) : TListItem;
Begin Result := Self.FindData(AData); END;

(*----------------------------------------------------------------------------*)
procedure TListItemsEnumeratorCurrent_R(Self: TListItemsEnumerator; var T: TListItem);
begin T := Self.Current; end;

(*----------------------------------------------------------------------------*)
procedure TListItemTop_W(Self: TListItem; const T: Integer);
begin Self.Top := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemTop_R(Self: TListItem; var T: Integer);
begin T := Self.Top; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSubItemImages_W(Self: TListItem; const T: Integer; const t1: Integer);
begin Self.SubItemImages[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSubItemImages_R(Self: TListItem; var T: Integer; const t1: Integer);
begin T := Self.SubItemImages[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSubItems_W(Self: TListItem; const T: TStrings);
begin Self.SubItems := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSubItems_R(Self: TListItem; var T: TStrings);
begin T := Self.SubItems; end;

(*----------------------------------------------------------------------------*)
procedure TListItemStateIndex_W(Self: TListItem; const T: TImageIndex);
begin Self.StateIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemStateIndex_R(Self: TListItem; var T: TImageIndex);
begin T := Self.StateIndex; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSelected_W(Self: TListItem; const T: Boolean);
begin Self.Selected := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemSelected_R(Self: TListItem; var T: Boolean);
begin T := Self.Selected; end;

(*----------------------------------------------------------------------------*)
procedure TListItemPosition_W(Self: TListItem; const T: TPoint);
begin Self.Position := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemPosition_R(Self: TListItem; var T: TPoint);
begin T := Self.Position; end;

(*----------------------------------------------------------------------------*)
procedure TListItemOwner_R(Self: TListItem; var T: TListItems);
begin T := Self.Owner; end;

(*----------------------------------------------------------------------------*)
procedure TListItemListView_R(Self: TListItem; var T: TCustomListView);
begin T := Self.ListView; end;

(*----------------------------------------------------------------------------*)
procedure TListItemLeft_W(Self: TListItem; const T: Integer);
begin Self.Left := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemLeft_R(Self: TListItem; var T: Integer);
begin T := Self.Left; end;

(*----------------------------------------------------------------------------*)
procedure TListItemImageIndex_W(Self: TListItem; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemImageIndex_R(Self: TListItem; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TListItemIndex_R(Self: TListItem; var T: Integer);
begin T := Self.Index; end;

(*----------------------------------------------------------------------------*)
procedure TListItemFocused_W(Self: TListItem; const T: Boolean);
begin Self.Focused := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemFocused_R(Self: TListItem; var T: Boolean);
begin T := Self.Focused; end;

(*----------------------------------------------------------------------------*)
procedure TListItemDropTarget_W(Self: TListItem; const T: Boolean);
begin Self.DropTarget := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemDropTarget_R(Self: TListItem; var T: Boolean);
begin T := Self.DropTarget; end;

(*----------------------------------------------------------------------------*)
procedure TListItemData_W(Self: TListItem; const T: Pointer);
begin Self.Data := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemData_R(Self: TListItem; var T: Pointer);
begin T := Self.Data; end;

(*----------------------------------------------------------------------------*)
procedure TListItemCut_W(Self: TListItem; const T: Boolean);
begin Self.Cut := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemCut_R(Self: TListItem; var T: Boolean);
begin T := Self.Cut; end;

(*----------------------------------------------------------------------------*)
procedure TListItemChecked_W(Self: TListItem; const T: Boolean);
begin Self.Checked := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemChecked_R(Self: TListItem; var T: Boolean);
begin T := Self.Checked; end;

(*----------------------------------------------------------------------------*)
procedure TListItemCaption_W(Self: TListItem; const T: String);
begin Self.Caption := T; end;

(*----------------------------------------------------------------------------*)
procedure TListItemCaption_R(Self: TListItem; var T: String);
begin T := Self.Caption; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsWrapText_W(Self: TIconOptions; const T: Boolean);
begin Self.WrapText := T; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsWrapText_R(Self: TIconOptions; var T: Boolean);
begin T := Self.WrapText; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsAutoArrange_W(Self: TIconOptions; const T: Boolean);
begin Self.AutoArrange := T; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsAutoArrange_R(Self: TIconOptions; var T: Boolean);
begin T := Self.AutoArrange; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsArrangement_W(Self: TIconOptions; const T: TIconArrangement);
begin Self.Arrangement := T; end;

(*----------------------------------------------------------------------------*)
procedure TIconOptionsArrangement_R(Self: TIconOptions; var T: TIconArrangement);
begin T := Self.Arrangement; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabs_W(Self: TTabControl; const T: TStrings);
begin Self.Tabs := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabs_R(Self: TTabControl; var T: TStrings);
begin T := Self.Tabs; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabIndex_W(Self: TTabControl; const T: Integer);
begin Self.TabIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabIndex_R(Self: TTabControl; var T: Integer);
begin T := Self.TabIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabWidth_W(Self: TTabControl; const T: Smallint);
begin Self.TabWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabWidth_R(Self: TTabControl; var T: Smallint);
begin T := Self.TabWidth; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabHeight_W(Self: TTabControl; const T: Smallint);
begin Self.TabHeight := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlTabHeight_R(Self: TTabControl; var T: Smallint);
begin T := Self.TabHeight; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlScrollOpposite_W(Self: TTabControl; const T: Boolean);
begin Self.ScrollOpposite := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlScrollOpposite_R(Self: TTabControl; var T: Boolean);
begin T := Self.ScrollOpposite; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlRaggedRight_W(Self: TTabControl; const T: Boolean);
begin Self.RaggedRight := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlRaggedRight_R(Self: TTabControl; var T: Boolean);
begin T := Self.RaggedRight; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlOwnerDraw_W(Self: TTabControl; const T: Boolean);
begin Self.OwnerDraw := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlOwnerDraw_R(Self: TTabControl; var T: Boolean);
begin T := Self.OwnerDraw; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlOnChange_W(Self: TTabControl; const T: TNotifyEvent);
begin Self.OnChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlOnChange_R(Self: TTabControl; var T: TNotifyEvent);
begin T := Self.OnChange; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlMultiSelect_W(Self: TTabControl; const T: Boolean);
begin Self.MultiSelect := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlMultiSelect_R(Self: TTabControl; var T: Boolean);
begin T := Self.MultiSelect; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlMultiLine_W(Self: TTabControl; const T: Boolean);
begin Self.MultiLine := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlMultiLine_R(Self: TTabControl; var T: Boolean);
begin T := Self.MultiLine; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlHotTrack_W(Self: TTabControl; const T: Boolean);
begin Self.HotTrack := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlHotTrack_R(Self: TTabControl; var T: Boolean);
begin T := Self.HotTrack; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlDisplayRect_R(Self: TTabControl; var T: TRect);
begin T := Self.DisplayRect; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlNoteBookStringsNoteBook_R(Self: TTabControlNoteBookStrings; var T: TCustomTabControl);
begin T := Self.NoteBook; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabWidth_W(Self: TTabControlStrings; const T: Smallint);
begin Self.TabWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabWidth_R(Self: TTabControlStrings; var T: Smallint);
begin T := Self.TabWidth; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabHeight_W(Self: TTabControlStrings; const T: Smallint);
begin Self.TabHeight := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabHeight_R(Self: TTabControlStrings; var T: Smallint);
begin T := Self.TabHeight; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsScrollOpposite_W(Self: TTabControlStrings; const T: Boolean);
begin Self.ScrollOpposite := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsScrollOpposite_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.ScrollOpposite; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsRaggedRight_W(Self: TTabControlStrings; const T: Boolean);
begin Self.RaggedRight := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsRaggedRight_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.RaggedRight; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsOwnerDraw_W(Self: TTabControlStrings; const T: Boolean);
begin Self.OwnerDraw := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsOwnerDraw_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.OwnerDraw; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsMultiSelect_W(Self: TTabControlStrings; const T: Boolean);
begin Self.MultiSelect := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsMultiSelect_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.MultiSelect; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsMultiLine_W(Self: TTabControlStrings; const T: Boolean);
begin Self.MultiLine := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsMultiLine_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.MultiLine; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsImages_W(Self: TTabControlStrings; const T: TCustomImageList);
begin Self.Images := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsImages_R(Self: TTabControlStrings; var T: TCustomImageList);
begin T := Self.Images; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsHotTrack_W(Self: TTabControlStrings; const T: Boolean);
begin Self.HotTrack := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsHotTrack_R(Self: TTabControlStrings; var T: Boolean);
begin T := Self.HotTrack; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabIndex_W(Self: TTabControlStrings; const T: integer);
begin Self.TabIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabIndex_R(Self: TTabControlStrings; var T: integer);
begin T := Self.TabIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTabControlStringsTabControl_R(Self: TTabControlStrings; var T: TTabControl);
begin T := Self.TabControl; end;

(*----------------------------------------------------------------------------*)
procedure TPageControlActivePage_W(Self: TPageControl; const T: TTabSheet);
begin Self.ActivePage := T; end;

(*----------------------------------------------------------------------------*)
procedure TPageControlActivePage_R(Self: TPageControl; var T: TTabSheet);
begin T := Self.ActivePage; end;

(*----------------------------------------------------------------------------*)
procedure TPageControlPages_R(Self: TPageControl; var T: TTabSheet; const t1: Integer);
begin T := Self.Pages[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TPageControlActivePageIndex_W(Self: TPageControl; const T: Integer);
begin Self.ActivePageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TPageControlActivePageIndex_R(Self: TPageControl; var T: Integer);
begin T := Self.ActivePageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTabSheetTabIndex_R(Self: TTabSheet; var T: Integer);
begin T := Self.TabIndex; end;

(*----------------------------------------------------------------------------*)
procedure TTabSheetPageControl_W(Self: TTabSheet; const T: TPageControl);
begin Self.PageControl := T; end;

(*----------------------------------------------------------------------------*)
procedure TTabSheetPageControl_R(Self: TTabSheet; var T: TPageControl);
begin T := Self.PageControl; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlIsUnpaged_R(Self: TCustomTabControl; var T: boolean);
begin T := Self.IsUnpaged; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlTabPosition_W(Self: TCustomTabControl; const T: TTabPosition);
begin Self.TabPosition := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlTabPosition_R(Self: TCustomTabControl; var T: TTabPosition);
begin T := Self.TabPosition; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlShowTabs_W(Self: TCustomTabControl; const T: Boolean);
begin Self.ShowTabs := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlShowTabs_R(Self: TCustomTabControl; var T: Boolean);
begin T := Self.ShowTabs; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPages_W(Self: TCustomTabControl; const T: TStrings);
begin Self.Pages := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPages_R(Self: TCustomTabControl; var T: TStrings);
begin T := Self.Pages; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPageIndex_W(Self: TCustomTabControl; const T: Integer);
begin Self.PageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPageIndex_R(Self: TCustomTabControl; var T: Integer);
begin T := Self.PageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPageCount_R(Self: TCustomTabControl; var T: integer);
begin T := Self.PageCount; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlPage_R(Self: TCustomTabControl; var T: TCustomPage; const t1: Integer);
begin T := Self.Page[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOptions_W(Self: TCustomTabControl; const T: TCTabControlOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOptions_R(Self: TCustomTabControl; var T: TCTabControlOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnGetImageIndex_W(Self: TCustomTabControl; const T: TTabGetImageEvent);
begin Self.OnGetImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnGetImageIndex_R(Self: TCustomTabControl; var T: TTabGetImageEvent);
begin T := Self.OnGetImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnCloseTabClicked_W(Self: TCustomTabControl; const T: TNotifyEvent);
begin Self.OnCloseTabClicked := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnCloseTabClicked_R(Self: TCustomTabControl; var T: TNotifyEvent);
begin T := Self.OnCloseTabClicked; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnChanging_W(Self: TCustomTabControl; const T: TTabChangingEvent);
begin Self.OnChanging := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlOnChanging_R(Self: TCustomTabControl; var T: TTabChangingEvent);
begin T := Self.OnChanging; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlMultiLine_W(Self: TCustomTabControl; const T: Boolean);
begin Self.MultiLine := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlMultiLine_R(Self: TCustomTabControl; var T: Boolean);
begin T := Self.MultiLine; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlImages_W(Self: TCustomTabControl; const T: TCustomImageList);
begin Self.Images := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTabControlImages_R(Self: TCustomTabControl; var T: TCustomImageList);
begin T := Self.Images; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageOnShow_W(Self: TCustomPage; const T: TNotifyEvent);
begin Self.OnShow := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageOnShow_R(Self: TCustomPage; var T: TNotifyEvent);
begin T := Self.OnShow; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageOnHide_W(Self: TCustomPage; const T: TNotifyEvent);
begin Self.OnHide := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageOnHide_R(Self: TCustomPage; var T: TNotifyEvent);
begin T := Self.OnHide; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageImageIndex_W(Self: TCustomPage; const T: TImageIndex);
begin Self.ImageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageImageIndex_R(Self: TCustomPage; var T: TImageIndex);
begin T := Self.ImageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageTabVisible_W(Self: TCustomPage; const T: Boolean);
begin Self.TabVisible := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPageTabVisible_R(Self: TCustomPage; var T: Boolean);
begin T := Self.TabVisible; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPagePageIndex_W(Self: TCustomPage; const T: Integer);
begin Self.PageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPagePageIndex_R(Self: TCustomPage; var T: Integer);
begin T := Self.PageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnHint_W(Self: TStatusBar; const T: TNotifyEvent);
begin Self.OnHint := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnHint_R(Self: TStatusBar; var T: TNotifyEvent);
begin T := Self.OnHint; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnDrawPanel_W(Self: TStatusBar; const T: TDrawPanelEvent);
begin Self.OnDrawPanel := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnDrawPanel_R(Self: TStatusBar; var T: TDrawPanelEvent);
begin T := Self.OnDrawPanel; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnCreatePanelClass_W(Self: TStatusBar; const T: TSBCreatePanelClassEvent);
begin Self.OnCreatePanelClass := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarOnCreatePanelClass_R(Self: TStatusBar; var T: TSBCreatePanelClassEvent);
begin T := Self.OnCreatePanelClass; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSizeGrip_W(Self: TStatusBar; const T: Boolean);
begin Self.SizeGrip := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSizeGrip_R(Self: TStatusBar; var T: Boolean);
begin T := Self.SizeGrip; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSimplePanel_W(Self: TStatusBar; const T: Boolean);
begin Self.SimplePanel := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSimplePanel_R(Self: TStatusBar; var T: Boolean);
begin T := Self.SimplePanel; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSimpleText_W(Self: TStatusBar; const T: TCaption);
begin Self.SimpleText := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarSimpleText_R(Self: TStatusBar; var T: TCaption);
begin T := Self.SimpleText; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarPanels_W(Self: TStatusBar; const T: TStatusPanels);
begin Self.Panels := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarPanels_R(Self: TStatusBar; var T: TStatusPanels);
begin T := Self.Panels; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarAutoHint_W(Self: TStatusBar; const T: Boolean);
begin Self.AutoHint := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarAutoHint_R(Self: TStatusBar; var T: Boolean);
begin T := Self.AutoHint; end;

(*----------------------------------------------------------------------------*)
procedure TStatusBarCanvas_R(Self: TStatusBar; var T: TCanvas);
begin T := Self.Canvas; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelsStatusBar_R(Self: TStatusPanels; var T: TStatusBar);
begin T := Self.StatusBar; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelsItems_W(Self: TStatusPanels; const T: TStatusPanel; const t1: Integer);
begin Self.Items[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelsItems_R(Self: TStatusPanels; var T: TStatusPanel; const t1: Integer);
begin T := Self.Items[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelWidth_W(Self: TStatusPanel; const T: Integer);
begin Self.Width := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelWidth_R(Self: TStatusPanel; var T: Integer);
begin T := Self.Width; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelText_W(Self: TStatusPanel; const T: TCaption);
begin Self.Text := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelText_R(Self: TStatusPanel; var T: TCaption);
begin T := Self.Text; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelStyle_W(Self: TStatusPanel; const T: TStatusPanelStyle);
begin Self.Style := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelStyle_R(Self: TStatusPanel; var T: TStatusPanelStyle);
begin T := Self.Style; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelBevel_W(Self: TStatusPanel; const T: TStatusPanelBevel);
begin Self.Bevel := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelBevel_R(Self: TStatusPanel; var T: TStatusPanelBevel);
begin T := Self.Bevel; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelAlignment_W(Self: TStatusPanel; const T: TAlignment);
begin Self.Alignment := T; end;

(*----------------------------------------------------------------------------*)
procedure TStatusPanelAlignment_R(Self: TStatusPanel; var T: TAlignment);
begin T := Self.Alignment; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_ComCtrls_Routines(S: TPSExec);
begin
 S.RegisterDelphiFunction(@CompareExpandedNodes, 'CompareExpandedNodes', cdRegister);
 S.RegisterDelphiFunction(@CompareTextWithExpandedNode, 'CompareTextWithExpandedNode', cdRegister);
 S.RegisterDelphiFunction(@Register, 'Register', cdRegister);
 S.RegisterDelphiFunction(@RegisterCustomPage, 'RegisterCustomPage', cdRegister);
 S.RegisterDelphiFunction(@RegisterCustomTabControl, 'RegisterCustomTabControl', cdRegister);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_THeaderControl(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(THeaderControl) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomHeaderControl(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomHeaderControl) do
  begin
    RegisterPropertyHelper(@TCustomHeaderControlSectionFromOriginalIndex_R,nil,'SectionFromOriginalIndex');
    RegisterMethod(@TCustomHeaderControl.GetSectionAt, 'GetSectionAt');
    RegisterVirtualMethod(@TCustomHeaderControl.PaintSection, 'PaintSection');
    RegisterPropertyHelper(@TCustomHeaderControlDragReorder_R,@TCustomHeaderControlDragReorder_W,'DragReorder');
    RegisterPropertyHelper(@TCustomHeaderControlImages_R,@TCustomHeaderControlImages_W,'Images');
    RegisterPropertyHelper(@TCustomHeaderControlSections_R,@TCustomHeaderControlSections_W,'Sections');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionDrag_R,@TCustomHeaderControlOnSectionDrag_W,'OnSectionDrag');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionEndDrag_R,@TCustomHeaderControlOnSectionEndDrag_W,'OnSectionEndDrag');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionClick_R,@TCustomHeaderControlOnSectionClick_W,'OnSectionClick');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionResize_R,@TCustomHeaderControlOnSectionResize_W,'OnSectionResize');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionTrack_R,@TCustomHeaderControlOnSectionTrack_W,'OnSectionTrack');
    RegisterPropertyHelper(@TCustomHeaderControlOnSectionSeparatorDblClick_R,@TCustomHeaderControlOnSectionSeparatorDblClick_W,'OnSectionSeparatorDblClick');
    RegisterPropertyHelper(@TCustomHeaderControlOnCreateSectionClass_R,@TCustomHeaderControlOnCreateSectionClass_W,'OnCreateSectionClass');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_THeaderSections(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(THeaderSections) do
  begin
    RegisterConstructor(@THeaderSections.Create, 'Create');
    RegisterMethod(@THeaderSections.Add, 'Add');
    RegisterMethod(@THeaderSections.AddItem, 'AddItem');
    RegisterMethod(@THeaderSections.Insert, 'Insert');
    RegisterMethod(@THeaderSections.Delete, 'Delete');
    RegisterPropertyHelper(@THeaderSectionsItems_R,@THeaderSectionsItems_W,'Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_THeaderSection(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(THeaderSection) do
  begin
    RegisterPropertyHelper(@THeaderSectionLeft_R,nil,'Left');
    RegisterPropertyHelper(@THeaderSectionRight_R,nil,'Right');
    RegisterPropertyHelper(@THeaderSectionState_R,@THeaderSectionState_W,'State');
    RegisterPropertyHelper(@THeaderSectionAlignment_R,@THeaderSectionAlignment_W,'Alignment');
    RegisterPropertyHelper(@THeaderSectionImageIndex_R,@THeaderSectionImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@THeaderSectionMaxWidth_R,@THeaderSectionMaxWidth_W,'MaxWidth');
    RegisterPropertyHelper(@THeaderSectionMinWidth_R,@THeaderSectionMinWidth_W,'MinWidth');
    RegisterPropertyHelper(@THeaderSectionText_R,@THeaderSectionText_W,'Text');
    RegisterPropertyHelper(@THeaderSectionWidth_R,@THeaderSectionWidth_W,'Width');
    RegisterPropertyHelper(@THeaderSectionVisible_R,@THeaderSectionVisible_W,'Visible');
    RegisterPropertyHelper(@THeaderSectionOriginalIndex_R,nil,'OriginalIndex');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTreeNodeExpandedState(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTreeNodeExpandedState) do
  begin
    RegisterPropertyHelper(@TTreeNodeExpandedStateNodeText_R,@TTreeNodeExpandedStateNodeText_W,'NodeText');
    RegisterPropertyHelper(@TTreeNodeExpandedStateChildren_R,@TTreeNodeExpandedStateChildren_W,'Children');
    RegisterConstructor(@TTreeNodeExpandedState.Create, 'Create');
    RegisterConstructor(@TTreeNodeExpandedState.Create, 'Create');
    RegisterMethod(@TTreeNodeExpandedState.Clear, 'Clear');
    RegisterMethod(@TTreeNodeExpandedState.CreateChildNodes, 'CreateChildNodes');
    RegisterMethod(@TTreeNodeExpandedState.Apply, 'Apply');
    RegisterMethod(@TTreeNodeExpandedState.Apply, 'Apply');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTreeView(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTreeView) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomTreeView(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomTreeView) do
  begin
    RegisterPropertyHelper(@TCustomTreeViewAccessibilityOn_R,@TCustomTreeViewAccessibilityOn_W,'AccessibilityOn');
    RegisterMethod(@TCustomTreeView.AlphaSort, 'AlphaSort');
    RegisterMethod(@TCustomTreeView.ConsistencyCheck, 'ConsistencyCheck');
    RegisterMethod(@TCustomTreeView.CustomSort, 'CustomSort');
    RegisterMethod(@TCustomTreeView.DefaultTreeViewSort, 'DefaultTreeViewSort');
    RegisterMethod(@TCustomTreeView.GetHitTestInfoAt, 'GetHitTestInfoAt');
    RegisterMethod(@TCustomTreeView.GetNodeAt, 'GetNodeAt');
    RegisterMethod(@TCustomTreeView.GetInsertMarkAt, 'GetInsertMarkAt');
    RegisterMethod(@TCustomTreeView.SetInsertMark, 'SetInsertMark');
    RegisterVirtualMethod(@TCustomTreeView.SetInsertMarkAt, 'SetInsertMarkAt');
    RegisterMethod(@TCustomTreeView.IsEditing, 'IsEditing');
    RegisterMethod(@TCustomTreeView.BeginUpdate, 'BeginUpdate');
    RegisterMethod(@TCustomTreeView.EndUpdate, 'EndUpdate');
    RegisterMethod(@TCustomTreeView.FullCollapse, 'FullCollapse');
    RegisterMethod(@TCustomTreeView.FullExpand, 'FullExpand');
    RegisterMethod(@TCustomTreeView.LoadFromFile, 'LoadFromFile');
    RegisterMethod(@TCustomTreeView.LoadFromStream, 'LoadFromStream');
    RegisterMethod(@TCustomTreeView.SaveToFile, 'SaveToFile');
    RegisterMethod(@TCustomTreeView.SaveToStream, 'SaveToStream');
    RegisterMethod(@TCustomTreeView.WriteDebugReport, 'WriteDebugReport');
    RegisterMethod(@TCustomTreeView.LockSelectionChangeEvent, 'LockSelectionChangeEvent');
    RegisterMethod(@TCustomTreeView.UnlockSelectionChangeEvent, 'UnlockSelectionChangeEvent');
    RegisterMethod(@TCustomTreeView.GetFirstMultiSelected, 'GetFirstMultiSelected');
    RegisterMethod(@TCustomTreeView.GetLastMultiSelected, 'GetLastMultiSelected');
    RegisterMethod(@TCustomTreeView.SelectionVisible, 'SelectionVisible');
    RegisterMethod(@TCustomTreeView.MakeSelectionVisible, 'MakeSelectionVisible');
    RegisterMethod(@TCustomTreeView.ClearInvisibleSelection, 'ClearInvisibleSelection');
    RegisterMethod(@TCustomTreeView.StoreCurrentSelection, 'StoreCurrentSelection');
    RegisterMethod(@TCustomTreeView.ApplyStoredSelection, 'ApplyStoredSelection');
    RegisterMethod(@TCustomTreeView.MoveToNextNode, 'MoveToNextNode');
    RegisterMethod(@TCustomTreeView.MoveToPrevNode, 'MoveToPrevNode');
    RegisterPropertyHelper(@TCustomTreeViewBackgroundColor_R,@TCustomTreeViewBackgroundColor_W,'BackgroundColor');
    RegisterPropertyHelper(@TCustomTreeViewBottomItem_R,@TCustomTreeViewBottomItem_W,'BottomItem');
    RegisterPropertyHelper(@TCustomTreeViewDefaultItemHeight_R,@TCustomTreeViewDefaultItemHeight_W,'DefaultItemHeight');
    RegisterPropertyHelper(@TCustomTreeViewDropTarget_R,@TCustomTreeViewDropTarget_W,'DropTarget');
    RegisterPropertyHelper(@TCustomTreeViewExpandSignType_R,@TCustomTreeViewExpandSignType_W,'ExpandSignType');
    RegisterPropertyHelper(@TCustomTreeViewInsertMarkNode_R,@TCustomTreeViewInsertMarkNode_W,'InsertMarkNode');
    RegisterPropertyHelper(@TCustomTreeViewInsertMarkType_R,@TCustomTreeViewInsertMarkType_W,'InsertMarkType');
    RegisterPropertyHelper(@TCustomTreeViewItems_R,@TCustomTreeViewItems_W,'Items');
    RegisterPropertyHelper(@TCustomTreeViewKeepCollapsedNodes_R,@TCustomTreeViewKeepCollapsedNodes_W,'KeepCollapsedNodes');
    RegisterPropertyHelper(@TCustomTreeViewMultiSelectStyle_R,@TCustomTreeViewMultiSelectStyle_W,'MultiSelectStyle');
    RegisterPropertyHelper(@TCustomTreeViewOptions_R,@TCustomTreeViewOptions_W,'Options');
    RegisterPropertyHelper(@TCustomTreeViewScrollBars_R,@TCustomTreeViewScrollBars_W,'ScrollBars');
    RegisterPropertyHelper(@TCustomTreeViewSelected_R,@TCustomTreeViewSelected_W,'Selected');
    RegisterPropertyHelper(@TCustomTreeViewSelectionColor_R,@TCustomTreeViewSelectionColor_W,'SelectionColor');
    RegisterPropertyHelper(@TCustomTreeViewSelectionCount_R,nil,'SelectionCount');
    RegisterPropertyHelper(@TCustomTreeViewSelections_R,nil,'Selections');
    RegisterPropertyHelper(@TCustomTreeViewSeparatorColor_R,@TCustomTreeViewSeparatorColor_W,'SeparatorColor');
    RegisterPropertyHelper(@TCustomTreeViewTopItem_R,@TCustomTreeViewTopItem_W,'TopItem');
    RegisterPropertyHelper(@TCustomTreeViewTreeLineColor_R,@TCustomTreeViewTreeLineColor_W,'TreeLineColor');
    RegisterPropertyHelper(@TCustomTreeViewTreeLinePenStyle_R,@TCustomTreeViewTreeLinePenStyle_W,'TreeLinePenStyle');
    RegisterPropertyHelper(@TCustomTreeViewExpandSignColor_R,@TCustomTreeViewExpandSignColor_W,'ExpandSignColor');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTreeNodes(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTreeNodes) do
  begin
    RegisterConstructor(@TTreeNodes.Create, 'Create');
    RegisterMethod(@TTreeNodes.Add, 'Add');
    RegisterMethod(@TTreeNodes.AddChild, 'AddChild');
    RegisterMethod(@TTreeNodes.AddChildFirst, 'AddChildFirst');
    RegisterMethod(@TTreeNodes.AddChildObject, 'AddChildObject');
    RegisterMethod(@TTreeNodes.AddChildObjectFirst, 'AddChildObjectFirst');
    RegisterMethod(@TTreeNodes.AddFirst, 'AddFirst');
    RegisterMethod(@TTreeNodes.AddNode, 'AddNode');
    RegisterMethod(@TTreeNodes.AddObject, 'AddObject');
    RegisterMethod(@TTreeNodes.AddObjectFirst, 'AddObjectFirst');
    RegisterMethod(@TTreeNodes.FindNodeWithData, 'FindNodeWithData');
    RegisterMethod(@TTreeNodes.FindNodeWithText, 'FindNodeWithText');
    RegisterMethod(@TTreeNodes.FindTopLvlNode, 'FindTopLvlNode');
    RegisterMethod(@TTreeNodes.GetEnumerator, 'GetEnumerator');
    RegisterMethod(@TTreeNodes.GetFirstNode, 'GetFirstNode');
    RegisterMethod(@TTreeNodes.GetFirstVisibleNode, 'GetFirstVisibleNode');
    RegisterMethod(@TTreeNodes.GetLastExpandedSubNode, 'GetLastExpandedSubNode');
    RegisterMethod(@TTreeNodes.GetLastNode, 'GetLastNode');
    RegisterMethod(@TTreeNodes.GetLastSubNode, 'GetLastSubNode');
    RegisterMethod(@TTreeNodes.GetLastVisibleNode, 'GetLastVisibleNode');
    RegisterMethod(@TTreeNodes.GetSelections, 'GetSelections');
    RegisterMethod(@TTreeNodes.Insert, 'Insert');
    RegisterMethod(@TTreeNodes.InsertBehind, 'InsertBehind');
    RegisterMethod(@TTreeNodes.InsertObject, 'InsertObject');
    RegisterMethod(@TTreeNodes.InsertObjectBehind, 'InsertObjectBehind');
    RegisterMethod(@TTreeNodes.IsMultiSelection, 'IsMultiSelection');
    RegisterMethod(@TTreeNodes.BeginUpdate, 'BeginUpdate');
    RegisterMethod(@TTreeNodes.Clear, 'Clear');
    RegisterMethod(@TTreeNodes.ClearMultiSelection, 'ClearMultiSelection');
    RegisterMethod(@TTreeNodes.ConsistencyCheck, 'ConsistencyCheck');
    RegisterMethod(@TTreeNodes.Delete, 'Delete');
    RegisterMethod(@TTreeNodes.EndUpdate, 'EndUpdate');
    RegisterMethod(@TTreeNodes.FreeAllNodeData, 'FreeAllNodeData');
    RegisterMethod(@TTreeNodes.SelectionsChanged, 'SelectionsChanged');
    RegisterMethod(@TTreeNodes.SelectOnlyThis, 'SelectOnlyThis');
    RegisterMethod(@TTreeNodes.SortTopLevelNodes, 'SortTopLevelNodes');
    RegisterMethod(@TTreeNodes.WriteDebugReport, 'WriteDebugReport');
    RegisterPropertyHelper(@TTreeNodesCount_R,nil,'Count');
    RegisterPropertyHelper(@TTreeNodesItem_R,nil,'Item');
    RegisterPropertyHelper(@TTreeNodesKeepCollapsedNodes_R,@TTreeNodesKeepCollapsedNodes_W,'KeepCollapsedNodes');
    RegisterPropertyHelper(@TTreeNodesOwner_R,nil,'Owner');
    RegisterPropertyHelper(@TTreeNodesSelectionCount_R,nil,'SelectionCount');
    RegisterPropertyHelper(@TTreeNodesTopLvlCount_R,nil,'TopLvlCount');
    RegisterPropertyHelper(@TTreeNodesTopLvlItems_R,@TTreeNodesTopLvlItems_W,'TopLvlItems');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTreeNodesEnumerator(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTreeNodesEnumerator) do
  begin
    RegisterConstructor(@TTreeNodesEnumerator.Create, 'Create');
    RegisterMethod(@TTreeNodesEnumerator.MoveNext, 'MoveNext');
    RegisterPropertyHelper(@TTreeNodesEnumeratorCurrent_R,nil,'Current');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTreeNode(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTreeNode) do
  begin
    RegisterConstructor(@TTreeNode.Create, 'Create');
    RegisterMethod(@TTreeNode.AlphaSort, 'AlphaSort');
    RegisterMethod(@TTreeNode.Bottom, 'Bottom');
    RegisterMethod(@TTreeNode.BottomExpanded, 'BottomExpanded');
    RegisterMethod(@TTreeNode.CustomSort, 'CustomSort');
    RegisterMethod(@TTreeNode.DefaultTreeViewSort, 'DefaultTreeViewSort');
    RegisterMethod(@TTreeNode.DisplayExpandSignLeft, 'DisplayExpandSignLeft');
    RegisterMethod(@TTreeNode.DisplayExpandSignRect, 'DisplayExpandSignRect');
    RegisterMethod(@TTreeNode.DisplayExpandSignRight, 'DisplayExpandSignRight');
    RegisterMethod(@TTreeNode.DisplayIconLeft, 'DisplayIconLeft');
    RegisterMethod(@TTreeNode.DisplayRect, 'DisplayRect');
    RegisterMethod(@TTreeNode.DisplayStateIconLeft, 'DisplayStateIconLeft');
    RegisterMethod(@TTreeNode.DisplayTextLeft, 'DisplayTextLeft');
    RegisterMethod(@TTreeNode.DisplayTextRight, 'DisplayTextRight');
    RegisterMethod(@TTreeNode.EditText, 'EditText');
    RegisterMethod(@TTreeNode.FindNode, 'FindNode');
    RegisterMethod(@TTreeNode.GetFirstChild, 'GetFirstChild');
    RegisterMethod(@TTreeNode.GetFirstVisibleChild, 'GetFirstVisibleChild');
    RegisterMethod(@TTreeNode.GetHandle, 'GetHandle');
    RegisterMethod(@TTreeNode.GetLastChild, 'GetLastChild');
    RegisterMethod(@TTreeNode.GetLastSibling, 'GetLastSibling');
    RegisterMethod(@TTreeNode.GetLastSubChild, 'GetLastSubChild');
    RegisterMethod(@TTreeNode.GetLastVisibleChild, 'GetLastVisibleChild');
    RegisterMethod(@TTreeNode.GetNext, 'GetNext');
    RegisterMethod(@TTreeNode.GetNextChild, 'GetNextChild');
    RegisterMethod(@TTreeNode.GetNextExpanded, 'GetNextExpanded');
    RegisterMethod(@TTreeNode.GetNextMultiSelected, 'GetNextMultiSelected');
    RegisterMethod(@TTreeNode.GetNextSibling, 'GetNextSibling');
    RegisterMethod(@TTreeNode.GetNextSkipChildren, 'GetNextSkipChildren');
    RegisterMethod(@TTreeNode.GetNextVisible, 'GetNextVisible');
    RegisterMethod(@TTreeNode.GetNextVisibleSibling, 'GetNextVisibleSibling');
    RegisterMethod(@TTreeNode.GetParentNodeOfAbsoluteLevel, 'GetParentNodeOfAbsoluteLevel');
    RegisterMethod(@TTreeNode.GetPrev, 'GetPrev');
    RegisterMethod(@TTreeNode.GetPrevChild, 'GetPrevChild');
    RegisterMethod(@TTreeNode.GetPrevExpanded, 'GetPrevExpanded');
    RegisterMethod(@TTreeNode.GetPrevMultiSelected, 'GetPrevMultiSelected');
    RegisterMethod(@TTreeNode.GetPrevSibling, 'GetPrevSibling');
    RegisterMethod(@TTreeNode.GetPrevVisible, 'GetPrevVisible');
    RegisterMethod(@TTreeNode.GetPrevVisibleSibling, 'GetPrevVisibleSibling');
    RegisterMethod(@TTreeNode.GetTextPath, 'GetTextPath');
    RegisterMethod(@TTreeNode.HasAsParent, 'HasAsParent');
    RegisterMethod(@TTreeNode.IndexOf, 'IndexOf');
    RegisterMethod(@TTreeNode.IndexOfText, 'IndexOfText');
    RegisterMethod(@TTreeNode.Collapse, 'Collapse');
    RegisterMethod(@TTreeNode.ConsistencyCheck, 'ConsistencyCheck');
    RegisterMethod(@TTreeNode.Delete, 'Delete');
    RegisterMethod(@TTreeNode.DeleteChildren, 'DeleteChildren');
    RegisterMethod(@TTreeNode.EndEdit, 'EndEdit');
    RegisterMethod(@TTreeNode.Expand, 'Expand');
    RegisterMethod(@TTreeNode.ExpandParents, 'ExpandParents');
    RegisterMethod(@TTreeNode.FreeAllNodeData, 'FreeAllNodeData');
    RegisterMethod(@TTreeNode.MakeVisible, 'MakeVisible');
    RegisterVirtualMethod(@TTreeNode.MoveTo, 'MoveTo');
    RegisterMethod(@TTreeNode.MultiSelectGroup, 'MultiSelectGroup');
    RegisterMethod(@TTreeNode.Update, 'Update');
    RegisterMethod(@TTreeNode.WriteDebugReport, 'WriteDebugReport');
    RegisterPropertyHelper(@TTreeNodeAbsoluteIndex_R,nil,'AbsoluteIndex');
    RegisterPropertyHelper(@TTreeNodeCount_R,nil,'Count');
    RegisterPropertyHelper(@TTreeNodeCut_R,@TTreeNodeCut_W,'Cut');
    RegisterPropertyHelper(@TTreeNodeData_R,@TTreeNodeData_W,'Data');
    RegisterPropertyHelper(@TTreeNodeDeleting_R,nil,'Deleting');
    RegisterPropertyHelper(@TTreeNodeDropTarget_R,@TTreeNodeDropTarget_W,'DropTarget');
    RegisterPropertyHelper(@TTreeNodeExpanded_R,@TTreeNodeExpanded_W,'Expanded');
    RegisterPropertyHelper(@TTreeNodeFocused_R,@TTreeNodeFocused_W,'Focused');
    RegisterPropertyHelper(@TTreeNodeHandle_R,nil,'Handle');
    RegisterPropertyHelper(@TTreeNodeHasChildren_R,@TTreeNodeHasChildren_W,'HasChildren');
    RegisterPropertyHelper(@TTreeNodeHeight_R,@TTreeNodeHeight_W,'Height');
    RegisterPropertyHelper(@TTreeNodeImageIndex_R,@TTreeNodeImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TTreeNodeIndex_R,@TTreeNodeIndex_W,'Index');
    RegisterPropertyHelper(@TTreeNodeIsFullHeightVisible_R,nil,'IsFullHeightVisible');
    RegisterPropertyHelper(@TTreeNodeIsVisible_R,nil,'IsVisible');
    RegisterPropertyHelper(@TTreeNodeItems_R,@TTreeNodeItems_W,'Items');
    RegisterPropertyHelper(@TTreeNodeLevel_R,nil,'Level');
    RegisterPropertyHelper(@TTreeNodeMultiSelected_R,@TTreeNodeMultiSelected_W,'MultiSelected');
    RegisterPropertyHelper(@TTreeNodeNodeEffect_R,@TTreeNodeNodeEffect_W,'NodeEffect');
    RegisterPropertyHelper(@TTreeNodeOverlayIndex_R,@TTreeNodeOverlayIndex_W,'OverlayIndex');
    RegisterPropertyHelper(@TTreeNodeOwner_R,nil,'Owner');
    RegisterPropertyHelper(@TTreeNodeParent_R,nil,'Parent');
    RegisterPropertyHelper(@TTreeNodeSelected_R,@TTreeNodeSelected_W,'Selected');
    RegisterPropertyHelper(@TTreeNodeSelectedIndex_R,@TTreeNodeSelectedIndex_W,'SelectedIndex');
    RegisterPropertyHelper(@TTreeNodeStateIndex_R,@TTreeNodeStateIndex_W,'StateIndex');
    RegisterPropertyHelper(@TTreeNodeSubTreeCount_R,nil,'SubTreeCount');
    RegisterPropertyHelper(@TTreeNodeText_R,@TTreeNodeText_W,'Text');
    RegisterPropertyHelper(@TTreeNodeTop_R,nil,'Top');
    RegisterPropertyHelper(@TTreeNodeTreeNodes_R,nil,'TreeNodes');
    RegisterPropertyHelper(@TTreeNodeTreeView_R,nil,'TreeView');
    RegisterPropertyHelper(@TTreeNodeVisible_R,@TTreeNodeVisible_W,'Visible');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTrackBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTrackBar) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomTrackBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomTrackBar) do
  begin
    RegisterMethod(@TCustomTrackBar.SetTick, 'SetTick');
    RegisterPropertyHelper(@TCustomTrackBarFrequency_R,@TCustomTrackBarFrequency_W,'Frequency');
    RegisterPropertyHelper(@TCustomTrackBarLineSize_R,@TCustomTrackBarLineSize_W,'LineSize');
    RegisterPropertyHelper(@TCustomTrackBarMax_R,@TCustomTrackBarMax_W,'Max');
    RegisterPropertyHelper(@TCustomTrackBarMin_R,@TCustomTrackBarMin_W,'Min');
    RegisterPropertyHelper(@TCustomTrackBarOnChange_R,@TCustomTrackBarOnChange_W,'OnChange');
    RegisterPropertyHelper(@TCustomTrackBarOrientation_R,@TCustomTrackBarOrientation_W,'Orientation');
    RegisterPropertyHelper(@TCustomTrackBarPageSize_R,@TCustomTrackBarPageSize_W,'PageSize');
    RegisterPropertyHelper(@TCustomTrackBarPosition_R,@TCustomTrackBarPosition_W,'Position');
    RegisterPropertyHelper(@TCustomTrackBarReversed_R,@TCustomTrackBarReversed_W,'Reversed');
    RegisterPropertyHelper(@TCustomTrackBarScalePos_R,@TCustomTrackBarScalePos_W,'ScalePos');
    RegisterPropertyHelper(@TCustomTrackBarSelEnd_R,@TCustomTrackBarSelEnd_W,'SelEnd');
    RegisterPropertyHelper(@TCustomTrackBarSelStart_R,@TCustomTrackBarSelStart_W,'SelStart');
    RegisterPropertyHelper(@TCustomTrackBarShowSelRange_R,@TCustomTrackBarShowSelRange_W,'ShowSelRange');
    RegisterPropertyHelper(@TCustomTrackBarTickMarks_R,@TCustomTrackBarTickMarks_W,'TickMarks');
    RegisterPropertyHelper(@TCustomTrackBarTickStyle_R,@TCustomTrackBarTickStyle_W,'TickStyle');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCoolBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCoolBar) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomCoolBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomCoolBar) do
  begin
    RegisterPropertyHelper(@TCustomCoolBarBandBorderStyle_R,@TCustomCoolBarBandBorderStyle_W,'BandBorderStyle');
    RegisterPropertyHelper(@TCustomCoolBarBandMaximize_R,@TCustomCoolBarBandMaximize_W,'BandMaximize');
    RegisterPropertyHelper(@TCustomCoolBarBands_R,@TCustomCoolBarBands_W,'Bands');
    RegisterPropertyHelper(@TCustomCoolBarFixedSize_R,@TCustomCoolBarFixedSize_W,'FixedSize');
    RegisterPropertyHelper(@TCustomCoolBarFixedOrder_R,@TCustomCoolBarFixedOrder_W,'FixedOrder');
    RegisterPropertyHelper(@TCustomCoolBarImages_R,@TCustomCoolBarImages_W,'Images');
    RegisterPropertyHelper(@TCustomCoolBarBitmap_R,@TCustomCoolBarBitmap_W,'Bitmap');
    RegisterPropertyHelper(@TCustomCoolBarShowText_R,@TCustomCoolBarShowText_W,'ShowText');
    RegisterPropertyHelper(@TCustomCoolBarVertical_R,@TCustomCoolBarVertical_W,'Vertical');
    RegisterPropertyHelper(@TCustomCoolBarOnChange_R,@TCustomCoolBarOnChange_W,'OnChange');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCoolBands(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCoolBands) do
  begin
    RegisterConstructor(@TCoolBands.Create, 'Create');
    RegisterMethod(@TCoolBands.Add, 'Add');
    RegisterMethod(@TCoolBands.FindBand, 'FindBand');
    RegisterPropertyHelper(@TCoolBandsItems_R,@TCoolBandsItems_W,'Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCoolBand(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCoolBand) do
  begin
    RegisterPropertyHelper(@TCoolBandHeight_R,nil,'Height');
    RegisterPropertyHelper(@TCoolBandBitmap_R,@TCoolBandBitmap_W,'Bitmap');
    RegisterPropertyHelper(@TCoolBandBorderStyle_R,@TCoolBandBorderStyle_W,'BorderStyle');
    RegisterPropertyHelper(@TCoolBandBreak_R,@TCoolBandBreak_W,'Break');
    RegisterPropertyHelper(@TCoolBandColor_R,@TCoolBandColor_W,'Color');
    RegisterPropertyHelper(@TCoolBandControl_R,@TCoolBandControl_W,'Control');
    RegisterPropertyHelper(@TCoolBandFixedBackground_R,@TCoolBandFixedBackground_W,'FixedBackground');
    RegisterPropertyHelper(@TCoolBandFixedSize_R,@TCoolBandFixedSize_W,'FixedSize');
    RegisterPropertyHelper(@TCoolBandHorizontalOnly_R,@TCoolBandHorizontalOnly_W,'HorizontalOnly');
    RegisterPropertyHelper(@TCoolBandImageIndex_R,@TCoolBandImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TCoolBandMinHeight_R,@TCoolBandMinHeight_W,'MinHeight');
    RegisterPropertyHelper(@TCoolBandMinWidth_R,@TCoolBandMinWidth_W,'MinWidth');
    RegisterPropertyHelper(@TCoolBandParentColor_R,@TCoolBandParentColor_W,'ParentColor');
    RegisterPropertyHelper(@TCoolBandParentBitmap_R,@TCoolBandParentBitmap_W,'ParentBitmap');
    RegisterPropertyHelper(@TCoolBandText_R,@TCoolBandText_W,'Text');
    RegisterPropertyHelper(@TCoolBandVisible_R,@TCoolBandVisible_W,'Visible');
    RegisterPropertyHelper(@TCoolBandWidth_R,@TCoolBandWidth_W,'Width');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TToolBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TToolBar) do
  begin
    RegisterMethod(@TToolBar.GetEnumerator, 'GetEnumerator');
    RegisterMethod(@TToolBar.SetButtonSize, 'SetButtonSize');
    RegisterPropertyHelper(@TToolBarButtonCount_R,nil,'ButtonCount');
    RegisterPropertyHelper(@TToolBarButtons_R,nil,'Buttons');
    RegisterPropertyHelper(@TToolBarButtonList_R,nil,'ButtonList');
    RegisterPropertyHelper(@TToolBarRowCount_R,nil,'RowCount');
    RegisterPropertyHelper(@TToolBarButtonHeight_R,@TToolBarButtonHeight_W,'ButtonHeight');
    RegisterPropertyHelper(@TToolBarButtonWidth_R,@TToolBarButtonWidth_W,'ButtonWidth');
    RegisterPropertyHelper(@TToolBarDisabledImages_R,@TToolBarDisabledImages_W,'DisabledImages');
    RegisterPropertyHelper(@TToolBarFlat_R,@TToolBarFlat_W,'Flat');
    RegisterPropertyHelper(@TToolBarHotImages_R,@TToolBarHotImages_W,'HotImages');
    RegisterPropertyHelper(@TToolBarImages_R,@TToolBarImages_W,'Images');
    RegisterPropertyHelper(@TToolBarIndent_R,@TToolBarIndent_W,'Indent');
    RegisterPropertyHelper(@TToolBarList_R,@TToolBarList_W,'List');
    RegisterPropertyHelper(@TToolBarShowCaptions_R,@TToolBarShowCaptions_W,'ShowCaptions');
    RegisterPropertyHelper(@TToolBarTransparent_R,@TToolBarTransparent_W,'Transparent');
    RegisterPropertyHelper(@TToolBarWrapable_R,@TToolBarWrapable_W,'Wrapable');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TToolBarEnumerator(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TToolBarEnumerator) do
  begin
    RegisterConstructor(@TToolBarEnumerator.Create, 'Create');
    RegisterMethod(@TToolBarEnumerator.MoveNext, 'MoveNext');
    RegisterPropertyHelper(@TToolBarEnumeratorCurrent_R,nil,'Current');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TToolButton(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TToolButton) do
  begin
    RegisterVirtualMethod(@TToolButton.CheckMenuDropdown, 'CheckMenuDropdown');
    RegisterVirtualMethod(@TToolButton.GetCurrentIcon, 'GetCurrentIcon');
    RegisterPropertyHelper(@TToolButtonIndex_R,nil,'Index');
    RegisterPropertyHelper(@TToolButtonAllowAllUp_R,@TToolButtonAllowAllUp_W,'AllowAllUp');
    RegisterPropertyHelper(@TToolButtonDown_R,@TToolButtonDown_W,'Down');
    RegisterPropertyHelper(@TToolButtonDropdownMenu_R,@TToolButtonDropdownMenu_W,'DropdownMenu');
    RegisterPropertyHelper(@TToolButtonGrouped_R,@TToolButtonGrouped_W,'Grouped');
    RegisterPropertyHelper(@TToolButtonImageIndex_R,@TToolButtonImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TToolButtonIndeterminate_R,@TToolButtonIndeterminate_W,'Indeterminate');
    RegisterPropertyHelper(@TToolButtonMarked_R,@TToolButtonMarked_W,'Marked');
    RegisterPropertyHelper(@TToolButtonMenuItem_R,@TToolButtonMenuItem_W,'MenuItem');
    RegisterPropertyHelper(@TToolButtonShowCaption_R,@TToolButtonShowCaption_W,'ShowCaption');
    RegisterPropertyHelper(@TToolButtonStyle_R,@TToolButtonStyle_W,'Style');
    RegisterPropertyHelper(@TToolButtonWrap_R,@TToolButtonWrap_W,'Wrap');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TToolButtonActionLink(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TToolButtonActionLink) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TUpDown(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TUpDown) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomUpDown(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomUpDown) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TProgressBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TProgressBar) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomProgressBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomProgressBar) do
  begin
    RegisterMethod(@TCustomProgressBar.StepIt, 'StepIt');
    RegisterMethod(@TCustomProgressBar.StepBy, 'StepBy');
    RegisterPropertyHelper(@TCustomProgressBarMax_R,@TCustomProgressBarMax_W,'Max');
    RegisterPropertyHelper(@TCustomProgressBarMin_R,@TCustomProgressBarMin_W,'Min');
    RegisterPropertyHelper(@TCustomProgressBarOrientation_R,@TCustomProgressBarOrientation_W,'Orientation');
    RegisterPropertyHelper(@TCustomProgressBarPosition_R,@TCustomProgressBarPosition_W,'Position');
    RegisterPropertyHelper(@TCustomProgressBarSmooth_R,@TCustomProgressBarSmooth_W,'Smooth');
    RegisterPropertyHelper(@TCustomProgressBarStep_R,@TCustomProgressBarStep_W,'Step');
    RegisterPropertyHelper(@TCustomProgressBarStyle_R,@TCustomProgressBarStyle_W,'Style');
    RegisterPropertyHelper(@TCustomProgressBarBarShowText_R,@TCustomProgressBarBarShowText_W,'BarShowText');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListView(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListView) do
  begin
    RegisterPropertyHelper(@TListViewAutoWidthLastColumn_R,@TListViewAutoWidthLastColumn_W,'AutoWidthLastColumn');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomListView(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomListView) do
  begin
    RegisterMethod(@TCustomListView.AlphaSort, 'AlphaSort');
    RegisterMethod(@TCustomListView.BeginUpdate, 'BeginUpdate');
    RegisterMethod(@TCustomListView.Clear, 'Clear');
    RegisterMethod(@TCustomListView.EndUpdate, 'EndUpdate');
    RegisterMethod(@TCustomListView.FindCaption, 'FindCaption');
    RegisterMethod(@TCustomListView.FindData, 'FindData');
    RegisterMethod(@TCustomListView.GetHitTestInfoAt, 'GetHitTestInfoAt');
    RegisterMethod(@TCustomListView.GetItemAt, 'GetItemAt');
    RegisterMethod(@TCustomListView.GetNearestItem, 'GetNearestItem');
    RegisterMethod(@TCustomListView.GetNextItem, 'GetNextItem');
    RegisterMethod(@TCustomListView.IsEditing, 'IsEditing');
    RegisterPropertyHelper(@TCustomListViewBoundingRect_R,nil,'BoundingRect');
    RegisterPropertyHelper(@TCustomListViewCanvas_R,nil,'Canvas');
    RegisterPropertyHelper(@TCustomListViewCheckboxes_R,@TCustomListViewCheckboxes_W,'Checkboxes');
    RegisterPropertyHelper(@TCustomListViewColumn_R,nil,'Column');
    RegisterPropertyHelper(@TCustomListViewColumnCount_R,nil,'ColumnCount');
    RegisterPropertyHelper(@TCustomListViewDropTarget_R,@TCustomListViewDropTarget_W,'DropTarget');
    RegisterPropertyHelper(@TCustomListViewFlatScrollBars_R,@TCustomListViewFlatScrollBars_W,'FlatScrollBars');
    RegisterPropertyHelper(@TCustomListViewFullDrag_R,@TCustomListViewFullDrag_W,'FullDrag');
    RegisterPropertyHelper(@TCustomListViewGridLines_R,@TCustomListViewGridLines_W,'GridLines');
    RegisterPropertyHelper(@TCustomListViewHotTrack_R,@TCustomListViewHotTrack_W,'HotTrack');
    RegisterPropertyHelper(@TCustomListViewHotTrackStyles_R,@TCustomListViewHotTrackStyles_W,'HotTrackStyles');
    RegisterPropertyHelper(@TCustomListViewIconOptions_R,@TCustomListViewIconOptions_W,'IconOptions');
    RegisterPropertyHelper(@TCustomListViewItemFocused_R,@TCustomListViewItemFocused_W,'ItemFocused');
    RegisterPropertyHelper(@TCustomListViewItemIndex_R,@TCustomListViewItemIndex_W,'ItemIndex');
    RegisterPropertyHelper(@TCustomListViewItems_R,@TCustomListViewItems_W,'Items');
    RegisterPropertyHelper(@TCustomListViewMultiSelect_R,@TCustomListViewMultiSelect_W,'MultiSelect');
    RegisterPropertyHelper(@TCustomListViewOwnerData_R,@TCustomListViewOwnerData_W,'OwnerData');
    RegisterPropertyHelper(@TCustomListViewReadOnly_R,@TCustomListViewReadOnly_W,'ReadOnly');
    RegisterPropertyHelper(@TCustomListViewRowSelect_R,@TCustomListViewRowSelect_W,'RowSelect');
    RegisterPropertyHelper(@TCustomListViewSelCount_R,nil,'SelCount');
    RegisterPropertyHelper(@TCustomListViewSelected_R,@TCustomListViewSelected_W,'Selected');
    RegisterPropertyHelper(@TCustomListViewTopItem_R,nil,'TopItem');
    RegisterPropertyHelper(@TCustomListViewViewOrigin_R,@TCustomListViewViewOrigin_W,'ViewOrigin');
    RegisterPropertyHelper(@TCustomListViewVisibleRowCount_R,nil,'VisibleRowCount');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomListViewEditor(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomListViewEditor) do
  begin
    RegisterPropertyHelper(@TCustomListViewEditorItem_R,@TCustomListViewEditorItem_W,'Item');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListColumns(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListColumns) do
  begin
    RegisterConstructor(@TListColumns.Create, 'Create');
    RegisterMethod(@TListColumns.Add, 'Add');
    RegisterPropertyHelper(@TListColumnsOwner_R,nil,'Owner');
    RegisterPropertyHelper(@TListColumnsItems_R,@TListColumnsItems_W,'Items');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListColumn(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListColumn) do
  begin
    RegisterPropertyHelper(@TListColumnWidthType_R,nil,'WidthType');
    RegisterPropertyHelper(@TListColumnAlignment_R,@TListColumnAlignment_W,'Alignment');
    RegisterPropertyHelper(@TListColumnAutoSize_R,@TListColumnAutoSize_W,'AutoSize');
    RegisterPropertyHelper(@TListColumnCaption_R,@TListColumnCaption_W,'Caption');
    RegisterPropertyHelper(@TListColumnImageIndex_R,@TListColumnImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TListColumnMaxWidth_R,@TListColumnMaxWidth_W,'MaxWidth');
    RegisterPropertyHelper(@TListColumnMinWidth_R,@TListColumnMinWidth_W,'MinWidth');
    RegisterPropertyHelper(@TListColumnTag_R,@TListColumnTag_W,'Tag');
    RegisterPropertyHelper(@TListColumnVisible_R,@TListColumnVisible_W,'Visible');
    RegisterPropertyHelper(@TListColumnWidth_R,@TListColumnWidth_W,'Width');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TOwnerDataListItems(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOwnerDataListItems) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListItems(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListItems) do
  begin
    RegisterMethod(@TListItems.Add, 'Add');
    RegisterMethod(@TListItems.AddItem, 'AddItem');
    RegisterMethod(@TListItems.BeginUpdate, 'BeginUpdate');
    RegisterVirtualMethod(@TListItems.Clear, 'Clear');
    RegisterConstructor(@TListItems.Create, 'Create');
    RegisterMethod(@TListItems.Delete, 'Delete');
    RegisterMethod(@TListItems.EndUpdate, 'EndUpdate');
    RegisterMethod(@TListItems.Exchange, 'Exchange');
    RegisterMethod(@TListItems.Move, 'Move');
    RegisterMethod(@TListItems.FindCaption, 'FindCaption');
    RegisterMethod(@TListItemsFindData0, 'FindData0');
    RegisterMethod(@TListItemsFindData1, 'FindData1');
    RegisterMethod(@TListItems.GetEnumerator, 'GetEnumerator');
    RegisterMethod(@TListItems.IndexOf, 'IndexOf');
    RegisterMethod(@TListItems.Insert, 'Insert');
    RegisterMethod(@TListItems.InsertItem, 'InsertItem');
    RegisterPropertyHelper(@TListItemsFlags_R,nil,'Flags');
    RegisterPropertyHelper(@TListItemsCount_R,@TListItemsCount_W,'Count');
    RegisterPropertyHelper(@TListItemsItem_R,@TListItemsItem_W,'Item');
    RegisterPropertyHelper(@TListItemsOwner_R,nil,'Owner');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListItemsEnumerator(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListItemsEnumerator) do
  begin
    RegisterConstructor(@TListItemsEnumerator.Create, 'Create');
    RegisterMethod(@TListItemsEnumerator.MoveNext, 'MoveNext');
    RegisterPropertyHelper(@TListItemsEnumeratorCurrent_R,nil,'Current');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TOwnerDataListItem(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOwnerDataListItem) do
  begin
    RegisterMethod(@TOwnerDataListItem.SetDataIndex, 'SetDataIndex');
    RegisterMethod(@TOwnerDataListItem.SetOwner, 'SetOwner');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TListItem(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TListItem) do
  begin
    RegisterVirtualConstructor(@TListItem.Create, 'Create');
    RegisterMethod(@TListItem.Delete, 'Delete');
    RegisterMethod(@TListItem.MakeVisible, 'MakeVisible');
    RegisterMethod(@TListItem.DisplayRect, 'DisplayRect');
    RegisterMethod(@TListItem.DisplayRectSubItem, 'DisplayRectSubItem');
    RegisterMethod(@TListItem.EditCaption, 'EditCaption');
    RegisterPropertyHelper(@TListItemCaption_R,@TListItemCaption_W,'Caption');
    RegisterPropertyHelper(@TListItemChecked_R,@TListItemChecked_W,'Checked');
    RegisterPropertyHelper(@TListItemCut_R,@TListItemCut_W,'Cut');
    RegisterPropertyHelper(@TListItemData_R,@TListItemData_W,'Data');
    RegisterPropertyHelper(@TListItemDropTarget_R,@TListItemDropTarget_W,'DropTarget');
    RegisterPropertyHelper(@TListItemFocused_R,@TListItemFocused_W,'Focused');
    RegisterPropertyHelper(@TListItemIndex_R,nil,'Index');
    RegisterPropertyHelper(@TListItemImageIndex_R,@TListItemImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TListItemLeft_R,@TListItemLeft_W,'Left');
    RegisterPropertyHelper(@TListItemListView_R,nil,'ListView');
    RegisterPropertyHelper(@TListItemOwner_R,nil,'Owner');
    RegisterPropertyHelper(@TListItemPosition_R,@TListItemPosition_W,'Position');
    RegisterPropertyHelper(@TListItemSelected_R,@TListItemSelected_W,'Selected');
    RegisterPropertyHelper(@TListItemStateIndex_R,@TListItemStateIndex_W,'StateIndex');
    RegisterPropertyHelper(@TListItemSubItems_R,@TListItemSubItems_W,'SubItems');
    RegisterPropertyHelper(@TListItemSubItemImages_R,@TListItemSubItemImages_W,'SubItemImages');
    RegisterPropertyHelper(@TListItemTop_R,@TListItemTop_W,'Top');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIconOptions(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIconOptions) do
  begin
    RegisterConstructor(@TIconOptions.Create, 'Create');
    RegisterPropertyHelper(@TIconOptionsArrangement_R,@TIconOptionsArrangement_W,'Arrangement');
    RegisterPropertyHelper(@TIconOptionsAutoArrange_R,@TIconOptionsAutoArrange_W,'AutoArrange');
    RegisterPropertyHelper(@TIconOptionsWrapText_R,@TIconOptionsWrapText_W,'WrapText');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTabControl(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTabControl) do
  begin
    RegisterMethod(@TTabControl.IndexOfTabAt, 'IndexOfTabAt');
    RegisterMethod(@TTabControl.GetHitTestInfoAt, 'GetHitTestInfoAt');
    RegisterMethod(@TTabControl.IndexOfTabWithCaption, 'IndexOfTabWithCaption');
    RegisterMethod(@TTabControl.TabRect, 'TabRect');
    RegisterMethod(@TTabControl.RowCount, 'RowCount');
    RegisterMethod(@TTabControl.ScrollTabs, 'ScrollTabs');
    RegisterMethod(@TTabControl.BeginUpdate, 'BeginUpdate');
    RegisterMethod(@TTabControl.EndUpdate, 'EndUpdate');
    RegisterMethod(@TTabControl.IsUpdating, 'IsUpdating');
    RegisterPropertyHelper(@TTabControlDisplayRect_R,nil,'DisplayRect');
    RegisterPropertyHelper(@TTabControlHotTrack_R,@TTabControlHotTrack_W,'HotTrack');
    RegisterPropertyHelper(@TTabControlMultiLine_R,@TTabControlMultiLine_W,'MultiLine');
    RegisterPropertyHelper(@TTabControlMultiSelect_R,@TTabControlMultiSelect_W,'MultiSelect');
    RegisterPropertyHelper(@TTabControlOnChange_R,@TTabControlOnChange_W,'OnChange');
    RegisterPropertyHelper(@TTabControlOwnerDraw_R,@TTabControlOwnerDraw_W,'OwnerDraw');
    RegisterPropertyHelper(@TTabControlRaggedRight_R,@TTabControlRaggedRight_W,'RaggedRight');
    RegisterPropertyHelper(@TTabControlScrollOpposite_R,@TTabControlScrollOpposite_W,'ScrollOpposite');
    RegisterPropertyHelper(@TTabControlTabHeight_R,@TTabControlTabHeight_W,'TabHeight');
    RegisterPropertyHelper(@TTabControlTabWidth_R,@TTabControlTabWidth_W,'TabWidth');
    RegisterPropertyHelper(@TTabControlTabIndex_R,@TTabControlTabIndex_W,'TabIndex');
    RegisterPropertyHelper(@TTabControlTabs_R,@TTabControlTabs_W,'Tabs');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTabControlNoteBookStrings(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTabControlNoteBookStrings) do
  begin
    RegisterPropertyHelper(@TTabControlNoteBookStringsNoteBook_R,nil,'NoteBook');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTabControlStrings(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTabControlStrings) do
  begin
    RegisterVirtualConstructor(@TTabControlStrings.Create, 'Create');
    RegisterVirtualMethod(@TTabControlStrings.GetHitTestInfoAt, 'GetHitTestInfoAt');
    RegisterVirtualAbstractMethod(TTabControlStrings_Impl, @TTabControlStrings_Impl.GetSize, 'GetSize');
    RegisterVirtualMethod(@TTabControlStrings.IndexOfTabAt, 'IndexOfTabAt');
    RegisterVirtualMethod(@TTabControlStrings.RowCount, 'RowCount');
    RegisterVirtualMethod(@TTabControlStrings.TabRect, 'TabRect');
    RegisterVirtualMethod(@TTabControlStrings.ImageListChange, 'ImageListChange');
    RegisterVirtualMethod(@TTabControlStrings.ScrollTabs, 'ScrollTabs');
    RegisterVirtualMethod(@TTabControlStrings.TabControlBoundsChange, 'TabControlBoundsChange');
    RegisterVirtualMethod(@TTabControlStrings.UpdateTabImages, 'UpdateTabImages');
    RegisterVirtualMethod(@TTabControlStrings.BeginUpdate, 'BeginUpdate');
    RegisterVirtualMethod(@TTabControlStrings.EndUpdate, 'EndUpdate');
    RegisterVirtualMethod(@TTabControlStrings.IsUpdating, 'IsUpdating');
    RegisterPropertyHelper(@TTabControlStringsTabControl_R,nil,'TabControl');
    RegisterPropertyHelper(@TTabControlStringsTabIndex_R,@TTabControlStringsTabIndex_W,'TabIndex');
    RegisterPropertyHelper(@TTabControlStringsHotTrack_R,@TTabControlStringsHotTrack_W,'HotTrack');
    RegisterPropertyHelper(@TTabControlStringsImages_R,@TTabControlStringsImages_W,'Images');
    RegisterPropertyHelper(@TTabControlStringsMultiLine_R,@TTabControlStringsMultiLine_W,'MultiLine');
    RegisterPropertyHelper(@TTabControlStringsMultiSelect_R,@TTabControlStringsMultiSelect_W,'MultiSelect');
    RegisterPropertyHelper(@TTabControlStringsOwnerDraw_R,@TTabControlStringsOwnerDraw_W,'OwnerDraw');
    RegisterPropertyHelper(@TTabControlStringsRaggedRight_R,@TTabControlStringsRaggedRight_W,'RaggedRight');
    RegisterPropertyHelper(@TTabControlStringsScrollOpposite_R,@TTabControlStringsScrollOpposite_W,'ScrollOpposite');
    RegisterPropertyHelper(@TTabControlStringsTabHeight_R,@TTabControlStringsTabHeight_W,'TabHeight');
    RegisterPropertyHelper(@TTabControlStringsTabWidth_R,@TTabControlStringsTabWidth_W,'TabWidth');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TPageControl(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TPageControl) do
  begin
    RegisterMethod(@TPageControl.FindNextPage, 'FindNextPage');
    RegisterMethod(@TPageControl.SelectNextPage, 'SelectNextPage');
    RegisterMethod(@TPageControl.SelectNextPage, 'SelectNextPage');
    RegisterMethod(@TPageControl.AddTabSheet, 'AddTabSheet');
    RegisterPropertyHelper(@TPageControlActivePageIndex_R,@TPageControlActivePageIndex_W,'ActivePageIndex');
    RegisterPropertyHelper(@TPageControlPages_R,nil,'Pages');
    RegisterPropertyHelper(@TPageControlActivePage_R,@TPageControlActivePage_W,'ActivePage');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTabSheet(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTabSheet) do
  begin
    RegisterPropertyHelper(@TTabSheetPageControl_R,@TTabSheetPageControl_W,'PageControl');
    RegisterPropertyHelper(@TTabSheetTabIndex_R,nil,'TabIndex');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomTabControl(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomTabControl) do
  begin
    RegisterMethod(@TCustomTabControl.TabIndexAtClientPos, 'TabIndexAtClientPos');
    RegisterMethod(@TCustomTabControl.TabRect, 'TabRect');
    RegisterVirtualMethod(@TCustomTabControl.GetImageIndex, 'GetImageIndex');
    RegisterVirtualMethod(@TCustomTabControl.IndexOf, 'IndexOf');
    RegisterMethod(@TCustomTabControl.CustomPage, 'CustomPage');
    RegisterVirtualMethod(@TCustomTabControl.CanChangePageIndex, 'CanChangePageIndex');
    RegisterVirtualMethod(@TCustomTabControl.GetMinimumTabWidth, 'GetMinimumTabWidth');
    RegisterVirtualMethod(@TCustomTabControl.GetMinimumTabHeight, 'GetMinimumTabHeight');
    RegisterVirtualMethod(@TCustomTabControl.GetCapabilities, 'GetCapabilities');
    RegisterMethod(@TCustomTabControl.TabToPageIndex, 'TabToPageIndex');
    RegisterMethod(@TCustomTabControl.PageToTabIndex, 'PageToTabIndex');
    RegisterMethod(@TCustomTabControl.IndexOfTabAt, 'IndexOfTabAt');
    RegisterVirtualMethod(@TCustomTabControl.DoCloseTabClicked, 'DoCloseTabClicked');
    RegisterPropertyHelper(@TCustomTabControlImages_R,@TCustomTabControlImages_W,'Images');
    RegisterPropertyHelper(@TCustomTabControlMultiLine_R,@TCustomTabControlMultiLine_W,'MultiLine');
    RegisterPropertyHelper(@TCustomTabControlOnChanging_R,@TCustomTabControlOnChanging_W,'OnChanging');
    RegisterPropertyHelper(@TCustomTabControlOnCloseTabClicked_R,@TCustomTabControlOnCloseTabClicked_W,'OnCloseTabClicked');
    RegisterPropertyHelper(@TCustomTabControlOnGetImageIndex_R,@TCustomTabControlOnGetImageIndex_W,'OnGetImageIndex');
    RegisterPropertyHelper(@TCustomTabControlOptions_R,@TCustomTabControlOptions_W,'Options');
    RegisterPropertyHelper(@TCustomTabControlPage_R,nil,'Page');
    RegisterPropertyHelper(@TCustomTabControlPageCount_R,nil,'PageCount');
    RegisterPropertyHelper(@TCustomTabControlPageIndex_R,@TCustomTabControlPageIndex_W,'PageIndex');
    RegisterPropertyHelper(@TCustomTabControlPages_R,@TCustomTabControlPages_W,'Pages');
    RegisterPropertyHelper(@TCustomTabControlShowTabs_R,@TCustomTabControlShowTabs_W,'ShowTabs');
    RegisterPropertyHelper(@TCustomTabControlTabPosition_R,@TCustomTabControlTabPosition_W,'TabPosition');
    RegisterPropertyHelper(@TCustomTabControlIsUnpaged_R,nil,'IsUnpaged');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TNBPages(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TNBPages) do
  begin
    RegisterConstructor(@TNBPages.Create, 'Create');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomPage(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomPage) do
  begin
    RegisterVirtualMethod(@TCustomPage.VisibleIndex, 'VisibleIndex');
    RegisterPropertyHelper(@TCustomPagePageIndex_R,@TCustomPagePageIndex_W,'PageIndex');
    RegisterPropertyHelper(@TCustomPageTabVisible_R,@TCustomPageTabVisible_W,'TabVisible');
    RegisterPropertyHelper(@TCustomPageImageIndex_R,@TCustomPageImageIndex_W,'ImageIndex');
    RegisterPropertyHelper(@TCustomPageOnHide_R,@TCustomPageOnHide_W,'OnHide');
    RegisterPropertyHelper(@TCustomPageOnShow_R,@TCustomPageOnShow_W,'OnShow');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TStatusBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TStatusBar) do
  begin
    RegisterVirtualMethod(@TStatusBar.InvalidatePanel, 'InvalidatePanel');
    RegisterMethod(@TStatusBar.BeginUpdate, 'BeginUpdate');
    RegisterMethod(@TStatusBar.EndUpdate, 'EndUpdate');
    RegisterMethod(@TStatusBar.GetPanelIndexAt, 'GetPanelIndexAt');
    RegisterMethod(@TStatusBar.SizeGripEnabled, 'SizeGripEnabled');
    RegisterMethod(@TStatusBar.UpdatingStatusBar, 'UpdatingStatusBar');
    RegisterPropertyHelper(@TStatusBarCanvas_R,nil,'Canvas');
    RegisterPropertyHelper(@TStatusBarAutoHint_R,@TStatusBarAutoHint_W,'AutoHint');
    RegisterPropertyHelper(@TStatusBarPanels_R,@TStatusBarPanels_W,'Panels');
    RegisterPropertyHelper(@TStatusBarSimpleText_R,@TStatusBarSimpleText_W,'SimpleText');
    RegisterPropertyHelper(@TStatusBarSimplePanel_R,@TStatusBarSimplePanel_W,'SimplePanel');
    RegisterPropertyHelper(@TStatusBarSizeGrip_R,@TStatusBarSizeGrip_W,'SizeGrip');
    RegisterPropertyHelper(@TStatusBarOnCreatePanelClass_R,@TStatusBarOnCreatePanelClass_W,'OnCreatePanelClass');
    RegisterPropertyHelper(@TStatusBarOnDrawPanel_R,@TStatusBarOnDrawPanel_W,'OnDrawPanel');
    RegisterPropertyHelper(@TStatusBarOnHint_R,@TStatusBarOnHint_W,'OnHint');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TStatusPanels(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TStatusPanels) do
  begin
    RegisterConstructor(@TStatusPanels.Create, 'Create');
    RegisterMethod(@TStatusPanels.Add, 'Add');
    RegisterPropertyHelper(@TStatusPanelsItems_R,@TStatusPanelsItems_W,'Items');
    RegisterPropertyHelper(@TStatusPanelsStatusBar_R,nil,'StatusBar');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TStatusPanel(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TStatusPanel) do
  begin
    RegisterMethod(@TStatusPanel.StatusBar, 'StatusBar');
    RegisterPropertyHelper(@TStatusPanelAlignment_R,@TStatusPanelAlignment_W,'Alignment');
    RegisterPropertyHelper(@TStatusPanelBevel_R,@TStatusPanelBevel_W,'Bevel');
    RegisterPropertyHelper(@TStatusPanelStyle_R,@TStatusPanelStyle_W,'Style');
    RegisterPropertyHelper(@TStatusPanelText_R,@TStatusPanelText_W,'Text');
    RegisterPropertyHelper(@TStatusPanelWidth_R,@TStatusPanelWidth_W,'Width');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_ComCtrls(CL: TPSRuntimeClassImporter);
begin
  RIRegister_TStatusPanel(CL);
  RIRegister_TStatusPanels(CL);
  RIRegister_TStatusBar(CL);
  RIRegister_TCustomPage(CL);
  RIRegister_TNBPages(CL);
  RIRegister_TCustomTabControl(CL);
  RIRegister_TTabSheet(CL);
  RIRegister_TPageControl(CL);
  RIRegister_TTabControlStrings(CL);
  RIRegister_TTabControlNoteBookStrings(CL);
  RIRegister_TTabControl(CL);
  RIRegister_TIconOptions(CL);
  RIRegister_TListItem(CL);
  RIRegister_TOwnerDataListItem(CL);
  RIRegister_TListItemsEnumerator(CL);
  RIRegister_TListItems(CL);
  RIRegister_TOwnerDataListItems(CL);
  RIRegister_TListColumn(CL);
  RIRegister_TListColumns(CL);
  RIRegister_TCustomListViewEditor(CL);
  RIRegister_TCustomListView(CL);
  RIRegister_TListView(CL);
  RIRegister_TCustomProgressBar(CL);
  RIRegister_TProgressBar(CL);
  RIRegister_TCustomUpDown(CL);
  RIRegister_TUpDown(CL);
  RIRegister_TToolButtonActionLink(CL);
  RIRegister_TToolButton(CL);
  RIRegister_TToolBarEnumerator(CL);
  RIRegister_TToolBar(CL);
  RIRegister_TCoolBand(CL);
  RIRegister_TCoolBands(CL);
  RIRegister_TCustomCoolBar(CL);
  RIRegister_TCoolBar(CL);
  RIRegister_TCustomTrackBar(CL);
  RIRegister_TTrackBar(CL);
  with CL.Add(ETreeNodeError) do
  with CL.Add(ETreeViewError) do
  RIRegister_TTreeNode(CL);
  RIRegister_TTreeNodesEnumerator(CL);
  RIRegister_TTreeNodes(CL);
  RIRegister_TCustomTreeView(CL);
  RIRegister_TTreeView(CL);
  RIRegister_TTreeNodeExpandedState(CL);
  RIRegister_THeaderSection(CL);
  RIRegister_THeaderSections(CL);
  RIRegister_TCustomHeaderControl(CL);
  RIRegister_THeaderControl(CL);
end;

 
 
{ TPSImport_ComCtrls }
(*----------------------------------------------------------------------------*)
procedure TPSImport_ComCtrls.CompileImport1(CompExec: TPSScript);
begin
  SIRegister_ComCtrls(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_ComCtrls.ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  RIRegister_ComCtrls(ri);
  RIRegister_ComCtrls_Routines(CompExec.Exec); // comment it if no routines
end;
(*----------------------------------------------------------------------------*)
 
 
end.
