unit uPSI_ExtCtrls;
{
This file has been generated by UnitParser v0.7, written by M. Knight
and updated by NP. v/d Spek and George Birbilis. 
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ROPS are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok's conv utility

}
interface
 

 
uses
   SysUtils
  ,Classes
  ,uPSComponent
  ,uPSRuntime
  ,uPSCompiler
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TPSImport_ExtCtrls = class(TPSPlugin)
  public
    procedure CompileImport1(CompExec: TPSScript); override;
    procedure ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
  end;
 
 
{ compile-time registration functions }
procedure SIRegister_TControlBar(CL: TPSPascalCompiler);
procedure SIRegister_TCustomControlBar(CL: TPSPascalCompiler);
procedure SIRegister_TTrayIcon(CL: TPSPascalCompiler);
procedure SIRegister_TCustomTrayIcon(CL: TPSPascalCompiler);
procedure SIRegister_TPanel(CL: TPSPascalCompiler);
procedure SIRegister_TCustomPanel(CL: TPSPascalCompiler);
procedure SIRegister_TLabeledEdit(CL: TPSPascalCompiler);
procedure SIRegister_TCustomLabeledEdit(CL: TPSPascalCompiler);
procedure SIRegister_TBoundLabel(CL: TPSPascalCompiler);
procedure SIRegister_TCheckGroup(CL: TPSPascalCompiler);
procedure SIRegister_TCustomCheckGroup(CL: TPSPascalCompiler);
procedure SIRegister_TRadioGroup(CL: TPSPascalCompiler);
procedure SIRegister_TCustomRadioGroup(CL: TPSPascalCompiler);
procedure SIRegister_TBevel(CL: TPSPascalCompiler);
procedure SIRegister_TImage(CL: TPSPascalCompiler);
procedure SIRegister_TCustomImage(CL: TPSPascalCompiler);
procedure SIRegister_TPaintBox(CL: TPSPascalCompiler);
procedure SIRegister_TSplitter(CL: TPSPascalCompiler);
procedure SIRegister_TCustomSplitter(CL: TPSPascalCompiler);
procedure SIRegister_TShape(CL: TPSPascalCompiler);
procedure SIRegister_TIdleTimer(CL: TPSPascalCompiler);
procedure SIRegister_TCustomIdleTimer(CL: TPSPascalCompiler);
procedure SIRegister_TTimer(CL: TPSPascalCompiler);
procedure SIRegister_TNotebook(CL: TPSPascalCompiler);
procedure SIRegister_TUNBPages(CL: TPSPascalCompiler);
procedure SIRegister_TPage(CL: TPSPascalCompiler);
procedure SIRegister_ExtCtrls(CL: TPSPascalCompiler);

{ run-time registration functions }
procedure RIRegister_ExtCtrls_Routines(S: TPSExec);
procedure RIRegister_TControlBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomControlBar(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTrayIcon(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomTrayIcon(CL: TPSRuntimeClassImporter);
procedure RIRegister_TPanel(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomPanel(CL: TPSRuntimeClassImporter);
procedure RIRegister_TLabeledEdit(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomLabeledEdit(CL: TPSRuntimeClassImporter);
procedure RIRegister_TBoundLabel(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCheckGroup(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomCheckGroup(CL: TPSRuntimeClassImporter);
procedure RIRegister_TRadioGroup(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomRadioGroup(CL: TPSRuntimeClassImporter);
procedure RIRegister_TBevel(CL: TPSRuntimeClassImporter);
procedure RIRegister_TImage(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomImage(CL: TPSRuntimeClassImporter);
procedure RIRegister_TPaintBox(CL: TPSRuntimeClassImporter);
procedure RIRegister_TSplitter(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomSplitter(CL: TPSRuntimeClassImporter);
procedure RIRegister_TShape(CL: TPSRuntimeClassImporter);
procedure RIRegister_TIdleTimer(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomIdleTimer(CL: TPSRuntimeClassImporter);
procedure RIRegister_TTimer(CL: TPSRuntimeClassImporter);
procedure RIRegister_TNotebook(CL: TPSRuntimeClassImporter);
procedure RIRegister_TUNBPages(CL: TPSRuntimeClassImporter);
procedure RIRegister_TPage(CL: TPSRuntimeClassImporter);
procedure RIRegister_ExtCtrls(CL: TPSRuntimeClassImporter);

procedure Register;

implementation


uses
   Types
  ,LCLStrConsts
  ,LCLType
  ,LCLProc
  ,LResources
  ,Controls
  ,Forms
  ,StdCtrls
  ,lMessages
  ,GraphType
  ,Graphics
  ,LCLIntf
  ,CustomTimer
  ,Themes
  ,LCLClasses
  ,Menus
  ,PopupNotifier
  ,ImgList
  ,contnrs
  ,ExtCtrls
  ;
 
 
procedure Register;
begin
  RegisterComponents('Pascal Script', [TPSImport_ExtCtrls]);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TControlBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControlBar', 'TControlBar') do
  with CL.AddClassN(CL.FindClass('TCustomControlBar'),'TControlBar') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomControlBar(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomPanel', 'TCustomControlBar') do
  with CL.AddClassN(CL.FindClass('TCustomPanel'),'TCustomControlBar') do
  begin
    RegisterMethod('Procedure StickControls');
    RegisterProperty('Picture', 'TPicture', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTrayIcon(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTrayIcon', 'TTrayIcon') do
  with CL.AddClassN(CL.FindClass('TCustomTrayIcon'),'TTrayIcon') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomTrayIcon(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TLCLComponent', 'TCustomTrayIcon') do
  with CL.AddClassN(CL.FindClass('TLCLComponent'),'TCustomTrayIcon') do
  begin
    RegisterProperty('Handle', 'HWND', iptrw);
    RegisterMethod('Function Hide : Boolean');
    RegisterMethod('Function Show : Boolean');
    RegisterMethod('Procedure InternalUpdate');
    RegisterMethod('Procedure ShowBalloonHint');
    RegisterMethod('Function GetPosition : TPoint');
    RegisterProperty('Animate', 'Boolean', iptrw);
    RegisterProperty('AnimateInterval', 'Cardinal', iptrw);
    RegisterProperty('BalloonFlags', 'TBalloonFlags', iptrw);
    RegisterProperty('BalloonHint', 'string', iptrw);
    RegisterProperty('BalloonTimeout', 'Integer', iptrw);
    RegisterProperty('BalloonTitle', 'string', iptrw);
    RegisterProperty('Canvas', 'TCanvas', iptr);
    RegisterProperty('PopUpMenu', 'TPopupMenu', iptrw);
    RegisterProperty('Icon', 'TIcon', iptrw);
    RegisterProperty('Icons', 'TCustomImageList', iptrw);
    RegisterProperty('Hint', 'string', iptrw);
    RegisterProperty('ShowIcon', 'Boolean', iptrw);
    RegisterProperty('Visible', 'Boolean', iptrw);
    RegisterProperty('OnClick', 'TNotifyEvent', iptrw);
    RegisterProperty('OnDblClick', 'TNotifyEvent', iptrw);
    RegisterProperty('OnMouseDown', 'TMouseEvent', iptrw);
    RegisterProperty('OnMouseUp', 'TMouseEvent', iptrw);
    RegisterProperty('OnMouseMove', 'TMouseMoveEvent', iptrw);
    RegisterProperty('OnPaint', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TPanel(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomPanel', 'TPanel') do
  with CL.AddClassN(CL.FindClass('TCustomPanel'),'TPanel') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomPanel(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TCustomPanel') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TCustomPanel') do
  begin
    RegisterProperty('Alignment', 'TAlignment', iptrw);
    RegisterProperty('BevelInner', 'TPanelBevel', iptrw);
    RegisterProperty('BevelOuter', 'TPanelBevel', iptrw);
    RegisterProperty('BevelWidth', 'TBevelWidth', iptrw);
    RegisterProperty('FullRepaint', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TLabeledEdit(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomLabeledEdit', 'TLabeledEdit') do
  with CL.AddClassN(CL.FindClass('TCustomLabeledEdit'),'TLabeledEdit') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomLabeledEdit(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomEdit', 'TCustomLabeledEdit') do
  with CL.AddClassN(CL.FindClass('TCustomEdit'),'TCustomLabeledEdit') do
  begin
    RegisterProperty('EditLabel', 'TBoundLabel', iptr);
    RegisterProperty('LabelPosition', 'TLabelPosition', iptrw);
    RegisterProperty('LabelSpacing', 'Integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TBoundLabel(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomLabel', 'TBoundLabel') do
  with CL.AddClassN(CL.FindClass('TCustomLabel'),'TBoundLabel') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCheckGroup(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomCheckGroup', 'TCheckGroup') do
  with CL.AddClassN(CL.FindClass('TCustomCheckGroup'),'TCheckGroup') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomCheckGroup(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomGroupBox', 'TCustomCheckGroup') do
  with CL.AddClassN(CL.FindClass('TCustomGroupBox'),'TCustomCheckGroup') do
  begin
    RegisterMethod('Function Rows : integer');
    RegisterProperty('AutoFill', 'boolean', iptrw);
    RegisterProperty('Items', 'TStrings', iptrw);
    RegisterProperty('Checked', 'boolean integer', iptrw);
    RegisterProperty('CheckEnabled', 'boolean integer', iptrw);
    RegisterProperty('Columns', 'integer', iptrw);
    RegisterProperty('ColumnLayout', 'TColumnLayout', iptrw);
    RegisterProperty('OnItemClick', 'TCheckGroupClicked', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TRadioGroup(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomRadioGroup', 'TRadioGroup') do
  with CL.AddClassN(CL.FindClass('TCustomRadioGroup'),'TRadioGroup') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomRadioGroup(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomGroupBox', 'TCustomRadioGroup') do
  with CL.AddClassN(CL.FindClass('TCustomGroupBox'),'TCustomRadioGroup') do
  begin
    RegisterMethod('Function CanModify : boolean');
    RegisterMethod('Function Rows : integer');
    RegisterProperty('AutoFill', 'Boolean', iptrw);
    RegisterProperty('ItemIndex', 'integer', iptrw);
    RegisterProperty('Items', 'TStrings', iptrw);
    RegisterProperty('Columns', 'integer', iptrw);
    RegisterProperty('ColumnLayout', 'TColumnLayout', iptrw);
    RegisterProperty('OnClick', 'TNotifyEvent', iptrw);
    RegisterProperty('OnSelectionChanged', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TBevel(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TGraphicControl', 'TBevel') do
  with CL.AddClassN(CL.FindClass('TGraphicControl'),'TBevel') do
  begin
    RegisterProperty('Shape', 'TBevelShape', iptrw);
    RegisterProperty('Style', 'TBevelStyle', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TImage(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomImage', 'TImage') do
  with CL.AddClassN(CL.FindClass('TCustomImage'),'TImage') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomImage(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TGraphicControl', 'TCustomImage') do
  with CL.AddClassN(CL.FindClass('TGraphicControl'),'TCustomImage') do
  begin
    RegisterProperty('Canvas', 'TCanvas', iptr);
    RegisterMethod('Function DestRect : TRect');
    RegisterProperty('AntialiasingMode', 'TAntialiasingMode', iptrw);
    RegisterProperty('Center', 'Boolean', iptrw);
    RegisterProperty('Picture', 'TPicture', iptrw);
    RegisterProperty('Stretch', 'Boolean', iptrw);
    RegisterProperty('Transparent', 'Boolean', iptrw);
    RegisterProperty('Proportional', 'Boolean', iptrw);
    RegisterProperty('OnPictureChanged', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TPaintBox(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TGraphicControl', 'TPaintBox') do
  with CL.AddClassN(CL.FindClass('TGraphicControl'),'TPaintBox') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TSplitter(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomSplitter', 'TSplitter') do
  with CL.AddClassN(CL.FindClass('TCustomSplitter'),'TSplitter') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomSplitter(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TCustomSplitter') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TCustomSplitter') do
  begin
    RegisterMethod('Procedure AnchorSplitter( Kind : TAnchorKind; AControl : TControl)');
    RegisterProperty('ResizeControl', 'TControl', iptrw);
    RegisterMethod('Function GetOtherResizeControl : TControl');
    RegisterMethod('Procedure MoveSplitter( Offset : integer)');
    RegisterMethod('Procedure SetSplitterPosition( NewPosition : integer)');
    RegisterMethod('Function GetSplitterPosition : integer');
    RegisterProperty('AutoSnap', 'boolean', iptrw);
    RegisterProperty('Beveled', 'boolean', iptrw);
    RegisterProperty('MinSize', 'integer', iptrw);
    RegisterProperty('OnCanOffset', 'TCanOffsetEvent', iptrw);
    RegisterProperty('OnCanResize', 'TCanResizeEvent', iptrw);
    RegisterProperty('OnMoved', 'TNotifyEvent', iptrw);
    RegisterProperty('ResizeAnchor', 'TAnchorKind', iptrw);
    RegisterProperty('ResizeStyle', 'TResizeStyle', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TShape(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TGraphicControl', 'TShape') do
  with CL.AddClassN(CL.FindClass('TGraphicControl'),'TShape') do
  begin
    RegisterMethod('Procedure StyleChanged( Sender : TObject)');
    RegisterProperty('Brush', 'TBrush', iptrw);
    RegisterProperty('Pen', 'TPen', iptrw);
    RegisterProperty('Shape', 'TShapeType', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIdleTimer(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomIdleTimer', 'TIdleTimer') do
  with CL.AddClassN(CL.FindClass('TCustomIdleTimer'),'TIdleTimer') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomIdleTimer(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTimer', 'TCustomIdleTimer') do
  with CL.AddClassN(CL.FindClass('TCustomTimer'),'TCustomIdleTimer') do
  begin
    RegisterProperty('AutoEnabled', 'boolean', iptrw);
    RegisterProperty('AutoStartEvent', 'TIdleTimerAutoEvent', iptrw);
    RegisterProperty('AutoEndEvent', 'TIdleTimerAutoEvent', iptrw);
    RegisterProperty('FireOnIdle', 'boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TTimer(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomTimer', 'TTimer') do
  with CL.AddClassN(CL.FindClass('TCustomTimer'),'TTimer') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TNotebook(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TNotebook') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TNotebook') do
  begin
    RegisterProperty('ActivePage', 'String', iptr);
    RegisterProperty('ActivePageComponent', 'TPage', iptr);
    RegisterProperty('Page', 'TPage Integer', iptr);
    RegisterProperty('PageCount', 'integer', iptr);
    RegisterProperty('PageIndex', 'Integer', iptrw);
    RegisterProperty('Pages', 'TStrings', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TUNBPages(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TStrings', 'TUNBPages') do
  with CL.AddClassN(CL.FindClass('TStrings'),'TUNBPages') do
  begin
    RegisterMethod('Constructor Create( thePageList : TListWithEvent; theNotebook : TNotebook)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TPage(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomControl', 'TPage') do
  with CL.AddClassN(CL.FindClass('TCustomControl'),'TPage') do
  begin
    RegisterProperty('OnBeforeShow', 'TBeforeShowPageEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_ExtCtrls(CL: TPSPascalCompiler);
begin
  CL.AddTypeS('TBeforeShowPageEvent', 'Procedure ( ASender : TObject; ANewPage '
   +': TPage; ANewIndex : Integer)');
  SIRegister_TPage(CL);
  SIRegister_TUNBPages(CL);
  SIRegister_TNotebook(CL);
  SIRegister_TTimer(CL);
  CL.AddTypeS('TIdleTimerAutoEvent', '( itaOnIdle, itaOnIdleEnd, itaOnUserInput'
   +' )');
  CL.AddTypeS('TIdleTimerAutoEvents', 'set of TIdleTimerAutoEvent');
  SIRegister_TCustomIdleTimer(CL);
  SIRegister_TIdleTimer(CL);
  CL.AddTypeS('TShapeType', '( stRectangle, stSquare, stRoundRect, stRoundSquar'
   +'e, stEllipse, stCircle, stSquaredDiamond, stDiamond, stTriangle )');
  SIRegister_TShape(CL);
  CL.AddTypeS('TResizeStyle', '( rsLine, rsNone, rsPattern, rsUpdate )');
  CL.AddTypeS('TCanOffsetEvent', 'Procedure ( Sender : TObject; var NewOffset :'
   +' Integer; var Accept : Boolean)');
  CL.AddTypeS('TCanResizeEvent', 'Procedure ( Sender : TObject; var NewSize : I'
   +'nteger; var Accept : Boolean)');
  SIRegister_TCustomSplitter(CL);
  SIRegister_TSplitter(CL);
  SIRegister_TPaintBox(CL);
  SIRegister_TCustomImage(CL);
  SIRegister_TImage(CL);
  CL.AddTypeS('TBevelStyle', '( bsLowered, bsRaised )');
  CL.AddTypeS('TBevelShape', '( bsBox, bsFrame, bsTopLine, bsBottomLine, bsLeft'
   +'Line, bsRightLine, bsSpacer )');
  SIRegister_TBevel(CL);
  CL.AddTypeS('TColumnLayout', '( clHorizontalThenVertical, clVerticalThenHoriz'
   +'ontal )');
  SIRegister_TCustomRadioGroup(CL);
  SIRegister_TRadioGroup(CL);
  CL.AddTypeS('TCheckGroupClicked', 'Procedure ( Sender : TObject; Index : inte'
   +'ger)');
  SIRegister_TCustomCheckGroup(CL);
  SIRegister_TCheckGroup(CL);
  SIRegister_TBoundLabel(CL);
  CL.AddTypeS('TLabelPosition', '( lpAbove, lpBelow, lpLeft, lpRight )');
  SIRegister_TCustomLabeledEdit(CL);
  SIRegister_TLabeledEdit(CL);
  CL.AddTypeS('TPanelBevel', 'TBevelCut');
  CL.AddTypeS('TBevelWidth', 'Integer');
  SIRegister_TCustomPanel(CL);
  SIRegister_TPanel(CL);
  CL.AddTypeS('TBalloonFlags', '( bfNone, bfInfo, bfWarning, bfError )');
  SIRegister_TCustomTrayIcon(CL);
  SIRegister_TTrayIcon(CL);
  CL.AddTypeS('TBandPaintOption', '( bpoGrabber, bpoFrame )');
  CL.AddTypeS('TBandPaintOptions', 'set of TBandPaintOption');
  CL.AddTypeS('TBandDragEvent', 'Procedure ( Sender : TObject; Control : TContr'
   +'ol; var Drag : Boolean)');
  CL.AddTypeS('TBandInfoEvent', 'Procedure ( Sender : TObject; Control : TContr'
   +'ol; var Insets : TRect; var PreferredSize, RowCount : Integer)');
  CL.AddTypeS('TBandMoveEvent', 'Procedure ( Sender : TObject; Control : TContr'
   +'ol; var ARect : TRect)');
  CL.AddTypeS('TBandPaintEvent', 'Procedure ( Sender : TObject; Control : TCont'
   +'rol; Canvas : TCanvas; var ARect : TRect; var Options : TBandPaintOptions)');
  CL.AddTypeS('TRowSize', 'Integer');
  SIRegister_TCustomControlBar(CL);
  SIRegister_TControlBar(CL);
 CL.AddDelphiFunction('Procedure Frame3D( ACanvas : TCanvas; var ARect : TRect; TopColor, BottomColor : TColor; const FrameWidth : integer)');
 CL.AddDelphiFunction('Procedure Register');
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TCustomControlBarPicture_W(Self: TCustomControlBar; const T: TPicture);
begin Self.Picture := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomControlBarPicture_R(Self: TCustomControlBar; var T: TPicture);
begin T := Self.Picture; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnPaint_W(Self: TCustomTrayIcon; const T: TNotifyEvent);
begin Self.OnPaint := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnPaint_R(Self: TCustomTrayIcon; var T: TNotifyEvent);
begin T := Self.OnPaint; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseMove_W(Self: TCustomTrayIcon; const T: TMouseMoveEvent);
begin Self.OnMouseMove := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseMove_R(Self: TCustomTrayIcon; var T: TMouseMoveEvent);
begin T := Self.OnMouseMove; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseUp_W(Self: TCustomTrayIcon; const T: TMouseEvent);
begin Self.OnMouseUp := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseUp_R(Self: TCustomTrayIcon; var T: TMouseEvent);
begin T := Self.OnMouseUp; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseDown_W(Self: TCustomTrayIcon; const T: TMouseEvent);
begin Self.OnMouseDown := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnMouseDown_R(Self: TCustomTrayIcon; var T: TMouseEvent);
begin T := Self.OnMouseDown; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnDblClick_W(Self: TCustomTrayIcon; const T: TNotifyEvent);
begin Self.OnDblClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnDblClick_R(Self: TCustomTrayIcon; var T: TNotifyEvent);
begin T := Self.OnDblClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnClick_W(Self: TCustomTrayIcon; const T: TNotifyEvent);
begin Self.OnClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconOnClick_R(Self: TCustomTrayIcon; var T: TNotifyEvent);
begin T := Self.OnClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconVisible_W(Self: TCustomTrayIcon; const T: Boolean);
begin Self.Visible := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconVisible_R(Self: TCustomTrayIcon; var T: Boolean);
begin T := Self.Visible; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconShowIcon_W(Self: TCustomTrayIcon; const T: Boolean);
begin Self.ShowIcon := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconShowIcon_R(Self: TCustomTrayIcon; var T: Boolean);
begin T := Self.ShowIcon; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconHint_W(Self: TCustomTrayIcon; const T: string);
begin Self.Hint := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconHint_R(Self: TCustomTrayIcon; var T: string);
begin T := Self.Hint; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconIcons_W(Self: TCustomTrayIcon; const T: TCustomImageList);
begin Self.Icons := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconIcons_R(Self: TCustomTrayIcon; var T: TCustomImageList);
begin T := Self.Icons; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconIcon_W(Self: TCustomTrayIcon; const T: TIcon);
begin Self.Icon := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconIcon_R(Self: TCustomTrayIcon; var T: TIcon);
begin T := Self.Icon; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconPopUpMenu_W(Self: TCustomTrayIcon; const T: TPopupMenu);
begin Self.PopUpMenu := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconPopUpMenu_R(Self: TCustomTrayIcon; var T: TPopupMenu);
begin T := Self.PopUpMenu; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconCanvas_R(Self: TCustomTrayIcon; var T: TCanvas);
begin T := Self.Canvas; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonTitle_W(Self: TCustomTrayIcon; const T: string);
begin Self.BalloonTitle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonTitle_R(Self: TCustomTrayIcon; var T: string);
begin T := Self.BalloonTitle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonTimeout_W(Self: TCustomTrayIcon; const T: Integer);
begin Self.BalloonTimeout := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonTimeout_R(Self: TCustomTrayIcon; var T: Integer);
begin T := Self.BalloonTimeout; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonHint_W(Self: TCustomTrayIcon; const T: string);
begin Self.BalloonHint := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonHint_R(Self: TCustomTrayIcon; var T: string);
begin T := Self.BalloonHint; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonFlags_W(Self: TCustomTrayIcon; const T: TBalloonFlags);
begin Self.BalloonFlags := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconBalloonFlags_R(Self: TCustomTrayIcon; var T: TBalloonFlags);
begin T := Self.BalloonFlags; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconAnimateInterval_W(Self: TCustomTrayIcon; const T: Cardinal);
begin Self.AnimateInterval := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconAnimateInterval_R(Self: TCustomTrayIcon; var T: Cardinal);
begin T := Self.AnimateInterval; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconAnimate_W(Self: TCustomTrayIcon; const T: Boolean);
begin Self.Animate := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconAnimate_R(Self: TCustomTrayIcon; var T: Boolean);
begin T := Self.Animate; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconHandle_W(Self: TCustomTrayIcon; const T: HWND);
Begin Self.Handle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomTrayIconHandle_R(Self: TCustomTrayIcon; var T: HWND);
Begin T := Self.Handle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelFullRepaint_W(Self: TCustomPanel; const T: Boolean);
begin Self.FullRepaint := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelFullRepaint_R(Self: TCustomPanel; var T: Boolean);
begin T := Self.FullRepaint; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelWidth_W(Self: TCustomPanel; const T: TBevelWidth);
begin Self.BevelWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelWidth_R(Self: TCustomPanel; var T: TBevelWidth);
begin T := Self.BevelWidth; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelOuter_W(Self: TCustomPanel; const T: TPanelBevel);
begin Self.BevelOuter := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelOuter_R(Self: TCustomPanel; var T: TPanelBevel);
begin T := Self.BevelOuter; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelInner_W(Self: TCustomPanel; const T: TPanelBevel);
begin Self.BevelInner := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelBevelInner_R(Self: TCustomPanel; var T: TPanelBevel);
begin T := Self.BevelInner; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelAlignment_W(Self: TCustomPanel; const T: TAlignment);
begin Self.Alignment := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPanelAlignment_R(Self: TCustomPanel; var T: TAlignment);
begin T := Self.Alignment; end;

(*----------------------------------------------------------------------------*)
procedure TCustomLabeledEditLabelSpacing_W(Self: TCustomLabeledEdit; const T: Integer);
begin Self.LabelSpacing := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomLabeledEditLabelSpacing_R(Self: TCustomLabeledEdit; var T: Integer);
begin T := Self.LabelSpacing; end;

(*----------------------------------------------------------------------------*)
procedure TCustomLabeledEditLabelPosition_W(Self: TCustomLabeledEdit; const T: TLabelPosition);
begin Self.LabelPosition := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomLabeledEditLabelPosition_R(Self: TCustomLabeledEdit; var T: TLabelPosition);
begin T := Self.LabelPosition; end;

(*----------------------------------------------------------------------------*)
procedure TCustomLabeledEditEditLabel_R(Self: TCustomLabeledEdit; var T: TBoundLabel);
begin T := Self.EditLabel; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupOnItemClick_W(Self: TCustomCheckGroup; const T: TCheckGroupClicked);
begin Self.OnItemClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupOnItemClick_R(Self: TCustomCheckGroup; var T: TCheckGroupClicked);
begin T := Self.OnItemClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupColumnLayout_W(Self: TCustomCheckGroup; const T: TColumnLayout);
begin Self.ColumnLayout := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupColumnLayout_R(Self: TCustomCheckGroup; var T: TColumnLayout);
begin T := Self.ColumnLayout; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupColumns_W(Self: TCustomCheckGroup; const T: integer);
begin Self.Columns := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupColumns_R(Self: TCustomCheckGroup; var T: integer);
begin T := Self.Columns; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupCheckEnabled_W(Self: TCustomCheckGroup; const T: boolean; const t1: integer);
begin Self.CheckEnabled[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupCheckEnabled_R(Self: TCustomCheckGroup; var T: boolean; const t1: integer);
begin T := Self.CheckEnabled[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupChecked_W(Self: TCustomCheckGroup; const T: boolean; const t1: integer);
begin Self.Checked[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupChecked_R(Self: TCustomCheckGroup; var T: boolean; const t1: integer);
begin T := Self.Checked[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupItems_W(Self: TCustomCheckGroup; const T: TStrings);
begin Self.Items := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupItems_R(Self: TCustomCheckGroup; var T: TStrings);
begin T := Self.Items; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupAutoFill_W(Self: TCustomCheckGroup; const T: boolean);
begin Self.AutoFill := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomCheckGroupAutoFill_R(Self: TCustomCheckGroup; var T: boolean);
begin T := Self.AutoFill; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupOnSelectionChanged_W(Self: TCustomRadioGroup; const T: TNotifyEvent);
begin Self.OnSelectionChanged := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupOnSelectionChanged_R(Self: TCustomRadioGroup; var T: TNotifyEvent);
begin T := Self.OnSelectionChanged; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupOnClick_W(Self: TCustomRadioGroup; const T: TNotifyEvent);
begin Self.OnClick := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupOnClick_R(Self: TCustomRadioGroup; var T: TNotifyEvent);
begin T := Self.OnClick; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupColumnLayout_W(Self: TCustomRadioGroup; const T: TColumnLayout);
begin Self.ColumnLayout := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupColumnLayout_R(Self: TCustomRadioGroup; var T: TColumnLayout);
begin T := Self.ColumnLayout; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupColumns_W(Self: TCustomRadioGroup; const T: integer);
begin Self.Columns := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupColumns_R(Self: TCustomRadioGroup; var T: integer);
begin T := Self.Columns; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupItems_W(Self: TCustomRadioGroup; const T: TStrings);
begin Self.Items := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupItems_R(Self: TCustomRadioGroup; var T: TStrings);
begin T := Self.Items; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupItemIndex_W(Self: TCustomRadioGroup; const T: integer);
begin Self.ItemIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupItemIndex_R(Self: TCustomRadioGroup; var T: integer);
begin T := Self.ItemIndex; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupAutoFill_W(Self: TCustomRadioGroup; const T: Boolean);
begin Self.AutoFill := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomRadioGroupAutoFill_R(Self: TCustomRadioGroup; var T: Boolean);
begin T := Self.AutoFill; end;

(*----------------------------------------------------------------------------*)
procedure TBevelStyle_W(Self: TBevel; const T: TBevelStyle);
begin Self.Style := T; end;

(*----------------------------------------------------------------------------*)
procedure TBevelStyle_R(Self: TBevel; var T: TBevelStyle);
begin T := Self.Style; end;

(*----------------------------------------------------------------------------*)
procedure TBevelShape_W(Self: TBevel; const T: TBevelShape);
begin Self.Shape := T; end;

(*----------------------------------------------------------------------------*)
procedure TBevelShape_R(Self: TBevel; var T: TBevelShape);
begin T := Self.Shape; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageOnPictureChanged_W(Self: TCustomImage; const T: TNotifyEvent);
begin Self.OnPictureChanged := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageOnPictureChanged_R(Self: TCustomImage; var T: TNotifyEvent);
begin T := Self.OnPictureChanged; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageProportional_W(Self: TCustomImage; const T: Boolean);
begin Self.Proportional := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageProportional_R(Self: TCustomImage; var T: Boolean);
begin T := Self.Proportional; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageTransparent_W(Self: TCustomImage; const T: Boolean);
begin Self.Transparent := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageTransparent_R(Self: TCustomImage; var T: Boolean);
begin T := Self.Transparent; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageStretch_W(Self: TCustomImage; const T: Boolean);
begin Self.Stretch := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageStretch_R(Self: TCustomImage; var T: Boolean);
begin T := Self.Stretch; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImagePicture_W(Self: TCustomImage; const T: TPicture);
begin Self.Picture := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImagePicture_R(Self: TCustomImage; var T: TPicture);
begin T := Self.Picture; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageCenter_W(Self: TCustomImage; const T: Boolean);
begin Self.Center := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageCenter_R(Self: TCustomImage; var T: Boolean);
begin T := Self.Center; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageAntialiasingMode_W(Self: TCustomImage; const T: TAntialiasingMode);
begin Self.AntialiasingMode := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageAntialiasingMode_R(Self: TCustomImage; var T: TAntialiasingMode);
begin T := Self.AntialiasingMode; end;

(*----------------------------------------------------------------------------*)
procedure TCustomImageCanvas_R(Self: TCustomImage; var T: TCanvas);
begin T := Self.Canvas; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeStyle_W(Self: TCustomSplitter; const T: TResizeStyle);
begin Self.ResizeStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeStyle_R(Self: TCustomSplitter; var T: TResizeStyle);
begin T := Self.ResizeStyle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeAnchor_W(Self: TCustomSplitter; const T: TAnchorKind);
begin Self.ResizeAnchor := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeAnchor_R(Self: TCustomSplitter; var T: TAnchorKind);
begin T := Self.ResizeAnchor; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnMoved_W(Self: TCustomSplitter; const T: TNotifyEvent);
begin Self.OnMoved := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnMoved_R(Self: TCustomSplitter; var T: TNotifyEvent);
begin T := Self.OnMoved; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnCanResize_W(Self: TCustomSplitter; const T: TCanResizeEvent);
begin Self.OnCanResize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnCanResize_R(Self: TCustomSplitter; var T: TCanResizeEvent);
begin T := Self.OnCanResize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnCanOffset_W(Self: TCustomSplitter; const T: TCanOffsetEvent);
begin Self.OnCanOffset := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterOnCanOffset_R(Self: TCustomSplitter; var T: TCanOffsetEvent);
begin T := Self.OnCanOffset; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterMinSize_W(Self: TCustomSplitter; const T: integer);
begin Self.MinSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterMinSize_R(Self: TCustomSplitter; var T: integer);
begin T := Self.MinSize; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterBeveled_W(Self: TCustomSplitter; const T: boolean);
begin Self.Beveled := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterBeveled_R(Self: TCustomSplitter; var T: boolean);
begin T := Self.Beveled; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterAutoSnap_W(Self: TCustomSplitter; const T: boolean);
begin Self.AutoSnap := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterAutoSnap_R(Self: TCustomSplitter; var T: boolean);
begin T := Self.AutoSnap; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeControl_W(Self: TCustomSplitter; const T: TControl);
begin Self.ResizeControl := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomSplitterResizeControl_R(Self: TCustomSplitter; var T: TControl);
begin T := Self.ResizeControl; end;

(*----------------------------------------------------------------------------*)
procedure TShapeShape_W(Self: TShape; const T: TShapeType);
begin Self.Shape := T; end;

(*----------------------------------------------------------------------------*)
procedure TShapeShape_R(Self: TShape; var T: TShapeType);
begin T := Self.Shape; end;

(*----------------------------------------------------------------------------*)
procedure TShapePen_W(Self: TShape; const T: TPen);
begin Self.Pen := T; end;

(*----------------------------------------------------------------------------*)
procedure TShapePen_R(Self: TShape; var T: TPen);
begin T := Self.Pen; end;

(*----------------------------------------------------------------------------*)
procedure TShapeBrush_W(Self: TShape; const T: TBrush);
begin Self.Brush := T; end;

(*----------------------------------------------------------------------------*)
procedure TShapeBrush_R(Self: TShape; var T: TBrush);
begin T := Self.Brush; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerFireOnIdle_W(Self: TCustomIdleTimer; const T: boolean);
begin Self.FireOnIdle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerFireOnIdle_R(Self: TCustomIdleTimer; var T: boolean);
begin T := Self.FireOnIdle; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoEndEvent_W(Self: TCustomIdleTimer; const T: TIdleTimerAutoEvent);
begin Self.AutoEndEvent := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoEndEvent_R(Self: TCustomIdleTimer; var T: TIdleTimerAutoEvent);
begin T := Self.AutoEndEvent; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoStartEvent_W(Self: TCustomIdleTimer; const T: TIdleTimerAutoEvent);
begin Self.AutoStartEvent := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoStartEvent_R(Self: TCustomIdleTimer; var T: TIdleTimerAutoEvent);
begin T := Self.AutoStartEvent; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoEnabled_W(Self: TCustomIdleTimer; const T: boolean);
begin Self.AutoEnabled := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomIdleTimerAutoEnabled_R(Self: TCustomIdleTimer; var T: boolean);
begin T := Self.AutoEnabled; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookPages_R(Self: TNotebook; var T: TStrings);
begin T := Self.Pages; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookPageIndex_W(Self: TNotebook; const T: Integer);
begin Self.PageIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookPageIndex_R(Self: TNotebook; var T: Integer);
begin T := Self.PageIndex; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookPageCount_R(Self: TNotebook; var T: integer);
begin T := Self.PageCount; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookPage_R(Self: TNotebook; var T: TPage; const t1: Integer);
begin T := Self.Page[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookActivePageComponent_R(Self: TNotebook; var T: TPage);
begin T := Self.ActivePageComponent; end;

(*----------------------------------------------------------------------------*)
procedure TNotebookActivePage_R(Self: TNotebook; var T: String);
begin T := Self.ActivePage; end;

(*----------------------------------------------------------------------------*)
procedure TPageOnBeforeShow_W(Self: TPage; const T: TBeforeShowPageEvent);
begin Self.OnBeforeShow := T; end;

(*----------------------------------------------------------------------------*)
procedure TPageOnBeforeShow_R(Self: TPage; var T: TBeforeShowPageEvent);
begin T := Self.OnBeforeShow; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_ExtCtrls_Routines(S: TPSExec);
begin
 S.RegisterDelphiFunction(@Frame3D, 'Frame3D', cdRegister);
 S.RegisterDelphiFunction(@Register, 'Register', cdRegister);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TControlBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TControlBar) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomControlBar(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomControlBar) do
  begin
    RegisterVirtualMethod(@TCustomControlBar.StickControls, 'StickControls');
    RegisterPropertyHelper(@TCustomControlBarPicture_R,@TCustomControlBarPicture_W,'Picture');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTrayIcon(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTrayIcon) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomTrayIcon(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomTrayIcon) do
  begin
    RegisterPropertyHelper(@TCustomTrayIconHandle_R,@TCustomTrayIconHandle_W,'Handle');
    RegisterMethod(@TCustomTrayIcon.Hide, 'Hide');
    RegisterMethod(@TCustomTrayIcon.Show, 'Show');
    RegisterMethod(@TCustomTrayIcon.InternalUpdate, 'InternalUpdate');
    RegisterMethod(@TCustomTrayIcon.ShowBalloonHint, 'ShowBalloonHint');
    RegisterMethod(@TCustomTrayIcon.GetPosition, 'GetPosition');
    RegisterPropertyHelper(@TCustomTrayIconAnimate_R,@TCustomTrayIconAnimate_W,'Animate');
    RegisterPropertyHelper(@TCustomTrayIconAnimateInterval_R,@TCustomTrayIconAnimateInterval_W,'AnimateInterval');
    RegisterPropertyHelper(@TCustomTrayIconBalloonFlags_R,@TCustomTrayIconBalloonFlags_W,'BalloonFlags');
    RegisterPropertyHelper(@TCustomTrayIconBalloonHint_R,@TCustomTrayIconBalloonHint_W,'BalloonHint');
    RegisterPropertyHelper(@TCustomTrayIconBalloonTimeout_R,@TCustomTrayIconBalloonTimeout_W,'BalloonTimeout');
    RegisterPropertyHelper(@TCustomTrayIconBalloonTitle_R,@TCustomTrayIconBalloonTitle_W,'BalloonTitle');
    RegisterPropertyHelper(@TCustomTrayIconCanvas_R,nil,'Canvas');
    RegisterPropertyHelper(@TCustomTrayIconPopUpMenu_R,@TCustomTrayIconPopUpMenu_W,'PopUpMenu');
    RegisterPropertyHelper(@TCustomTrayIconIcon_R,@TCustomTrayIconIcon_W,'Icon');
    RegisterPropertyHelper(@TCustomTrayIconIcons_R,@TCustomTrayIconIcons_W,'Icons');
    RegisterPropertyHelper(@TCustomTrayIconHint_R,@TCustomTrayIconHint_W,'Hint');
    RegisterPropertyHelper(@TCustomTrayIconShowIcon_R,@TCustomTrayIconShowIcon_W,'ShowIcon');
    RegisterPropertyHelper(@TCustomTrayIconVisible_R,@TCustomTrayIconVisible_W,'Visible');
    RegisterPropertyHelper(@TCustomTrayIconOnClick_R,@TCustomTrayIconOnClick_W,'OnClick');
    RegisterPropertyHelper(@TCustomTrayIconOnDblClick_R,@TCustomTrayIconOnDblClick_W,'OnDblClick');
    RegisterPropertyHelper(@TCustomTrayIconOnMouseDown_R,@TCustomTrayIconOnMouseDown_W,'OnMouseDown');
    RegisterPropertyHelper(@TCustomTrayIconOnMouseUp_R,@TCustomTrayIconOnMouseUp_W,'OnMouseUp');
    RegisterPropertyHelper(@TCustomTrayIconOnMouseMove_R,@TCustomTrayIconOnMouseMove_W,'OnMouseMove');
    RegisterPropertyHelper(@TCustomTrayIconOnPaint_R,@TCustomTrayIconOnPaint_W,'OnPaint');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TPanel(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TPanel) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomPanel(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomPanel) do
  begin
    RegisterPropertyHelper(@TCustomPanelAlignment_R,@TCustomPanelAlignment_W,'Alignment');
    RegisterPropertyHelper(@TCustomPanelBevelInner_R,@TCustomPanelBevelInner_W,'BevelInner');
    RegisterPropertyHelper(@TCustomPanelBevelOuter_R,@TCustomPanelBevelOuter_W,'BevelOuter');
    RegisterPropertyHelper(@TCustomPanelBevelWidth_R,@TCustomPanelBevelWidth_W,'BevelWidth');
    RegisterPropertyHelper(@TCustomPanelFullRepaint_R,@TCustomPanelFullRepaint_W,'FullRepaint');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TLabeledEdit(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TLabeledEdit) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomLabeledEdit(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomLabeledEdit) do
  begin
    RegisterPropertyHelper(@TCustomLabeledEditEditLabel_R,nil,'EditLabel');
    RegisterPropertyHelper(@TCustomLabeledEditLabelPosition_R,@TCustomLabeledEditLabelPosition_W,'LabelPosition');
    RegisterPropertyHelper(@TCustomLabeledEditLabelSpacing_R,@TCustomLabeledEditLabelSpacing_W,'LabelSpacing');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TBoundLabel(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TBoundLabel) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCheckGroup(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCheckGroup) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomCheckGroup(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomCheckGroup) do
  begin
    RegisterMethod(@TCustomCheckGroup.Rows, 'Rows');
    RegisterPropertyHelper(@TCustomCheckGroupAutoFill_R,@TCustomCheckGroupAutoFill_W,'AutoFill');
    RegisterPropertyHelper(@TCustomCheckGroupItems_R,@TCustomCheckGroupItems_W,'Items');
    RegisterPropertyHelper(@TCustomCheckGroupChecked_R,@TCustomCheckGroupChecked_W,'Checked');
    RegisterPropertyHelper(@TCustomCheckGroupCheckEnabled_R,@TCustomCheckGroupCheckEnabled_W,'CheckEnabled');
    RegisterPropertyHelper(@TCustomCheckGroupColumns_R,@TCustomCheckGroupColumns_W,'Columns');
    RegisterPropertyHelper(@TCustomCheckGroupColumnLayout_R,@TCustomCheckGroupColumnLayout_W,'ColumnLayout');
    RegisterPropertyHelper(@TCustomCheckGroupOnItemClick_R,@TCustomCheckGroupOnItemClick_W,'OnItemClick');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TRadioGroup(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TRadioGroup) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomRadioGroup(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomRadioGroup) do
  begin
    RegisterVirtualMethod(@TCustomRadioGroup.CanModify, 'CanModify');
    RegisterMethod(@TCustomRadioGroup.Rows, 'Rows');
    RegisterPropertyHelper(@TCustomRadioGroupAutoFill_R,@TCustomRadioGroupAutoFill_W,'AutoFill');
    RegisterPropertyHelper(@TCustomRadioGroupItemIndex_R,@TCustomRadioGroupItemIndex_W,'ItemIndex');
    RegisterPropertyHelper(@TCustomRadioGroupItems_R,@TCustomRadioGroupItems_W,'Items');
    RegisterPropertyHelper(@TCustomRadioGroupColumns_R,@TCustomRadioGroupColumns_W,'Columns');
    RegisterPropertyHelper(@TCustomRadioGroupColumnLayout_R,@TCustomRadioGroupColumnLayout_W,'ColumnLayout');
    RegisterPropertyHelper(@TCustomRadioGroupOnClick_R,@TCustomRadioGroupOnClick_W,'OnClick');
    RegisterPropertyHelper(@TCustomRadioGroupOnSelectionChanged_R,@TCustomRadioGroupOnSelectionChanged_W,'OnSelectionChanged');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TBevel(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TBevel) do
  begin
    RegisterPropertyHelper(@TBevelShape_R,@TBevelShape_W,'Shape');
    RegisterPropertyHelper(@TBevelStyle_R,@TBevelStyle_W,'Style');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TImage(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TImage) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomImage(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomImage) do
  begin
    RegisterPropertyHelper(@TCustomImageCanvas_R,nil,'Canvas');
    RegisterVirtualMethod(@TCustomImage.DestRect, 'DestRect');
    RegisterPropertyHelper(@TCustomImageAntialiasingMode_R,@TCustomImageAntialiasingMode_W,'AntialiasingMode');
    RegisterPropertyHelper(@TCustomImageCenter_R,@TCustomImageCenter_W,'Center');
    RegisterPropertyHelper(@TCustomImagePicture_R,@TCustomImagePicture_W,'Picture');
    RegisterPropertyHelper(@TCustomImageStretch_R,@TCustomImageStretch_W,'Stretch');
    RegisterPropertyHelper(@TCustomImageTransparent_R,@TCustomImageTransparent_W,'Transparent');
    RegisterPropertyHelper(@TCustomImageProportional_R,@TCustomImageProportional_W,'Proportional');
    RegisterPropertyHelper(@TCustomImageOnPictureChanged_R,@TCustomImageOnPictureChanged_W,'OnPictureChanged');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TPaintBox(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TPaintBox) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TSplitter(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TSplitter) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomSplitter(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomSplitter) do
  begin
    RegisterMethod(@TCustomSplitter.AnchorSplitter, 'AnchorSplitter');
    RegisterPropertyHelper(@TCustomSplitterResizeControl_R,@TCustomSplitterResizeControl_W,'ResizeControl');
    RegisterMethod(@TCustomSplitter.GetOtherResizeControl, 'GetOtherResizeControl');
    RegisterMethod(@TCustomSplitter.MoveSplitter, 'MoveSplitter');
    RegisterMethod(@TCustomSplitter.SetSplitterPosition, 'SetSplitterPosition');
    RegisterMethod(@TCustomSplitter.GetSplitterPosition, 'GetSplitterPosition');
    RegisterPropertyHelper(@TCustomSplitterAutoSnap_R,@TCustomSplitterAutoSnap_W,'AutoSnap');
    RegisterPropertyHelper(@TCustomSplitterBeveled_R,@TCustomSplitterBeveled_W,'Beveled');
    RegisterPropertyHelper(@TCustomSplitterMinSize_R,@TCustomSplitterMinSize_W,'MinSize');
    RegisterPropertyHelper(@TCustomSplitterOnCanOffset_R,@TCustomSplitterOnCanOffset_W,'OnCanOffset');
    RegisterPropertyHelper(@TCustomSplitterOnCanResize_R,@TCustomSplitterOnCanResize_W,'OnCanResize');
    RegisterPropertyHelper(@TCustomSplitterOnMoved_R,@TCustomSplitterOnMoved_W,'OnMoved');
    RegisterPropertyHelper(@TCustomSplitterResizeAnchor_R,@TCustomSplitterResizeAnchor_W,'ResizeAnchor');
    RegisterPropertyHelper(@TCustomSplitterResizeStyle_R,@TCustomSplitterResizeStyle_W,'ResizeStyle');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TShape(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TShape) do
  begin
    RegisterMethod(@TShape.StyleChanged, 'StyleChanged');
    RegisterPropertyHelper(@TShapeBrush_R,@TShapeBrush_W,'Brush');
    RegisterPropertyHelper(@TShapePen_R,@TShapePen_W,'Pen');
    RegisterPropertyHelper(@TShapeShape_R,@TShapeShape_W,'Shape');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIdleTimer(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIdleTimer) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomIdleTimer(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomIdleTimer) do
  begin
    RegisterPropertyHelper(@TCustomIdleTimerAutoEnabled_R,@TCustomIdleTimerAutoEnabled_W,'AutoEnabled');
    RegisterPropertyHelper(@TCustomIdleTimerAutoStartEvent_R,@TCustomIdleTimerAutoStartEvent_W,'AutoStartEvent');
    RegisterPropertyHelper(@TCustomIdleTimerAutoEndEvent_R,@TCustomIdleTimerAutoEndEvent_W,'AutoEndEvent');
    RegisterPropertyHelper(@TCustomIdleTimerFireOnIdle_R,@TCustomIdleTimerFireOnIdle_W,'FireOnIdle');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TTimer(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TTimer) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TNotebook(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TNotebook) do
  begin
    RegisterPropertyHelper(@TNotebookActivePage_R,nil,'ActivePage');
    RegisterPropertyHelper(@TNotebookActivePageComponent_R,nil,'ActivePageComponent');
    RegisterPropertyHelper(@TNotebookPage_R,nil,'Page');
    RegisterPropertyHelper(@TNotebookPageCount_R,nil,'PageCount');
    RegisterPropertyHelper(@TNotebookPageIndex_R,@TNotebookPageIndex_W,'PageIndex');
    RegisterPropertyHelper(@TNotebookPages_R,nil,'Pages');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TUNBPages(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TUNBPages) do
  begin
    RegisterConstructor(@TUNBPages.Create, 'Create');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TPage(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TPage) do
  begin
    RegisterPropertyHelper(@TPageOnBeforeShow_R,@TPageOnBeforeShow_W,'OnBeforeShow');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_ExtCtrls(CL: TPSRuntimeClassImporter);
begin
  RIRegister_TPage(CL);
  RIRegister_TUNBPages(CL);
  RIRegister_TNotebook(CL);
  RIRegister_TTimer(CL);
  RIRegister_TCustomIdleTimer(CL);
  RIRegister_TIdleTimer(CL);
  RIRegister_TShape(CL);
  RIRegister_TCustomSplitter(CL);
  RIRegister_TSplitter(CL);
  RIRegister_TPaintBox(CL);
  RIRegister_TCustomImage(CL);
  RIRegister_TImage(CL);
  RIRegister_TBevel(CL);
  RIRegister_TCustomRadioGroup(CL);
  RIRegister_TRadioGroup(CL);
  RIRegister_TCustomCheckGroup(CL);
  RIRegister_TCheckGroup(CL);
  RIRegister_TBoundLabel(CL);
  RIRegister_TCustomLabeledEdit(CL);
  RIRegister_TLabeledEdit(CL);
  RIRegister_TCustomPanel(CL);
  RIRegister_TPanel(CL);
  RIRegister_TCustomTrayIcon(CL);
  RIRegister_TTrayIcon(CL);
  RIRegister_TCustomControlBar(CL);
  RIRegister_TControlBar(CL);
end;

 
 
{ TPSImport_ExtCtrls }
(*----------------------------------------------------------------------------*)
procedure TPSImport_ExtCtrls.CompileImport1(CompExec: TPSScript);
begin
  SIRegister_ExtCtrls(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_ExtCtrls.ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  RIRegister_ExtCtrls(ri);
  RIRegister_ExtCtrls_Routines(CompExec.Exec); // comment it if no routines
end;
(*----------------------------------------------------------------------------*)
 
 
end.
