unit uPSI_Dialogs;
{
This file has been generated by UnitParser v0.7, written by M. Knight
and updated by NP. v/d Spek and George Birbilis. 
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ROPS are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok's conv utility

}
interface
 

 
uses
   SysUtils
  ,Classes
  ,uPSComponent
  ,uPSRuntime
  ,uPSCompiler
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TPSImport_Dialogs = class(TPSPlugin)
  public
    procedure CompileImport1(CompExec: TPSScript); override;
    procedure ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
  end;
 
 
{ compile-time registration functions }
procedure SIRegister_TCustomPrintDialog(CL: TPSPascalCompiler);
procedure SIRegister_TCustomPrinterSetupDialog(CL: TPSPascalCompiler);
procedure SIRegister_TReplaceDialog(CL: TPSPascalCompiler);
procedure SIRegister_TFindDialog(CL: TPSPascalCompiler);
procedure SIRegister_TFontDialog(CL: TPSPascalCompiler);
procedure SIRegister_TColorButton(CL: TPSPascalCompiler);
procedure SIRegister_TColorDialog(CL: TPSPascalCompiler);
procedure SIRegister_TSelectDirectoryDialog(CL: TPSPascalCompiler);
procedure SIRegister_TSaveDialog(CL: TPSPascalCompiler);
procedure SIRegister_TOpenDialog(CL: TPSPascalCompiler);
procedure SIRegister_TFileDialog(CL: TPSPascalCompiler);
procedure SIRegister_TCommonDialog(CL: TPSPascalCompiler);
procedure SIRegister_Dialogs(CL: TPSPascalCompiler);

{ run-time registration functions }
procedure RIRegister_Dialogs_Routines(S: TPSExec);
procedure RIRegister_TCustomPrintDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCustomPrinterSetupDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TReplaceDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TFindDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TFontDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TColorButton(CL: TPSRuntimeClassImporter);
procedure RIRegister_TColorDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TSelectDirectoryDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TSaveDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TOpenDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TFileDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_TCommonDialog(CL: TPSRuntimeClassImporter);
procedure RIRegister_Dialogs(CL: TPSRuntimeClassImporter);

procedure Register;

implementation


uses
   Types
  ,typinfo
  ,LResources
  ,LCLIntf
  ,InterfaceBase
  ,FileUtil
  ,LCLStrConsts
  ,LCLType
  ,LCLProc
  ,Forms
  ,Controls
  ,Themes
  ,GraphType
  ,Graphics
  ,Buttons
  ,ButtonPanel
  ,StdCtrls
  ,ExtCtrls
  ,LCLClasses
  ,Dialogs
  ;
 
 
procedure Register;
begin
  RegisterComponents('Pascal Script', [TPSImport_Dialogs]);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomPrintDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TCustomPrintDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TCustomPrintDialog') do
  begin
    RegisterProperty('Collate', 'Boolean', iptrw);
    RegisterProperty('Copies', 'Integer', iptrw);
    RegisterProperty('FromPage', 'Integer', iptrw);
    RegisterProperty('MinPage', 'Integer', iptrw);
    RegisterProperty('MaxPage', 'Integer', iptrw);
    RegisterProperty('Options', 'TPrintDialogOptions', iptrw);
    RegisterProperty('PrintToFile', 'Boolean', iptrw);
    RegisterProperty('PrintRange', 'TPrintRange', iptrw);
    RegisterProperty('ToPage', 'Integer', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomPrinterSetupDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TCustomPrinterSetupDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TCustomPrinterSetupDialog') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TReplaceDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TFindDialog', 'TReplaceDialog') do
  with CL.AddClassN(CL.FindClass('TFindDialog'),'TReplaceDialog') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TFindDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TFindDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TFindDialog') do
  begin
    RegisterMethod('Procedure CloseDialog');
    RegisterProperty('Left', 'Integer', iptrw);
    RegisterProperty('Position', 'TPoint', iptrw);
    RegisterProperty('Top', 'Integer', iptrw);
    RegisterProperty('FindText', 'string', iptrw);
    RegisterProperty('Options', 'TFindOptions', iptrw);
    RegisterProperty('OnFind', 'TNotifyEvent', iptrw);
    RegisterProperty('OnHelpClicked', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TFontDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TFontDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TFontDialog') do
  begin
    RegisterMethod('Procedure ApplyClicked');
    RegisterProperty('Font', 'TFont', iptrw);
    RegisterProperty('MinFontSize', 'Integer', iptrw);
    RegisterProperty('MaxFontSize', 'Integer', iptrw);
    RegisterProperty('Options', 'TFontDialogOptions', iptrw);
    RegisterProperty('OnApplyClicked', 'TNotifyEvent', iptrw);
    RegisterProperty('PreviewText', 'string', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TColorButton(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomSpeedButton', 'TColorButton') do
  with CL.AddClassN(CL.FindClass('TCustomSpeedButton'),'TColorButton') do
  begin
    RegisterProperty('BorderWidth', 'Integer', iptrw);
    RegisterProperty('ButtonColorAutoSize', 'Boolean', iptrw);
    RegisterProperty('ButtonColorSize', 'Integer', iptrw);
    RegisterProperty('ButtonColor', 'TColor', iptrw);
    RegisterProperty('ColorDialog', 'TColorDialog', iptrw);
    RegisterProperty('OnColorChanged', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TColorDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TColorDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TColorDialog') do
  begin
    RegisterProperty('Color', 'TColor', iptrw);
    RegisterProperty('CustomColors', 'TStrings', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TSelectDirectoryDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOpenDialog', 'TSelectDirectoryDialog') do
  with CL.AddClassN(CL.FindClass('TOpenDialog'),'TSelectDirectoryDialog') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TSaveDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TOpenDialog', 'TSaveDialog') do
  with CL.AddClassN(CL.FindClass('TOpenDialog'),'TSaveDialog') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TOpenDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TFileDialog', 'TOpenDialog') do
  with CL.AddClassN(CL.FindClass('TFileDialog'),'TOpenDialog') do
  begin
    RegisterMethod('Procedure DoFolderChange');
    RegisterMethod('Procedure DoSelectionChange');
    RegisterMethod('Procedure IntfSetOption( const AOption : TOpenOption; const AValue : Boolean)');
    RegisterProperty('Options', 'TOpenOptions', iptrw);
    RegisterProperty('OnFolderChange', 'TNotifyEvent', iptrw);
    RegisterProperty('OnSelectionChange', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TFileDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCommonDialog', 'TFileDialog') do
  with CL.AddClassN(CL.FindClass('TCommonDialog'),'TFileDialog') do
  begin
    RegisterMethod('Procedure DoTypeChange');
    RegisterProperty('Files', 'TStrings', iptr);
    RegisterProperty('HistoryList', 'TStrings', iptrw);
    RegisterMethod('Procedure IntfFileTypeChanged( NewFilterIndex : Integer)');
    RegisterMethod('Function FindMaskInFilter( aFilter, aMask : string) : integer');
    RegisterMethod('Function ExtractAllFilterMasks( aFilter : string; SkipAllFilesMask : boolean) : string');
    RegisterProperty('DefaultExt', 'string', iptrw);
    RegisterProperty('FileName', 'String', iptrw);
    RegisterProperty('Filter', 'String', iptrw);
    RegisterProperty('FilterIndex', 'Integer', iptrw);
    RegisterProperty('InitialDir', 'string', iptrw);
    RegisterProperty('OnHelpClicked', 'TNotifyEvent', iptrw);
    RegisterProperty('OnTypeChange', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCommonDialog(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TLCLComponent', 'TCommonDialog') do
  with CL.AddClassN(CL.FindClass('TLCLComponent'),'TCommonDialog') do
  begin
    RegisterProperty('FCompStyle', 'LongInt', iptrw);
    RegisterMethod('Function Execute : boolean');
    RegisterProperty('Handle', 'THandle', iptrw);
    RegisterProperty('UserChoice', 'integer', iptrw);
    RegisterMethod('Procedure Close');
    RegisterMethod('Procedure DoShow');
    RegisterMethod('Procedure DoCanClose( var CanClose : Boolean)');
    RegisterMethod('Procedure DoClose');
    RegisterMethod('Function HandleAllocated : boolean');
    RegisterProperty('OnClose', 'TNotifyEvent', iptrw);
    RegisterProperty('OnCanClose', 'TCloseQueryEvent', iptrw);
    RegisterProperty('OnShow', 'TNotifyEvent', iptrw);
    RegisterProperty('HelpContext', 'THelpContext', iptrw);
    RegisterProperty('Width', 'integer', iptrw);
    RegisterProperty('Height', 'integer', iptrw);
    RegisterProperty('Title', 'TTranslateString', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_Dialogs(CL: TPSPascalCompiler);
begin
  CL.AddTypeS('TMsgDlgType', '( mtWarning, mtError, mtInformation, mtConfirmati'
   +'on, mtCustom )');
  CL.AddTypeS('TMsgDlgBtn', '( mbYes, mbNo, mbOK, mbCancel, mbAbort, mbRetry, m'
   +'bIgnore, mbAll, mbNoToAll, mbYesToAll, mbHelp, mbClose )');
  CL.AddTypeS('TMsgDlgButtons', 'set of TMsgDlgBtn');
 CL.AddConstantN('mbYesNoCancel','LongInt').Value.ts32 := ord(mbYes) or ord(mbNo) or ord(mbCancel);
 CL.AddConstantN('mbYesNo','LongInt').Value.ts32 := ord(mbYes) or ord(mbNo);
 CL.AddConstantN('mbOKCancel','LongInt').Value.ts32 := ord(mbOK) or ord(mbCancel);
 CL.AddConstantN('mbAbortRetryIgnore','LongInt').Value.ts32 := ord(mbAbort) or ord(mbRetry) or ord(mbIgnore);
  SIRegister_TCommonDialog(CL);
  SIRegister_TFileDialog(CL);
  CL.AddTypeS('TOpenOption', '( ofReadOnly, ofOverwritePrompt, ofHideReadOnly, '
   +'ofNoChangeDir, ofShowHelp, ofNoValidate, ofAllowMultiSelect, ofExtensionDi'
   +'fferent, ofPathMustExist, ofFileMustExist, ofCreatePrompt, ofShareAware, o'
   +'fNoReadOnlyReturn, ofNoTestFileCreate, ofNoNetworkButton, ofNoLongNames, o'
   +'fOldStyleDialog, ofNoDereferenceLinks, ofEnableIncludeNotify, ofEnableSizi'
   +'ng, ofDontAddToRecent, ofForceShowHidden, ofViewDetail, ofAutoPreview )');
  CL.AddTypeS('TOpenOptions', 'set of TOpenOption');
 CL.AddConstantN('DefaultOpenDialogOptions','LongInt').Value.ts32 := ord(ofEnableSizing) or ord(ofViewDetail);
  SIRegister_TOpenDialog(CL);
  SIRegister_TSaveDialog(CL);
  SIRegister_TSelectDirectoryDialog(CL);
  SIRegister_TColorDialog(CL);
  SIRegister_TColorButton(CL);
  CL.AddTypeS('TFontDialogOption', '( fdAnsiOnly, fdTrueTypeOnly, fdEffects, fd'
   +'FixedPitchOnly, fdForceFontExist, fdNoFaceSel, fdNoOEMFonts, fdNoSimulatio'
   +'ns, fdNoSizeSel, fdNoStyleSel, fdNoVectorFonts, fdShowHelp, fdWysiwyg, fdL'
   +'imitSize, fdScalableOnly, fdApplyButton )');
  CL.AddTypeS('TFontDialogOptions', 'set of TFontDialogOption');
  SIRegister_TFontDialog(CL);
  CL.AddTypeS('TFindOption', '( frDown, frFindNext, frHideMatchCase, frHideWhol'
   +'eWord, frHideUpDown, frMatchCase, frDisableMatchCase, frDisableUpDown, frD'
   +'isableWholeWord, frReplace, frReplaceAll, frWholeWord, frShowHelp, frEntir'
   +'eScope, frHideEntireScope, frPromptOnReplace, frHidePromptOnReplace )');
  CL.AddTypeS('TFindOptions', 'set of TFindOption');
  SIRegister_TFindDialog(CL);
  SIRegister_TReplaceDialog(CL);
  SIRegister_TCustomPrinterSetupDialog(CL);
  CL.AddTypeS('TPrintRange', '( prAllPages, prSelection, prPageNums, prCurrentP'
   +'age )');
  CL.AddTypeS('TPrintDialogOption', '( poPrintToFile, poPageNums, poSelection, '
   +'poWarning, poHelp, poDisablePrintToFile )');
  CL.AddTypeS('TPrintDialogOptions', 'set of TPrintDialogOption');
  SIRegister_TCustomPrintDialog(CL);
 CL.AddDelphiFunction('Function MessageDlg( const aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; HelpCtx : Longint) : TModalResult');
 CL.AddDelphiFunction('Function MessageDlg( const aCaption, aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; HelpCtx : Longint) : TModalResult');
 CL.AddDelphiFunction('Function MessageDlg( const aCaption, aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; HelpCtx : Longint; DefaultButton : TMsgDlgBtn) : TModalResult');
 CL.AddDelphiFunction('Function MessageDlg( const aCaption, aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; const HelpKeyword : string) : TModalResult');
 CL.AddDelphiFunction('Function MessageDlgPos( const aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; HelpCtx : Longint; X, Y : Integer) : TModalResult');
 CL.AddDelphiFunction('Function MessageDlgPosHelp( const aMsg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons; HelpCtx : Longint; X, Y : Integer; const HelpFileName : string) : TModalResult');
 CL.AddDelphiFunction('Function CreateMessageDialog( const Msg : string; DlgType : TMsgDlgType; Buttons : TMsgDlgButtons) : TForm');
 CL.AddDelphiFunction('Function QuestionDlg( const aCaption, aMsg : string; DlgType : TMsgDlgType; Buttons : array of const; HelpCtx : Longint) : TModalResult');
 CL.AddDelphiFunction('Function QuestionDlg( const aCaption, aMsg : string; DlgType : TMsgDlgType; Buttons : array of const; const HelpKeyword : string) : TModalResult');
 CL.AddDelphiFunction('Procedure ShowMessage( const aMsg : string)');
 CL.AddDelphiFunction('Procedure ShowMessageFmt( const aMsg : string; Params : array of const)');
 CL.AddDelphiFunction('Procedure ShowMessagePos( const aMsg : string; X, Y : Integer)');
 CL.AddDelphiFunction('Function InputQuery( const ACaption, APrompt : String; MaskInput : Boolean; var Value : String) : Boolean');
 CL.AddDelphiFunction('Function InputQuery( const ACaption, APrompt : String; var Value : String) : Boolean');
 CL.AddDelphiFunction('Function InputBox( const ACaption, APrompt, ADefault : String) : String');
 CL.AddDelphiFunction('Function PasswordBox( const ACaption, APrompt : String) : String');
  CL.AddTypeS('TSelectDirOpt', '( sdAllowCreate, sdPerformCreate, sdPrompt )');
  CL.AddTypeS('TSelectDirOpts', 'set of TSelectDirOpt');
 CL.AddDelphiFunction('Function SelectDirectory( const Caption, InitialDirectory : string; out Directory : string) : boolean');
 CL.AddDelphiFunction('Function SelectDirectory( const Caption, InitialDirectory : string; out Directory : string; ShowHidden : boolean; HelpCtx : Longint) : boolean');
 CL.AddDelphiFunction('Function SelectDirectory( out Directory : string; Options : TSelectDirOpts; HelpCtx : Longint) : Boolean');
 CL.AddDelphiFunction('Function ExtractColorIndexAndColor( const AColorList : TStrings; const AIndex : Integer; out ColorIndex : Integer; out ColorValue : TColor) : Boolean');
 CL.AddDelphiFunction('Function GetDialogCaption( idDiag : Integer) : String');
 CL.AddDelphiFunction('Function GetDialogIcon( idDiag : Integer) : TCustomBitmap');
 CL.AddDelphiFunction('Function dbgs0( Option : TOpenOption) : string;');
 CL.AddDelphiFunction('Function dbgs1( Options : TOpenOptions) : string;');
 CL.AddDelphiFunction('Procedure Register');
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
Function dbgs1( Options : TOpenOptions) : string;
Begin Result := Dialogs.dbgs(Options); END;

(*----------------------------------------------------------------------------*)
Function dbgs0( Option : TOpenOption) : string;
Begin Result := Dialogs.dbgs(Option); END;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogToPage_W(Self: TCustomPrintDialog; const T: Integer);
begin Self.ToPage := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogToPage_R(Self: TCustomPrintDialog; var T: Integer);
begin T := Self.ToPage; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogPrintRange_W(Self: TCustomPrintDialog; const T: TPrintRange);
begin Self.PrintRange := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogPrintRange_R(Self: TCustomPrintDialog; var T: TPrintRange);
begin T := Self.PrintRange; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogPrintToFile_W(Self: TCustomPrintDialog; const T: Boolean);
begin Self.PrintToFile := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogPrintToFile_R(Self: TCustomPrintDialog; var T: Boolean);
begin T := Self.PrintToFile; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogOptions_W(Self: TCustomPrintDialog; const T: TPrintDialogOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogOptions_R(Self: TCustomPrintDialog; var T: TPrintDialogOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogMaxPage_W(Self: TCustomPrintDialog; const T: Integer);
begin Self.MaxPage := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogMaxPage_R(Self: TCustomPrintDialog; var T: Integer);
begin T := Self.MaxPage; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogMinPage_W(Self: TCustomPrintDialog; const T: Integer);
begin Self.MinPage := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogMinPage_R(Self: TCustomPrintDialog; var T: Integer);
begin T := Self.MinPage; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogFromPage_W(Self: TCustomPrintDialog; const T: Integer);
begin Self.FromPage := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogFromPage_R(Self: TCustomPrintDialog; var T: Integer);
begin T := Self.FromPage; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogCopies_W(Self: TCustomPrintDialog; const T: Integer);
begin Self.Copies := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogCopies_R(Self: TCustomPrintDialog; var T: Integer);
begin T := Self.Copies; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogCollate_W(Self: TCustomPrintDialog; const T: Boolean);
begin Self.Collate := T; end;

(*----------------------------------------------------------------------------*)
procedure TCustomPrintDialogCollate_R(Self: TCustomPrintDialog; var T: Boolean);
begin T := Self.Collate; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOnHelpClicked_W(Self: TFindDialog; const T: TNotifyEvent);
begin Self.OnHelpClicked := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOnHelpClicked_R(Self: TFindDialog; var T: TNotifyEvent);
begin T := Self.OnHelpClicked; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOnFind_W(Self: TFindDialog; const T: TNotifyEvent);
begin Self.OnFind := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOnFind_R(Self: TFindDialog; var T: TNotifyEvent);
begin T := Self.OnFind; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOptions_W(Self: TFindDialog; const T: TFindOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogOptions_R(Self: TFindDialog; var T: TFindOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogFindText_W(Self: TFindDialog; const T: string);
begin Self.FindText := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogFindText_R(Self: TFindDialog; var T: string);
begin T := Self.FindText; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogTop_W(Self: TFindDialog; const T: Integer);
begin Self.Top := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogTop_R(Self: TFindDialog; var T: Integer);
begin T := Self.Top; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogPosition_W(Self: TFindDialog; const T: TPoint);
begin Self.Position := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogPosition_R(Self: TFindDialog; var T: TPoint);
begin T := Self.Position; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogLeft_W(Self: TFindDialog; const T: Integer);
begin Self.Left := T; end;

(*----------------------------------------------------------------------------*)
procedure TFindDialogLeft_R(Self: TFindDialog; var T: Integer);
begin T := Self.Left; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogPreviewText_W(Self: TFontDialog; const T: string);
begin Self.PreviewText := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogPreviewText_R(Self: TFontDialog; var T: string);
begin T := Self.PreviewText; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogOnApplyClicked_W(Self: TFontDialog; const T: TNotifyEvent);
begin Self.OnApplyClicked := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogOnApplyClicked_R(Self: TFontDialog; var T: TNotifyEvent);
begin T := Self.OnApplyClicked; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogOptions_W(Self: TFontDialog; const T: TFontDialogOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogOptions_R(Self: TFontDialog; var T: TFontDialogOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogMaxFontSize_W(Self: TFontDialog; const T: Integer);
begin Self.MaxFontSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogMaxFontSize_R(Self: TFontDialog; var T: Integer);
begin T := Self.MaxFontSize; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogMinFontSize_W(Self: TFontDialog; const T: Integer);
begin Self.MinFontSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogMinFontSize_R(Self: TFontDialog; var T: Integer);
begin T := Self.MinFontSize; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogFont_W(Self: TFontDialog; const T: TFont);
begin Self.Font := T; end;

(*----------------------------------------------------------------------------*)
procedure TFontDialogFont_R(Self: TFontDialog; var T: TFont);
begin T := Self.Font; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonOnColorChanged_W(Self: TColorButton; const T: TNotifyEvent);
begin Self.OnColorChanged := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonOnColorChanged_R(Self: TColorButton; var T: TNotifyEvent);
begin T := Self.OnColorChanged; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonColorDialog_W(Self: TColorButton; const T: TColorDialog);
begin Self.ColorDialog := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonColorDialog_R(Self: TColorButton; var T: TColorDialog);
begin T := Self.ColorDialog; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColor_W(Self: TColorButton; const T: TColor);
begin Self.ButtonColor := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColor_R(Self: TColorButton; var T: TColor);
begin T := Self.ButtonColor; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColorSize_W(Self: TColorButton; const T: Integer);
begin Self.ButtonColorSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColorSize_R(Self: TColorButton; var T: Integer);
begin T := Self.ButtonColorSize; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColorAutoSize_W(Self: TColorButton; const T: Boolean);
begin Self.ButtonColorAutoSize := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonButtonColorAutoSize_R(Self: TColorButton; var T: Boolean);
begin T := Self.ButtonColorAutoSize; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonBorderWidth_W(Self: TColorButton; const T: Integer);
begin Self.BorderWidth := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorButtonBorderWidth_R(Self: TColorButton; var T: Integer);
begin T := Self.BorderWidth; end;

(*----------------------------------------------------------------------------*)
procedure TColorDialogCustomColors_W(Self: TColorDialog; const T: TStrings);
begin Self.CustomColors := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorDialogCustomColors_R(Self: TColorDialog; var T: TStrings);
begin T := Self.CustomColors; end;

(*----------------------------------------------------------------------------*)
procedure TColorDialogColor_W(Self: TColorDialog; const T: TColor);
begin Self.Color := T; end;

(*----------------------------------------------------------------------------*)
procedure TColorDialogColor_R(Self: TColorDialog; var T: TColor);
begin T := Self.Color; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOnSelectionChange_W(Self: TOpenDialog; const T: TNotifyEvent);
begin Self.OnSelectionChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOnSelectionChange_R(Self: TOpenDialog; var T: TNotifyEvent);
begin T := Self.OnSelectionChange; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOnFolderChange_W(Self: TOpenDialog; const T: TNotifyEvent);
begin Self.OnFolderChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOnFolderChange_R(Self: TOpenDialog; var T: TNotifyEvent);
begin T := Self.OnFolderChange; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOptions_W(Self: TOpenDialog; const T: TOpenOptions);
begin Self.Options := T; end;

(*----------------------------------------------------------------------------*)
procedure TOpenDialogOptions_R(Self: TOpenDialog; var T: TOpenOptions);
begin T := Self.Options; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogOnTypeChange_W(Self: TFileDialog; const T: TNotifyEvent);
begin Self.OnTypeChange := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogOnTypeChange_R(Self: TFileDialog; var T: TNotifyEvent);
begin T := Self.OnTypeChange; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogOnHelpClicked_W(Self: TFileDialog; const T: TNotifyEvent);
begin Self.OnHelpClicked := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogOnHelpClicked_R(Self: TFileDialog; var T: TNotifyEvent);
begin T := Self.OnHelpClicked; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogInitialDir_W(Self: TFileDialog; const T: string);
begin Self.InitialDir := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogInitialDir_R(Self: TFileDialog; var T: string);
begin T := Self.InitialDir; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFilterIndex_W(Self: TFileDialog; const T: Integer);
begin Self.FilterIndex := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFilterIndex_R(Self: TFileDialog; var T: Integer);
begin T := Self.FilterIndex; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFilter_W(Self: TFileDialog; const T: String);
begin Self.Filter := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFilter_R(Self: TFileDialog; var T: String);
begin T := Self.Filter; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFileName_W(Self: TFileDialog; const T: String);
begin Self.FileName := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFileName_R(Self: TFileDialog; var T: String);
begin T := Self.FileName; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogDefaultExt_W(Self: TFileDialog; const T: string);
begin Self.DefaultExt := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogDefaultExt_R(Self: TFileDialog; var T: string);
begin T := Self.DefaultExt; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogHistoryList_W(Self: TFileDialog; const T: TStrings);
begin Self.HistoryList := T; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogHistoryList_R(Self: TFileDialog; var T: TStrings);
begin T := Self.HistoryList; end;

(*----------------------------------------------------------------------------*)
procedure TFileDialogFiles_R(Self: TFileDialog; var T: TStrings);
begin T := Self.Files; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogTitle_W(Self: TCommonDialog; const T: TTranslateString);
begin Self.Title := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogTitle_R(Self: TCommonDialog; var T: TTranslateString);
begin T := Self.Title; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHeight_W(Self: TCommonDialog; const T: integer);
begin Self.Height := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHeight_R(Self: TCommonDialog; var T: integer);
begin T := Self.Height; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogWidth_W(Self: TCommonDialog; const T: integer);
begin Self.Width := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogWidth_R(Self: TCommonDialog; var T: integer);
begin T := Self.Width; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHelpContext_W(Self: TCommonDialog; const T: THelpContext);
begin Self.HelpContext := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHelpContext_R(Self: TCommonDialog; var T: THelpContext);
begin T := Self.HelpContext; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnShow_W(Self: TCommonDialog; const T: TNotifyEvent);
begin Self.OnShow := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnShow_R(Self: TCommonDialog; var T: TNotifyEvent);
begin T := Self.OnShow; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnCanClose_W(Self: TCommonDialog; const T: TCloseQueryEvent);
begin Self.OnCanClose := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnCanClose_R(Self: TCommonDialog; var T: TCloseQueryEvent);
begin T := Self.OnCanClose; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnClose_W(Self: TCommonDialog; const T: TNotifyEvent);
begin Self.OnClose := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogOnClose_R(Self: TCommonDialog; var T: TNotifyEvent);
begin T := Self.OnClose; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogUserChoice_W(Self: TCommonDialog; const T: integer);
begin Self.UserChoice := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogUserChoice_R(Self: TCommonDialog; var T: integer);
begin T := Self.UserChoice; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHandle_W(Self: TCommonDialog; const T: THandle);
begin Self.Handle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogHandle_R(Self: TCommonDialog; var T: THandle);
begin T := Self.Handle; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogFCompStyle_W(Self: TCommonDialog; const T: LongInt);
Begin Self.FCompStyle := T; end;

(*----------------------------------------------------------------------------*)
procedure TCommonDialogFCompStyle_R(Self: TCommonDialog; var T: LongInt);
Begin T := Self.FCompStyle; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_Dialogs_Routines(S: TPSExec);
begin
 S.RegisterDelphiFunction(@MessageDlg, 'MessageDlg', cdRegister);
 S.RegisterDelphiFunction(@MessageDlg, 'MessageDlg', cdRegister);
 S.RegisterDelphiFunction(@MessageDlg, 'MessageDlg', cdRegister);
 S.RegisterDelphiFunction(@MessageDlg, 'MessageDlg', cdRegister);
 S.RegisterDelphiFunction(@MessageDlgPos, 'MessageDlgPos', cdRegister);
 S.RegisterDelphiFunction(@MessageDlgPosHelp, 'MessageDlgPosHelp', cdRegister);
 S.RegisterDelphiFunction(@CreateMessageDialog, 'CreateMessageDialog', cdRegister);
 S.RegisterDelphiFunction(@QuestionDlg, 'QuestionDlg', cdRegister);
 S.RegisterDelphiFunction(@QuestionDlg, 'QuestionDlg', cdRegister);
 S.RegisterDelphiFunction(@ShowMessage, 'ShowMessage', cdRegister);
 S.RegisterDelphiFunction(@ShowMessageFmt, 'ShowMessageFmt', cdRegister);
 S.RegisterDelphiFunction(@ShowMessagePos, 'ShowMessagePos', cdRegister);
 S.RegisterDelphiFunction(@InputQuery, 'InputQuery', cdRegister);
 S.RegisterDelphiFunction(@InputQuery, 'InputQuery', cdRegister);
 S.RegisterDelphiFunction(@InputBox, 'InputBox', cdRegister);
 S.RegisterDelphiFunction(@PasswordBox, 'PasswordBox', cdRegister);
 S.RegisterDelphiFunction(@SelectDirectory, 'SelectDirectory', cdRegister);
 S.RegisterDelphiFunction(@SelectDirectory, 'SelectDirectory', cdRegister);
 S.RegisterDelphiFunction(@SelectDirectory, 'SelectDirectory', cdRegister);
 S.RegisterDelphiFunction(@ExtractColorIndexAndColor, 'ExtractColorIndexAndColor', cdRegister);
 S.RegisterDelphiFunction(@GetDialogCaption, 'GetDialogCaption', cdRegister);
 S.RegisterDelphiFunction(@GetDialogIcon, 'GetDialogIcon', cdRegister);
 S.RegisterDelphiFunction(@dbgs0, 'dbgs0', cdRegister);
 S.RegisterDelphiFunction(@dbgs1, 'dbgs1', cdRegister);
 S.RegisterDelphiFunction(@Register, 'Register', cdRegister);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomPrintDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomPrintDialog) do
  begin
    RegisterPropertyHelper(@TCustomPrintDialogCollate_R,@TCustomPrintDialogCollate_W,'Collate');
    RegisterPropertyHelper(@TCustomPrintDialogCopies_R,@TCustomPrintDialogCopies_W,'Copies');
    RegisterPropertyHelper(@TCustomPrintDialogFromPage_R,@TCustomPrintDialogFromPage_W,'FromPage');
    RegisterPropertyHelper(@TCustomPrintDialogMinPage_R,@TCustomPrintDialogMinPage_W,'MinPage');
    RegisterPropertyHelper(@TCustomPrintDialogMaxPage_R,@TCustomPrintDialogMaxPage_W,'MaxPage');
    RegisterPropertyHelper(@TCustomPrintDialogOptions_R,@TCustomPrintDialogOptions_W,'Options');
    RegisterPropertyHelper(@TCustomPrintDialogPrintToFile_R,@TCustomPrintDialogPrintToFile_W,'PrintToFile');
    RegisterPropertyHelper(@TCustomPrintDialogPrintRange_R,@TCustomPrintDialogPrintRange_W,'PrintRange');
    RegisterPropertyHelper(@TCustomPrintDialogToPage_R,@TCustomPrintDialogToPage_W,'ToPage');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomPrinterSetupDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCustomPrinterSetupDialog) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TReplaceDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TReplaceDialog) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TFindDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TFindDialog) do
  begin
    RegisterMethod(@TFindDialog.CloseDialog, 'CloseDialog');
    RegisterPropertyHelper(@TFindDialogLeft_R,@TFindDialogLeft_W,'Left');
    RegisterPropertyHelper(@TFindDialogPosition_R,@TFindDialogPosition_W,'Position');
    RegisterPropertyHelper(@TFindDialogTop_R,@TFindDialogTop_W,'Top');
    RegisterPropertyHelper(@TFindDialogFindText_R,@TFindDialogFindText_W,'FindText');
    RegisterPropertyHelper(@TFindDialogOptions_R,@TFindDialogOptions_W,'Options');
    RegisterPropertyHelper(@TFindDialogOnFind_R,@TFindDialogOnFind_W,'OnFind');
    RegisterPropertyHelper(@TFindDialogOnHelpClicked_R,@TFindDialogOnHelpClicked_W,'OnHelpClicked');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TFontDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TFontDialog) do
  begin
    RegisterVirtualMethod(@TFontDialog.ApplyClicked, 'ApplyClicked');
    RegisterPropertyHelper(@TFontDialogFont_R,@TFontDialogFont_W,'Font');
    RegisterPropertyHelper(@TFontDialogMinFontSize_R,@TFontDialogMinFontSize_W,'MinFontSize');
    RegisterPropertyHelper(@TFontDialogMaxFontSize_R,@TFontDialogMaxFontSize_W,'MaxFontSize');
    RegisterPropertyHelper(@TFontDialogOptions_R,@TFontDialogOptions_W,'Options');
    RegisterPropertyHelper(@TFontDialogOnApplyClicked_R,@TFontDialogOnApplyClicked_W,'OnApplyClicked');
    RegisterPropertyHelper(@TFontDialogPreviewText_R,@TFontDialogPreviewText_W,'PreviewText');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TColorButton(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TColorButton) do
  begin
    RegisterPropertyHelper(@TColorButtonBorderWidth_R,@TColorButtonBorderWidth_W,'BorderWidth');
    RegisterPropertyHelper(@TColorButtonButtonColorAutoSize_R,@TColorButtonButtonColorAutoSize_W,'ButtonColorAutoSize');
    RegisterPropertyHelper(@TColorButtonButtonColorSize_R,@TColorButtonButtonColorSize_W,'ButtonColorSize');
    RegisterPropertyHelper(@TColorButtonButtonColor_R,@TColorButtonButtonColor_W,'ButtonColor');
    RegisterPropertyHelper(@TColorButtonColorDialog_R,@TColorButtonColorDialog_W,'ColorDialog');
    RegisterPropertyHelper(@TColorButtonOnColorChanged_R,@TColorButtonOnColorChanged_W,'OnColorChanged');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TColorDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TColorDialog) do
  begin
    RegisterPropertyHelper(@TColorDialogColor_R,@TColorDialogColor_W,'Color');
    RegisterPropertyHelper(@TColorDialogCustomColors_R,@TColorDialogCustomColors_W,'CustomColors');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TSelectDirectoryDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TSelectDirectoryDialog) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TSaveDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TSaveDialog) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TOpenDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOpenDialog) do
  begin
    RegisterVirtualMethod(@TOpenDialog.DoFolderChange, 'DoFolderChange');
    RegisterVirtualMethod(@TOpenDialog.DoSelectionChange, 'DoSelectionChange');
    RegisterMethod(@TOpenDialog.IntfSetOption, 'IntfSetOption');
    RegisterPropertyHelper(@TOpenDialogOptions_R,@TOpenDialogOptions_W,'Options');
    RegisterPropertyHelper(@TOpenDialogOnFolderChange_R,@TOpenDialogOnFolderChange_W,'OnFolderChange');
    RegisterPropertyHelper(@TOpenDialogOnSelectionChange_R,@TOpenDialogOnSelectionChange_W,'OnSelectionChange');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TFileDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TFileDialog) do
  begin
    RegisterVirtualMethod(@TFileDialog.DoTypeChange, 'DoTypeChange');
    RegisterPropertyHelper(@TFileDialogFiles_R,nil,'Files');
    RegisterPropertyHelper(@TFileDialogHistoryList_R,@TFileDialogHistoryList_W,'HistoryList');
    RegisterMethod(@TFileDialog.IntfFileTypeChanged, 'IntfFileTypeChanged');
    RegisterMethod(@TFileDialog.FindMaskInFilter, 'FindMaskInFilter');
    RegisterMethod(@TFileDialog.ExtractAllFilterMasks, 'ExtractAllFilterMasks');
    RegisterPropertyHelper(@TFileDialogDefaultExt_R,@TFileDialogDefaultExt_W,'DefaultExt');
    RegisterPropertyHelper(@TFileDialogFileName_R,@TFileDialogFileName_W,'FileName');
    RegisterPropertyHelper(@TFileDialogFilter_R,@TFileDialogFilter_W,'Filter');
    RegisterPropertyHelper(@TFileDialogFilterIndex_R,@TFileDialogFilterIndex_W,'FilterIndex');
    RegisterPropertyHelper(@TFileDialogInitialDir_R,@TFileDialogInitialDir_W,'InitialDir');
    RegisterPropertyHelper(@TFileDialogOnHelpClicked_R,@TFileDialogOnHelpClicked_W,'OnHelpClicked');
    RegisterPropertyHelper(@TFileDialogOnTypeChange_R,@TFileDialogOnTypeChange_W,'OnTypeChange');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCommonDialog(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TCommonDialog) do
  begin
    RegisterPropertyHelper(@TCommonDialogFCompStyle_R,@TCommonDialogFCompStyle_W,'FCompStyle');
    RegisterVirtualMethod(@TCommonDialog.Execute, 'Execute');
    RegisterPropertyHelper(@TCommonDialogHandle_R,@TCommonDialogHandle_W,'Handle');
    RegisterPropertyHelper(@TCommonDialogUserChoice_R,@TCommonDialogUserChoice_W,'UserChoice');
    RegisterVirtualMethod(@TCommonDialog.Close, 'Close');
    RegisterVirtualMethod(@TCommonDialog.DoShow, 'DoShow');
    RegisterVirtualMethod(@TCommonDialog.DoCanClose, 'DoCanClose');
    RegisterVirtualMethod(@TCommonDialog.DoClose, 'DoClose');
    RegisterMethod(@TCommonDialog.HandleAllocated, 'HandleAllocated');
    RegisterPropertyHelper(@TCommonDialogOnClose_R,@TCommonDialogOnClose_W,'OnClose');
    RegisterPropertyHelper(@TCommonDialogOnCanClose_R,@TCommonDialogOnCanClose_W,'OnCanClose');
    RegisterPropertyHelper(@TCommonDialogOnShow_R,@TCommonDialogOnShow_W,'OnShow');
    RegisterPropertyHelper(@TCommonDialogHelpContext_R,@TCommonDialogHelpContext_W,'HelpContext');
    RegisterPropertyHelper(@TCommonDialogWidth_R,@TCommonDialogWidth_W,'Width');
    RegisterPropertyHelper(@TCommonDialogHeight_R,@TCommonDialogHeight_W,'Height');
    RegisterPropertyHelper(@TCommonDialogTitle_R,@TCommonDialogTitle_W,'Title');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_Dialogs(CL: TPSRuntimeClassImporter);
begin
  RIRegister_TCommonDialog(CL);
  RIRegister_TFileDialog(CL);
  RIRegister_TOpenDialog(CL);
  RIRegister_TSaveDialog(CL);
  RIRegister_TSelectDirectoryDialog(CL);
  RIRegister_TColorDialog(CL);
  RIRegister_TColorButton(CL);
  RIRegister_TFontDialog(CL);
  RIRegister_TFindDialog(CL);
  RIRegister_TReplaceDialog(CL);
  RIRegister_TCustomPrinterSetupDialog(CL);
  RIRegister_TCustomPrintDialog(CL);
end;

 
 
{ TPSImport_Dialogs }
(*----------------------------------------------------------------------------*)
procedure TPSImport_Dialogs.CompileImport1(CompExec: TPSScript);
begin
  SIRegister_Dialogs(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_Dialogs.ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  RIRegister_Dialogs(ri);
  RIRegister_Dialogs_Routines(CompExec.Exec); // comment it if no routines
end;
(*----------------------------------------------------------------------------*)
 
 
end.
